/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.AbstractFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.ConstantFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.Randoms;

public class UniformFactor
extends AbstractFactor {
    private Variable var;
    private double min;
    private double max;
    private double val;

    public UniformFactor(Variable var, double min2, double max) {
        this(var, min2, max, 1.0 / (max - min2));
    }

    public UniformFactor(Variable var, double min2, double max, double val) {
        super(new HashVarSet(new Variable[]{var}));
        if (!var.isContinuous()) {
            throw new IllegalArgumentException();
        }
        if (min2 >= max) {
            throw new IllegalArgumentException();
        }
        this.var = var;
        this.min = min2;
        this.max = max;
        this.val = val;
    }

    @Override
    protected Factor extractMaxInternal(VarSet varSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double value(Assignment assn) {
        double x = assn.getDouble(this.var);
        if (this.min < x && x < this.max) {
            return this.val;
        }
        return 0.0;
    }

    @Override
    protected double lookupValueInternal(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Factor marginalizeInternal(VarSet varsToKeep) {
        if (varsToKeep.contains(this.var)) {
            return this.duplicate();
        }
        return new ConstantFactor(this.val * (this.max - this.min));
    }

    @Override
    public Factor normalize() {
        this.val = 1.0 / (this.max - this.min);
        return this;
    }

    @Override
    public Assignment sample(Randoms r) {
        double val = r.nextUniform(this.min, this.max);
        return new Assignment(this.var, val);
    }

    @Override
    public boolean almostEquals(Factor p, double epsilon) {
        return this.equals(p);
    }

    @Override
    public Factor duplicate() {
        return new UniformFactor(this.var, this.min, this.max);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.min) || Double.isNaN(this.max);
    }

    @Override
    public String dumpToString() {
        return this.toString();
    }

    @Override
    public void multiplyBy(Factor other) {
        if (other instanceof ConstantFactor) {
            this.val *= other.value(new Assignment());
        } else {
            throw new UnsupportedOperationException("Can't multiply uniform factor by " + other);
        }
    }

    @Override
    public void divideBy(Factor other) {
        if (other instanceof ConstantFactor) {
            this.val /= other.value(new Assignment());
        } else {
            throw new UnsupportedOperationException("Can't divide uniform factor by " + other);
        }
    }

    public String toString() {
        return "[UniformFactor " + this.var + " " + this.min + " ... " + this.max + " ]";
    }

    @Override
    public Factor slice(Assignment assn) {
        if (assn.containsVar(this.var)) {
            return new ConstantFactor(this.value(assn));
        }
        return this.duplicate();
    }
}

