/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.Graphs;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org._3pq.jgrapht.UndirectedGraph;
import org._3pq.jgrapht.alg.ConnectivityInspector;

public class UndirectedModel
extends FactorGraph {
    private Set edges = new THashSet();

    public UndirectedModel() {
    }

    public UndirectedModel(Variable[] vars) {
        super(vars);
    }

    public UndirectedModel(int capacity) {
        super(capacity);
    }

    public Set getEdgeSet() {
        return Collections.unmodifiableSet(this.edges);
    }

    @Override
    public void addFactor(Factor factor) {
        super.addFactor(factor);
        if (factor.varSet().size() == 2) {
            this.edges.add(factor.varSet());
        }
    }

    public static UndirectedModel createBoltzmannMachine(double[][] weights, double[] biases) {
        if (weights.length != biases.length) {
            throw new IllegalArgumentException("Number of weights " + weights.length + " not equal to number of biases " + biases.length);
        }
        int numV = weights.length;
        Variable[] vars = new Variable[numV];
        int i = 0;
        while (i < numV) {
            vars[i] = new Variable(2);
            ++i;
        }
        UndirectedModel mdl = new UndirectedModel(vars);
        int i2 = 0;
        while (i2 < numV) {
            TableFactor nodePtl = new TableFactor(vars[i2], new double[]{1.0, Math.exp(biases[i2])});
            mdl.addFactor(nodePtl);
            int j = i2 + 1;
            while (j < numV) {
                if (weights[i2][j] != 0.0) {
                    double[] ptl = new double[]{1.0, 1.0, 1.0, Math.exp(weights[i2][j])};
                    mdl.addFactor(vars[i2], vars[j], ptl);
                }
                ++j;
            }
            ++i2;
        }
        return mdl;
    }

    public boolean isConnected(Variable v1, Variable v2) {
        UndirectedGraph g2 = Graphs.mdlToGraph(this);
        ConnectivityInspector ins = new ConnectivityInspector(g2);
        return g2.containsVertex(v1) && g2.containsVertex(v2) && ins.pathExists(v1, v2);
    }
}

