/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.inference.Utils;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.DenseAssignmentIterator;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class HashVarSet
implements VarSet,
Serializable {
    private THashSet verts = new THashSet();
    private ArrayList vertsList = new ArrayList();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public HashVarSet() {
    }

    public HashVarSet(Collection c) {
        this.addAll(c);
    }

    public HashVarSet(Variable[] vars) {
        this.addAll(Arrays.asList(vars));
    }

    @Override
    public Variable get(int idx) {
        return (Variable)this.vertsList.get(idx);
    }

    public String getLabel() {
        return this.toString();
    }

    @Override
    public VarSet intersection(VarSet c) {
        return Utils.defaultIntersection(this, c);
    }

    @Override
    public int hashCode() {
        int ret = 39;
        for (Object o : this.vertsList) {
            ret = 59 * ret + o.hashCode();
        }
        return ret;
    }

    @Override
    public boolean equals(Object object) {
        return this.verts.equals(object);
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean ret = true;
        for (Object o : collection) {
            ret = this.remove(o) & ret;
        }
        return ret;
    }

    @Override
    public Variable[] toVariableArray() {
        return this.vertsList.toArray(new Variable[this.size()]);
    }

    public String toString() {
        String val = "(C";
        Iterator it = this.iterator();
        while (it.hasNext()) {
            val = String.valueOf(val) + " ";
            val = String.valueOf(val) + it.next().toString();
        }
        val = String.valueOf(val) + ")";
        return val;
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean ret = true;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            ret &= this.add(it.next(), false);
        }
        Collections.sort(this.vertsList);
        return ret;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.vertsList.toArray(objectArray);
    }

    @Override
    public Object[] toArray() {
        return this.vertsList.toArray();
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.verts.containsAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.verts.retainAll(collection);
    }

    public Object clone() {
        return this.verts.clone();
    }

    @Override
    public boolean add(Object object) {
        return this.add(object, true);
    }

    public boolean add(Object object, boolean checkSorted) {
        if (!(object instanceof Variable)) {
            throw new IllegalArgumentException(object.toString());
        }
        if (!this.verts.contains(object)) {
            this.vertsList.add(object);
            boolean ret = this.verts.add(object);
            if (checkSorted) {
                Collections.sort(this.vertsList);
            }
            return ret;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return this.verts.contains(object);
    }

    @Override
    public int size() {
        return this.verts.size();
    }

    @Override
    public int weight() {
        int tot = 1;
        int i = 0;
        while (i < this.vertsList.size()) {
            Variable var = (Variable)this.vertsList.get(i);
            tot *= var.getNumOutcomes();
            ++i;
        }
        return tot;
    }

    @Override
    public Iterator iterator() {
        return this.vertsList.iterator();
    }

    @Override
    public boolean remove(Object object) {
        this.vertsList.remove(object);
        return this.verts.remove(object);
    }

    @Override
    public void clear() {
        this.vertsList.clear();
        this.verts.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.verts.isEmpty();
    }

    @Override
    public AssignmentIterator assignmentIterator() {
        return new DenseAssignmentIterator(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
        out.writeInt(this.size());
        int vi = 0;
        while (vi < this.size()) {
            out.writeObject(this.get(vi));
            ++vi;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version2 = in.readInt();
        int size = in.readInt();
        int vi = 0;
        while (vi < size) {
            Variable var = (Variable)in.readObject();
            this.add(var);
            ++vi;
        }
    }
}

