/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.learning.templates;

import cc.mallet.grmm.learning.ACRF;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.LabelsAssignment;
import cc.mallet.grmm.util.THashMultiMap;
import cc.mallet.types.Alphabet;
import cc.mallet.types.AugmentableFeatureVector;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimilarTokensTemplate
extends ACRF.SequenceTemplate {
    private static final boolean debug = false;
    private int factor;
    private boolean distinguishEndpts = false;
    private boolean wordFeaturesOnly = false;
    private boolean excludeAdjacent = true;
    private FeatureVectorBinner binner;
    private transient THashMap instanceCache = new THashMap();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 2;

    public SimilarTokensTemplate(int factor) {
        this(factor, false);
    }

    public SimilarTokensTemplate(int factor, boolean distinguishEndpoints) {
        this(factor, distinguishEndpoints, false, new CapWordsBinner());
    }

    public SimilarTokensTemplate(int factor, boolean distinguishEndpoints, boolean wordFeaturesOnly) {
        this(factor, distinguishEndpoints, wordFeaturesOnly, new CapWordsBinner());
    }

    public SimilarTokensTemplate(int factor, boolean distinguishEndpoints, FeatureVectorBinner binner) {
        this(factor, distinguishEndpoints, false, binner);
    }

    public SimilarTokensTemplate(int factor, boolean distinguishEndpoints, boolean wordFeaturesOnly, FeatureVectorBinner binner) {
        this.factor = factor;
        this.distinguishEndpts = distinguishEndpoints;
        this.wordFeaturesOnly = wordFeaturesOnly;
        this.binner = binner;
    }

    @Override
    public void addInstantiatedCliques(ACRF.UnrolledGraph graph, FeatureVectorSequence fvs, LabelsAssignment lblseq) {
        THashMultiMap fvByWord = this.constructFvByWord(fvs);
        int numSkip = 0;
        for (String wordFeature : fvByWord.keySet()) {
            List infoList = (List)fvByWord.get(wordFeature);
            int N = infoList.size();
            int i = 0;
            while (i < N) {
                int j = i + 1;
                while (j < N) {
                    TokenInfo info1 = (TokenInfo)infoList.get(i);
                    TokenInfo info2 = (TokenInfo)infoList.get(j);
                    Variable v1 = lblseq.varOfIndex(info1.pos, this.factor);
                    Variable v2 = lblseq.varOfIndex(info2.pos, this.factor);
                    if (!this.excludeAdjacent || Math.abs(info1.pos - info2.pos) > 1) {
                        Variable[] vars = new Variable[]{v1, v2};
                        assert (v1 != null) : "Couldn't get label factor " + this.factor + " time " + i;
                        assert (v2 != null) : "Couldn't get label factor " + this.factor + " time " + j;
                        FeatureVector fv = this.combineFv(wordFeature, info1.fv, info2.fv);
                        ACRF.UnrolledVarSet clique = new ACRF.UnrolledVarSet(graph, this, vars, fv);
                        graph.addClique(clique);
                        ++numSkip;
                    }
                    ++j;
                }
                ++i;
            }
        }
        System.err.println("SimilarTokensTemplate: Total skip edges = " + numSkip);
    }

    private THashMultiMap constructFvByWord(FeatureVectorSequence fvs) {
        THashMultiMap fvByWord = new THashMultiMap(fvs.size());
        int N = fvs.size();
        int t = 0;
        while (t < N) {
            FeatureVector fv = fvs.getFeatureVector(t);
            String wordFeature = this.binner.computeBin(fv);
            if (wordFeature != null) {
                fvByWord.put(wordFeature, new TokenInfo(wordFeature, fv, t));
            }
            ++t;
        }
        return fvByWord;
    }

    private FeatureVector combineFv(String word, FeatureVector fv1, FeatureVector fv2) {
        Alphabet dict = fv1.getAlphabet();
        AugmentableFeatureVector afv = new AugmentableFeatureVector(dict, true);
        if (this.wordFeaturesOnly) {
            int idx = dict.lookupIndex(word);
            afv.add(idx, 1.0);
        } else if (this.distinguishEndpts) {
            afv.add(fv1, "S:");
            afv.add(fv2, "E:");
        } else {
            afv.add(fv1);
            afv.add(fv2);
        }
        return afv;
    }

    public void setBinner(FeatureVectorBinner binner) {
        this.binner = binner;
    }

    public boolean isExcludeAdjacent() {
        return this.excludeAdjacent;
    }

    public void setExcludeAdjacent(boolean excludeAdjacent) {
        this.excludeAdjacent = excludeAdjacent;
    }

    public boolean isDistinguishEndpts() {
        return this.distinguishEndpts;
    }

    public void setDistinguishEndpts(boolean distinguishEndpts) {
        this.distinguishEndpts = distinguishEndpts;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(2);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version2 = in.readInt();
        this.instanceCache = new THashMap();
    }

    public static class CapWordsBinner
    extends WordFeatureBinner {
        public CapWordsBinner() {
            super(Pattern.compile("[A-Z][A-Za-z]*"));
        }
    }

    public static interface FeatureVectorBinner {
        public String computeBin(FeatureVector var1);
    }

    private static class TokenInfo {
        String featureName;
        FeatureVector fv;
        int pos;

        public TokenInfo(String featureName, FeatureVector fv, int pos) {
            this.featureName = featureName;
            this.fv = fv;
            this.pos = pos;
        }
    }

    public static class WordFeatureBinner
    implements FeatureVectorBinner,
    Serializable {
        private Pattern findWordPtn1 = Pattern.compile("WORD=(.*)");
        private Pattern findWordPtn2 = Pattern.compile("W=(.*)");
        private Pattern findWordExcludePtn = Pattern.compile(".*(?:@-?\\d+|_&_).*");
        private Pattern wordIncludePattern = null;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 2;

        public WordFeatureBinner() {
        }

        public WordFeatureBinner(Pattern wordIncludePattern) {
            this.wordIncludePattern = wordIncludePattern;
        }

        @Override
        public String computeBin(FeatureVector fv) {
            String text = this.intuitTokenText(fv);
            if (text != null && (this.wordIncludePattern == null || this.wordIncludePattern.matcher(text).matches())) {
                return text;
            }
            return null;
        }

        private String intuitTokenText(FeatureVector fv) {
            Alphabet dict = fv.getAlphabet();
            int loc = 0;
            while (loc < fv.numLocations()) {
                int idx = fv.indexAtLocation(loc);
                String fname = String.valueOf(dict.lookupObject(idx));
                Matcher matcher = this.findWordPtn1.matcher(fname);
                if (matcher.matches() ? !this.findWordExcludePtn.matcher(fname).matches() : this.findWordPtn2 != null && (matcher = this.findWordPtn2.matcher(fname)).matches() && !this.findWordExcludePtn.matcher(fname).matches()) {
                    return matcher.group(1);
                }
                ++loc;
            }
            return null;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeInt(2);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            int version2 = in.readInt();
            if (version2 == 1) {
                throw new RuntimeException();
            }
        }
    }
}

