/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference;

import cc.mallet.grmm.types.BoltzmannPairFactor;
import cc.mallet.grmm.types.BoltzmannUnaryFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.UndirectedGrid;
import cc.mallet.grmm.types.UndirectedModel;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.Dirichlet;
import cc.mallet.types.Multinomial;
import cc.mallet.util.Randoms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class RandomGraphs {
    public static double[] generateAttractivePotentialValues(Random r, double edgeWeight) {
        double b = Math.abs(r.nextGaussian()) * edgeWeight;
        double eB = Math.exp(b);
        double eMinusB = Math.exp(-b);
        return new double[]{eB, eMinusB, eMinusB, eB};
    }

    public static double[] generateMixedPotentialValues(Random r, double edgeWeight) {
        double b = r.nextGaussian() * edgeWeight;
        double eB = Math.exp(b);
        double eMinusB = Math.exp(-b);
        return new double[]{eB, eMinusB, eMinusB, eB};
    }

    private static Factor generateAttractivePotential(Random r, double edgeWeight, Variable v1, Variable v2) {
        double b = -Math.abs(r.nextGaussian()) * edgeWeight;
        return new BoltzmannPairFactor(v1, v2, 2.0 * b);
    }

    private static Factor generateMixedPotential(Random r, double edgeWeight, Variable v1, Variable v2) {
        double b = r.nextGaussian() * edgeWeight;
        return new BoltzmannPairFactor(v1, v2, 2.0 * b);
    }

    public static UndirectedGrid randomAttractiveGrid(int size, double edgeWeight, Random r) {
        UndirectedGrid mdl = new UndirectedGrid(size, size, 2);
        int i = 0;
        while (i < size - 1) {
            int j = 0;
            while (j < size - 1) {
                Variable v = mdl.get(i, j);
                Variable vRight = mdl.get(i + 1, j);
                Variable vDown = mdl.get(i, j + 1);
                mdl.addFactor(RandomGraphs.generateAttractivePotential(r, edgeWeight, v, vRight));
                mdl.addFactor(RandomGraphs.generateAttractivePotential(r, edgeWeight, v, vDown));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size - 1) {
            Variable v = mdl.get(i, size - 1);
            Variable vRight = mdl.get(i + 1, size - 1);
            mdl.addFactor(RandomGraphs.generateAttractivePotential(r, edgeWeight, v, vRight));
            ++i;
        }
        i = 0;
        while (i < size - 1) {
            Variable v = mdl.get(size - 1, i);
            Variable vDown = mdl.get(size - 1, i + 1);
            mdl.addFactor(RandomGraphs.generateAttractivePotential(r, edgeWeight, v, vDown));
            ++i;
        }
        i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                double a = r.nextGaussian() * 0.0625;
                mdl.addFactor(new BoltzmannUnaryFactor(mdl.get(i, j), -2.0 * a));
                ++j;
            }
            ++i;
        }
        return mdl;
    }

    public static UndirectedGrid randomRepulsiveGrid(int size, double edgeWeight, Random r) {
        return RandomGraphs.randomAttractiveGrid(size, -edgeWeight, r);
    }

    public static UndirectedGrid randomFrustratedGrid(int size, double edgeWeight, Random r) {
        UndirectedGrid mdl = new UndirectedGrid(size, size, 2);
        int i = 0;
        while (i < size - 1) {
            int j = 0;
            while (j < size - 1) {
                Variable v = mdl.get(i, j);
                Variable vRight = mdl.get(i + 1, j);
                Variable vDown = mdl.get(i, j + 1);
                mdl.addFactor(RandomGraphs.generateMixedPotential(r, edgeWeight, v, vRight));
                mdl.addFactor(RandomGraphs.generateMixedPotential(r, edgeWeight, v, vDown));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size - 1) {
            Variable v = mdl.get(i, size - 1);
            Variable vRight = mdl.get(i + 1, size - 1);
            mdl.addFactor(RandomGraphs.generateMixedPotential(r, edgeWeight, v, vRight));
            ++i;
        }
        i = 0;
        while (i < size - 1) {
            Variable v = mdl.get(size - 1, i);
            Variable vDown = mdl.get(size - 1, i + 1);
            mdl.addFactor(RandomGraphs.generateMixedPotential(r, edgeWeight, v, vDown));
            ++i;
        }
        RandomGraphs.addRandomNodePotentials(r, mdl);
        return mdl;
    }

    public static UndirectedModel randomFrustratedTree(int size, int maxChildren, double edgeWeight, Random r) {
        UndirectedModel mdl = new UndirectedModel();
        ArrayList<Variable> leaves = new ArrayList<Variable>();
        Variable root = new Variable(2);
        leaves.add(root);
        while (mdl.numVariables() < size) {
            Variable parent = (Variable)RandomGraphs.removeRandomElement(leaves, r);
            int numChildren = r.nextInt(maxChildren) + 1;
            int ci = 0;
            while (ci < numChildren) {
                Variable child = new Variable(2);
                double[] vals = RandomGraphs.generateMixedPotentialValues(r, edgeWeight);
                mdl.addFactor(parent, child, vals);
                leaves.add(child);
                ++ci;
            }
        }
        RandomGraphs.addRandomNodePotentials(r, mdl);
        return mdl;
    }

    private static Object removeRandomElement(List l, Random r) {
        int idx = r.nextInt(l.size());
        Object obj = l.get(idx);
        l.remove(idx);
        return obj;
    }

    public static void addRandomNodePotentials(Random r, FactorGraph mdl) {
        int size = mdl.numVariables();
        int i = 0;
        while (i < size) {
            Variable var = mdl.get(i);
            TableFactor ptl = RandomGraphs.randomNodePotential(r, var);
            mdl.addFactor(ptl);
            ++i;
        }
    }

    public static TableFactor randomNodePotential(Random r, Variable var) {
        double a = r.nextGaussian();
        BoltzmannUnaryFactor ptl = new BoltzmannUnaryFactor(var, -2.0 * a);
        return ptl;
    }

    public static FactorGraph createUniformChain(int length) {
        Variable[] vars = new Variable[length];
        int i = 0;
        while (i < length) {
            vars[i] = new Variable(2);
            ++i;
        }
        UndirectedModel mdl = new UndirectedModel(vars);
        int i2 = 0;
        while (i2 < length - 1) {
            double[] probs = new double[4];
            Arrays.fill(probs, 1.0);
            mdl.addFactor(vars[i2], vars[i2 + 1], probs);
            ++i2;
        }
        return mdl;
    }

    public static FactorGraph createUniformGrid(int length) {
        return RandomGraphs.createGrid(new UniformFactorGenerator(), length);
    }

    public static FactorGraph createRandomChain(Randoms r, int length) {
        Variable[] vars = new Variable[length];
        int i = 0;
        while (i < length) {
            vars[i] = new Variable(2);
            ++i;
        }
        Dirichlet dirichlet = new Dirichlet(new double[]{1.0, 1.0, 1.0, 1.0});
        FactorGraph mdl = new FactorGraph(vars);
        int i2 = 0;
        while (i2 < length - 1) {
            Multinomial m3 = dirichlet.randomMultinomial(r);
            double[] probs = m3.getValues();
            mdl.addFactor(vars[i2], vars[i2 + 1], probs);
            ++i2;
        }
        return mdl;
    }

    public static UndirectedModel createGrid(FactorGenerator gener, int size) {
        Factor factor;
        HashVarSet vars;
        Variable v2;
        Variable v1;
        int y;
        UndirectedGrid grid = new UndirectedGrid(size, size, 2);
        int x = 0;
        while (x < size) {
            y = 0;
            while (y < size - 1) {
                v1 = grid.get(x, y);
                v2 = grid.get(x, y + 1);
                vars = new HashVarSet(new Variable[]{v1, v2});
                factor = gener.nextFactor(vars);
                grid.addFactor(factor);
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < size - 1) {
            y = 0;
            while (y < size) {
                v1 = grid.get(x, y);
                v2 = grid.get(x + 1, y);
                vars = new HashVarSet(new Variable[]{v1, v2});
                factor = gener.nextFactor(vars);
                grid.addFactor(factor);
                ++y;
            }
            ++x;
        }
        return grid;
    }

    public static FactorGraph createGridWithObs(FactorGenerator gridGener, FactorGenerator obsGener, int size) {
        Factor factor;
        HashVarSet clique;
        int j;
        ArrayList<Variable> allVars = new ArrayList<Variable>(2 * size * size);
        Variable[][] gridVars = new Variable[size][size];
        Variable[][] obsVars = new Variable[size][size];
        int i = 0;
        while (i < size) {
            int j2 = 0;
            while (j2 < size) {
                gridVars[i][j2] = new Variable(2);
                gridVars[i][j2].setLabel("GRID[" + i + "][" + j2 + "]");
                obsVars[i][j2] = new Variable(2);
                obsVars[i][j2].setLabel("OBS[" + i + "][" + j2 + "]");
                allVars.add(gridVars[i][j2]);
                allVars.add(obsVars[i][j2]);
                ++j2;
            }
            ++i;
        }
        FactorGraph mdl = new FactorGraph(allVars.toArray(new Variable[0]));
        int i2 = 0;
        while (i2 < size) {
            j = 0;
            while (j < size) {
                Variable var0 = gridVars[i2][j];
                if (i2 < size - 1) {
                    Variable varR = gridVars[i2 + 1][j];
                    clique = new HashVarSet(new Variable[]{var0, varR});
                    factor = gridGener.nextFactor(clique);
                    mdl.addFactor(factor);
                }
                if (j < size - 1) {
                    Variable varD = gridVars[i2][j + 1];
                    clique = new HashVarSet(new Variable[]{var0, varD});
                    factor = gridGener.nextFactor(clique);
                    mdl.addFactor(factor);
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < size) {
            j = 0;
            while (j < size) {
                Variable gridVar = gridVars[i2][j];
                Variable obsVar = obsVars[i2][j];
                clique = new HashVarSet(new Variable[]{gridVar, obsVar});
                factor = obsGener.nextFactor(clique);
                mdl.addFactor(factor);
                ++j;
            }
            ++i2;
        }
        return mdl;
    }

    public static interface FactorGenerator {
        public Factor nextFactor(VarSet var1);
    }

    public static class UniformFactorGenerator
    implements FactorGenerator {
        @Override
        public Factor nextFactor(VarSet vars) {
            double[] probs = new double[vars.weight()];
            Arrays.fill(probs, 1.0);
            return new TableFactor(vars, probs);
        }
    }
}

