/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.constraints;

import cc.mallet.fst.SumLattice;
import cc.mallet.fst.semi_supervised.StateLabelMap;
import cc.mallet.fst.semi_supervised.constraints.GEConstraint;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.BitSet;

public abstract class TwoLabelGEConstraints
implements GEConstraint {
    protected ArrayList<TwoLabelGEConstraint> constraintsList;
    protected TIntIntHashMap constraintsMap;
    protected StateLabelMap map;
    protected TIntArrayList cache;

    public TwoLabelGEConstraints() {
        this.constraintsList = new ArrayList();
        this.constraintsMap = new TIntIntHashMap();
        this.map = null;
        this.cache = new TIntArrayList();
    }

    protected TwoLabelGEConstraints(ArrayList<TwoLabelGEConstraint> constraintsList, TIntIntHashMap constraintsMap, StateLabelMap map) {
        this.constraintsList = constraintsList;
        this.constraintsMap = constraintsMap;
        this.map = map;
        this.cache = new TIntArrayList();
    }

    public abstract void addConstraint(int var1, double[][] var2, double var3);

    @Override
    public boolean isOneStateConstraint() {
        return false;
    }

    @Override
    public void setStateLabelMap(StateLabelMap map) {
        this.map = map;
    }

    @Override
    public void preProcess(FeatureVector fv) {
        this.cache.resetQuick();
        int loc = 0;
        while (loc < fv.numLocations()) {
            int fi = fv.indexAtLocation(loc);
            if (this.constraintsMap.containsKey(fi)) {
                this.cache.add(this.constraintsMap.get(fi));
            }
            ++loc;
        }
    }

    @Override
    public BitSet preProcess(InstanceList data) {
        BitSet bitSet = new BitSet(data.size());
        int ii = 0;
        for (Instance instance : data) {
            FeatureVectorSequence fvs = (FeatureVectorSequence)instance.getData();
            int ip = 1;
            while (ip < fvs.size()) {
                int[] nArray = this.constraintsMap.keys();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int fi = nArray[n2];
                    if (fvs.get(ip).location(fi) >= 0) {
                        this.constraintsList.get((int)this.constraintsMap.get((int)fi)).count += 1.0;
                        bitSet.set(ii);
                    }
                    ++n2;
                }
                ++ip;
            }
            ++ii;
        }
        return bitSet;
    }

    @Override
    public double getCompositeConstraintFeatureValue(FeatureVector fv, int ip, int si1, int si2) {
        if (ip == 0) {
            return 0.0;
        }
        double value = 0.0;
        int li1 = this.map.getLabelIndex(si1);
        if (li1 == -2) {
            return 0.0;
        }
        int li2 = this.map.getLabelIndex(si2);
        int i = 0;
        while (i < this.cache.size()) {
            value += this.constraintsList.get(this.cache.getQuick(i)).getValue(li1, li2);
            ++i;
        }
        return value;
    }

    @Override
    public abstract double getValue();

    @Override
    public void zeroExpectations() {
        for (TwoLabelGEConstraint constraint : this.constraintsList) {
            constraint.expectation = new double[this.map.getNumLabels()][this.map.getNumLabels()];
        }
    }

    @Override
    public void computeExpectations(ArrayList<SumLattice> lattices) {
        TIntArrayList cache = new TIntArrayList();
        int i = 0;
        while (i < lattices.size()) {
            if (lattices.get(i) != null) {
                FeatureVectorSequence fvs = (FeatureVectorSequence)lattices.get(i).getInput();
                SumLattice lattice = lattices.get(i);
                double[][][] xis = lattice.getXis();
                int ip = 1;
                while (ip < fvs.size()) {
                    cache.resetQuick();
                    FeatureVector fv = fvs.getFeatureVector(ip);
                    int loc = 0;
                    while (loc < fv.numLocations()) {
                        int fi = fv.indexAtLocation(loc);
                        if (this.constraintsMap.containsKey(fi)) {
                            cache.add(this.constraintsMap.get(fi));
                        }
                        ++loc;
                    }
                    int prev = 0;
                    while (prev < this.map.getNumStates()) {
                        int liPrev = this.map.getLabelIndex(prev);
                        if (liPrev != -2) {
                            int curr = 0;
                            while (curr < this.map.getNumStates()) {
                                int liCurr = this.map.getLabelIndex(curr);
                                if (liCurr != -2) {
                                    double prob = Math.exp(xis[ip][prev][curr]);
                                    int j = 0;
                                    while (j < cache.size()) {
                                        double[] dArray = this.constraintsList.get((int)cache.getQuick((int)j)).expectation[liPrev];
                                        int n = liCurr;
                                        dArray[n] = dArray[n] + prob;
                                        ++j;
                                    }
                                }
                                ++curr;
                            }
                        }
                        ++prev;
                    }
                    ++ip;
                }
            }
            ++i;
        }
    }

    protected abstract class TwoLabelGEConstraint {
        protected double[][] target;
        protected double[][] expectation;
        protected double count;
        protected double weight;

        public TwoLabelGEConstraint(double[][] target, double weight) {
            this.target = target;
            this.weight = weight;
            this.expectation = null;
            this.count = 0.0;
        }

        public abstract double getValue(int var1, int var2);
    }
}

