/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.Transducer;
import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class SegmentationEvaluator
extends TransducerEvaluator {
    private static Logger logger = MalletLogger.getLogger(SegmentationEvaluator.class.getName());
    static Pattern startRegex = Pattern.compile("^B.*");
    Object segmentStartTag = new Object(){

        public boolean equals(Object o) {
            return startRegex.matcher(o.toString()).matches();
        }
    };
    Object segmentEndTag = new Object(){

        public boolean equals(Object o) {
            return false;
        }
    };

    public SegmentationEvaluator(InstanceList[] instanceLists, String[] descriptions) {
        super(instanceLists, descriptions);
    }

    public SegmentationEvaluator(InstanceList instanceList1, String description1) {
        this(new InstanceList[]{instanceList1}, new String[]{description1});
    }

    public SegmentationEvaluator(InstanceList instanceList1, String description1, InstanceList instanceList2, String description2) {
        this(new InstanceList[]{instanceList1, instanceList2}, new String[]{description1, description2});
    }

    public SegmentationEvaluator(InstanceList instanceList1, String description1, InstanceList instanceList2, String description2, InstanceList instanceList3, String description3) {
        this(new InstanceList[]{instanceList1, instanceList2, instanceList3}, new String[]{description1, description2, description3});
    }

    public SegmentationEvaluator setSegmentStartTag(Object o) {
        this.segmentStartTag = o;
        return this;
    }

    public SegmentationEvaluator setSegmentEndTag(Object o) {
        this.segmentEndTag = o;
        return this;
    }

    @Override
    public void evaluateInstanceList(TransducerTrainer tt, InstanceList data, String description) {
        Transducer model = tt.getTransducer();
        Object sourceTokenSequence = null;
        int numCorrectTokens = 0;
        int totalTokens = 0;
        int numCorrectSegments = 0;
        int numPredictedSegments = 0;
        int numTrueSegments = 0;
        boolean numCorrectSegmentsOOV = false;
        boolean numCorrectSegmentsInAlphabet = false;
        boolean numIncorrectSegmentsOOV = false;
        boolean numIncorrectSegmentsInAlphabet = false;
        int i = 0;
        while (i < data.size()) {
            Instance instance = (Instance)data.get(i);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence predOutput = model.transduce(input);
            assert (predOutput.size() == trueOutput.size());
            int j = 0;
            while (j < trueOutput.size()) {
                ++totalTokens;
                boolean predStart = false;
                boolean trueStart = false;
                if (this.segmentStartTag.equals(trueOutput.get(j))) {
                    ++numTrueSegments;
                    trueStart = true;
                }
                if (this.segmentStartTag.equals(predOutput.get(j))) {
                    predStart = true;
                    ++numPredictedSegments;
                }
                if (trueStart && predStart) {
                    int m3 = j + 1;
                    while (m3 < trueOutput.size()) {
                        predStart = false;
                        trueStart = false;
                        if (this.segmentEndTag.equals(trueOutput.get(m3))) {
                            trueStart = true;
                        }
                        if (this.segmentEndTag.equals(predOutput.get(m3))) {
                            predStart = true;
                        }
                        if (trueStart || predStart) {
                            if (!trueStart || !predStart) break;
                            ++numCorrectSegments;
                            break;
                        }
                        ++m3;
                    }
                    if (m3 == trueOutput.size() && trueStart == predStart) {
                        ++numCorrectSegments;
                    }
                }
                if (trueOutput.get(j).equals(predOutput.get(j))) {
                    ++numCorrectTokens;
                }
                ++j;
            }
            ++i;
        }
        logger.info(String.valueOf(description) + " accuracy=" + (double)numCorrectTokens / (double)totalTokens);
        double precision = numPredictedSegments == 0 ? 1.0 : (double)numCorrectSegments / (double)numPredictedSegments;
        double recall = numTrueSegments == 0 ? 1.0 : (double)numCorrectSegments / (double)numTrueSegments;
        double f1 = recall + precision == 0.0 ? 0.0 : 2.0 * recall * precision / (recall + precision);
        logger.info(" precision=" + precision + " recall=" + recall + " f1=" + f1);
        logger.info("segments true=" + numTrueSegments + " pred=" + numPredictedSegments + " correct=" + numCorrectSegments + " misses=" + (numTrueSegments - numCorrectSegments) + " alarms=" + (numPredictedSegments - numCorrectSegments));
    }
}

