/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.types.ArraySequence;
import cc.mallet.types.Sequence;
import java.util.ArrayList;

public class Segment
implements Comparable {
    Sequence input;
    Sequence pred;
    Sequence truth;
    int start;
    int end;
    Object startTag;
    Object inTag;
    double confidence;
    boolean correct;
    boolean endsPrematurely;

    public Segment(Sequence input, Sequence pred, Sequence truth, int start, int end, Object startTag, Object inTag) {
        this.input = input;
        this.pred = pred;
        this.truth = truth;
        this.start = start;
        this.startTag = startTag;
        this.inTag = inTag;
        this.end = end;
        this.confidence = -1.0;
        this.correct = true;
        this.endsPrematurely = false;
        int i = start;
        while (i <= end) {
            if (!pred.get(i).equals(truth.get(i))) {
                this.correct = false;
                break;
            }
            ++i;
        }
        if (truth != null && this.correct && end + 1 < truth.size() && truth.get(end + 1).equals(inTag)) {
            this.correct = false;
            this.endsPrematurely = true;
        }
    }

    public void setCorrect(boolean b) {
        this.correct = b;
    }

    public int size() {
        return this.end - this.start + 1;
    }

    public Object getTruth(int i) {
        return this.truth.get(i);
    }

    public Sequence getTruth() {
        return this.truth;
    }

    public Object getPredicted(int i) {
        return this.pred.get(i);
    }

    public Sequence getPredicted() {
        return this.pred;
    }

    public void setPredicted(Sequence predicted) {
        this.pred = predicted;
    }

    public Sequence getInput() {
        return this.input;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public Object getStartTag() {
        return this.startTag;
    }

    public Object getInTag() {
        return this.inTag;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double c) {
        this.confidence = c;
    }

    public boolean correct() {
        return this.correct;
    }

    public boolean endsPrematurely() {
        return this.endsPrematurely;
    }

    public boolean indexInSegment(int index) {
        return index >= this.start && index <= this.end;
    }

    public Sequence getSegmentInputSequence() {
        ArrayList ret = new ArrayList();
        int i = this.start;
        while (i <= this.end) {
            ret.add(this.input.get(i));
            ++i;
        }
        return new ArraySequence(ret);
    }

    public int compareTo(Object o) {
        Segment s2 = (Segment)o;
        if (s2.confidence == -1.0 || this.confidence == -1.0) {
            throw new IllegalArgumentException("attempting to compare confidences that have not been set yet..");
        }
        if (this.confidence > s2.confidence) {
            return 1;
        }
        if (this.confidence < s2.confidence) {
            return -1;
        }
        return 0;
    }

    public String sequenceToString() {
        String ret = "";
        int i = 0;
        while (i < this.input.size()) {
            ret = i <= this.end && i >= this.start ? String.valueOf(ret) + this.pred.get(i).toString() + "[" + this.truth.get(i) + "][" + this.confidence + "]\t" : String.valueOf(ret) + "-[" + this.truth.get(i) + "]\t";
            ++i;
        }
        return ret;
    }

    public String toString() {
        String ret = "";
        ret = String.valueOf(ret) + "start: " + this.start + " end: " + this.end + " confidence: " + this.confidence + "\n";
        int i = this.start;
        while (i <= this.end) {
            ret = String.valueOf(ret) + this.pred.get(i).toString() + "[" + this.truth.get(i) + "]\t";
            ++i;
        }
        return ret;
    }

    public boolean equals(Object o) {
        Segment s2 = (Segment)o;
        if (this.start == s2.getStart() && this.end == s2.getEnd() && this.correct == s2.correct() && this.input.size() == s2.getInput().size()) {
            int i = this.start;
            while (i <= this.end) {
                if (!this.pred.get(i).equals(s2.getPredicted(i)) || !this.truth.get(i).equals(s2.getTruth(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

