/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Multinomial;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class HMM
extends Transducer
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(HMM.class.getName());
    static final String LABEL_SEPARATOR = ",";
    Alphabet inputAlphabet;
    Alphabet outputAlphabet;
    ArrayList<State> states = new ArrayList();
    ArrayList<State> initialStates = new ArrayList();
    HashMap<String, State> name2state = new HashMap();
    Multinomial.Estimator[] transitionEstimator;
    Multinomial.Estimator[] emissionEstimator;
    Multinomial.Estimator initialEstimator;
    Multinomial[] transitionMultinomial;
    Multinomial[] emissionMultinomial;
    Multinomial initialMultinomial;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;
    static final int NULL_INTEGER = -1;

    public HMM(Pipe inputPipe, Pipe outputPipe) {
        this.inputPipe = inputPipe;
        this.outputPipe = outputPipe;
        this.inputAlphabet = inputPipe.getDataAlphabet();
        this.outputAlphabet = inputPipe.getTargetAlphabet();
    }

    public HMM(Alphabet inputAlphabet, Alphabet outputAlphabet) {
        inputAlphabet.stopGrowth();
        logger.info("HMM input dictionary size = " + inputAlphabet.size());
        this.inputAlphabet = inputAlphabet;
        this.outputAlphabet = outputAlphabet;
    }

    public Alphabet getInputAlphabet() {
        return this.inputAlphabet;
    }

    public Alphabet getOutputAlphabet() {
        return this.outputAlphabet;
    }

    public Multinomial[] getTransitionMultinomial() {
        return this.transitionMultinomial;
    }

    public Multinomial[] getEmissionMultinomial() {
        return this.emissionMultinomial;
    }

    public Multinomial getInitialMultinomial() {
        return this.initialMultinomial;
    }

    @Override
    public void print() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.numStates()) {
            State s2 = (State)this.getState(i);
            sb.append("STATE NAME=\"");
            sb.append(s2.name);
            sb.append("\" (");
            sb.append(s2.destinations.length);
            sb.append(" outgoing transitions)\n");
            sb.append("  ");
            sb.append("initialWeight= ");
            sb.append(s2.initialWeight);
            sb.append('\n');
            sb.append("  ");
            sb.append("finalWeight= ");
            sb.append(s2.finalWeight);
            sb.append('\n');
            sb.append("Emission distribution:\n" + this.emissionMultinomial[i] + "\n\n");
            sb.append("Transition distribution:\n" + this.transitionMultinomial[i].toString());
            ++i;
        }
        System.out.println(sb.toString());
    }

    public void addState(String name, double initialWeight, double finalWeight, String[] destinationNames, String[] labelNames) {
        assert (labelNames.length == destinationNames.length);
        if (this.name2state.get(name) != null) {
            throw new IllegalArgumentException("State with name `" + name + "' already exists.");
        }
        State s2 = new State(name, this.states.size(), initialWeight, finalWeight, destinationNames, labelNames, this);
        s2.print();
        this.states.add(s2);
        if (initialWeight > Double.NEGATIVE_INFINITY) {
            this.initialStates.add(s2);
        }
        this.name2state.put(name, s2);
    }

    public void addState(String name, String[] destinationNames) {
        this.addState(name, 0.0, 0.0, destinationNames, destinationNames);
    }

    public void addFullyConnectedStates(String[] stateNames) {
        int i = 0;
        while (i < stateNames.length) {
            this.addState(stateNames[i], stateNames);
            ++i;
        }
    }

    public void addFullyConnectedStatesForLabels() {
        String[] labels = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            labels[i] = (String)this.outputAlphabet.lookupObject(i);
            ++i;
        }
        this.addFullyConnectedStates(labels);
    }

    private boolean[][] labelConnectionsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = new boolean[numLabels][numLabels];
        for (Instance instance : trainingSet) {
            FeatureSequence output = (FeatureSequence)instance.getTarget();
            int j = 1;
            while (j < output.size()) {
                int sourceIndex = this.outputAlphabet.lookupIndex(output.get(j - 1));
                int destIndex = this.outputAlphabet.lookupIndex(output.get(j));
                assert (sourceIndex >= 0 && destIndex >= 0);
                connections[sourceIndex][destIndex] = true;
                ++j;
            }
        }
        return connections;
    }

    public void addStatesForLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int numDestinations = 0;
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    ++numDestinations;
                }
                ++j;
            }
            String[] destinationNames = new String[numDestinations];
            int destinationIndex = 0;
            int j2 = 0;
            while (j2 < numLabels) {
                if (connections[i][j2]) {
                    destinationNames[destinationIndex++] = (String)this.outputAlphabet.lookupObject(j2);
                }
                ++j2;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), destinationNames);
            ++i;
        }
    }

    public void addStatesForHalfLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int numDestinations = 0;
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    ++numDestinations;
                }
                ++j;
            }
            String[] destinationNames = new String[numDestinations];
            int destinationIndex = 0;
            int j2 = 0;
            while (j2 < numLabels) {
                if (connections[i][j2]) {
                    destinationNames[destinationIndex++] = (String)this.outputAlphabet.lookupObject(j2);
                }
                ++j2;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames);
            ++i;
        }
    }

    public void addStatesForThreeQuarterLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int numDestinations = 0;
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    ++numDestinations;
                }
                ++j;
            }
            String[] destinationNames = new String[numDestinations];
            int destinationIndex = 0;
            int j2 = 0;
            while (j2 < numLabels) {
                if (connections[i][j2]) {
                    String labelName;
                    destinationNames[destinationIndex] = labelName = (String)this.outputAlphabet.lookupObject(j2);
                    ++destinationIndex;
                }
                ++j2;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames);
            ++i;
        }
    }

    public void addFullyConnectedStatesForThreeQuarterLabels(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        int i = 0;
        while (i < numLabels) {
            String[] destinationNames = new String[numLabels];
            int j = 0;
            while (j < numLabels) {
                String labelName;
                destinationNames[j] = labelName = (String)this.outputAlphabet.lookupObject(j);
                ++j;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames);
            ++i;
        }
    }

    public void addFullyConnectedStatesForBiLabels() {
        String[] labels = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            labels[i] = this.outputAlphabet.lookupObject(i).toString();
            ++i;
        }
        i = 0;
        while (i < labels.length) {
            int j = 0;
            while (j < labels.length) {
                String[] destinationNames = new String[labels.length];
                int k = 0;
                while (k < labels.length) {
                    destinationNames[k] = String.valueOf(labels[j]) + LABEL_SEPARATOR + labels[k];
                    ++k;
                }
                this.addState(String.valueOf(labels[i]) + LABEL_SEPARATOR + labels[j], 0.0, 0.0, destinationNames, labels);
                ++j;
            }
            ++i;
        }
    }

    public void addStatesForBiLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    int numDestinations = 0;
                    int k = 0;
                    while (k < numLabels) {
                        if (connections[j][k]) {
                            ++numDestinations;
                        }
                        ++k;
                    }
                    String[] destinationNames = new String[numDestinations];
                    String[] labels = new String[numDestinations];
                    int destinationIndex = 0;
                    int k2 = 0;
                    while (k2 < numLabels) {
                        if (connections[j][k2]) {
                            destinationNames[destinationIndex] = String.valueOf((String)this.outputAlphabet.lookupObject(j)) + LABEL_SEPARATOR + (String)this.outputAlphabet.lookupObject(k2);
                            labels[destinationIndex] = (String)this.outputAlphabet.lookupObject(k2);
                            ++destinationIndex;
                        }
                        ++k2;
                    }
                    this.addState(String.valueOf((String)this.outputAlphabet.lookupObject(i)) + LABEL_SEPARATOR + (String)this.outputAlphabet.lookupObject(j), 0.0, 0.0, destinationNames, labels);
                }
                ++j;
            }
            ++i;
        }
    }

    public void addFullyConnectedStatesForTriLabels() {
        String[] labels = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            logger.info("HMM: outputAlphabet.lookup class = " + this.outputAlphabet.lookupObject(i).getClass().getName());
            labels[i] = this.outputAlphabet.lookupObject(i).toString();
            ++i;
        }
        i = 0;
        while (i < labels.length) {
            int j = 0;
            while (j < labels.length) {
                int k = 0;
                while (k < labels.length) {
                    String[] destinationNames = new String[labels.length];
                    int l = 0;
                    while (l < labels.length) {
                        destinationNames[l] = String.valueOf(labels[j]) + LABEL_SEPARATOR + labels[k] + LABEL_SEPARATOR + labels[l];
                        ++l;
                    }
                    this.addState(String.valueOf(labels[i]) + LABEL_SEPARATOR + labels[j] + LABEL_SEPARATOR + labels[k], 0.0, 0.0, destinationNames, labels);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void addSelfTransitioningStateForAllLabels(String name) {
        String[] labels = new String[this.outputAlphabet.size()];
        String[] destinationNames = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            labels[i] = this.outputAlphabet.lookupObject(i).toString();
            destinationNames[i] = name;
            ++i;
        }
        this.addState(name, 0.0, 0.0, destinationNames, labels);
    }

    private String concatLabels(String[] labels) {
        String sep = "";
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < labels.length) {
            buf.append(sep).append(labels[i]);
            sep = LABEL_SEPARATOR;
            ++i;
        }
        return buf.toString();
    }

    private String nextKGram(String[] history, int k, String next) {
        int start;
        String sep = "";
        StringBuffer buf = new StringBuffer();
        int i = start = history.length + 1 - k;
        while (i < history.length) {
            buf.append(sep).append(history[i]);
            sep = LABEL_SEPARATOR;
            ++i;
        }
        buf.append(sep).append(next);
        return buf.toString();
    }

    private boolean allowedTransition(String prev, String curr, Pattern no, Pattern yes) {
        String pair = this.concatLabels(new String[]{prev, curr});
        if (no != null && no.matcher(pair).matches()) {
            return false;
        }
        return yes == null || yes.matcher(pair).matches();
    }

    private boolean allowedHistory(String[] history, Pattern no, Pattern yes) {
        int i = 1;
        while (i < history.length) {
            if (!this.allowedTransition(history[i - 1], history[i], no, yes)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String addOrderNStates(InstanceList trainingSet, int[] orders, boolean[] defaults, String start, Pattern forbidden, Pattern allowed, boolean fullyConnected) {
        boolean[][] connections = null;
        if (!fullyConnected) {
            connections = this.labelConnectionsIn(trainingSet);
        }
        int order = -1;
        if (defaults != null && defaults.length != orders.length) {
            throw new IllegalArgumentException("Defaults must be null or match orders");
        }
        if (orders == null) {
            order = 0;
        } else {
            int i = 0;
            while (i < orders.length) {
                if (orders[i] <= order) {
                    throw new IllegalArgumentException("Orders must be non-negative and in ascending order");
                }
                order = orders[i];
                ++i;
            }
            if (order < 0) {
                order = 0;
            }
        }
        if (order > 0) {
            int[] historyIndexes = new int[order];
            String[] history = new String[order];
            String label0 = (String)this.outputAlphabet.lookupObject(0);
            int i = 0;
            while (i < order) {
                history[i] = label0;
                ++i;
            }
            int numLabels = this.outputAlphabet.size();
            block2: while (historyIndexes[0] < numLabels) {
                logger.info("Preparing " + this.concatLabels(history));
                if (this.allowedHistory(history, forbidden, allowed)) {
                    String stateName = this.concatLabels(history);
                    int nt = 0;
                    String[] destNames = new String[numLabels];
                    String[] labelNames = new String[numLabels];
                    int nextIndex = 0;
                    while (nextIndex < numLabels) {
                        String next = (String)this.outputAlphabet.lookupObject(nextIndex);
                        if (this.allowedTransition(history[order - 1], next, forbidden, allowed) && (fullyConnected || connections[historyIndexes[order - 1]][nextIndex])) {
                            destNames[nt] = this.nextKGram(history, order, next);
                            labelNames[nt] = next;
                            ++nt;
                        }
                        ++nextIndex;
                    }
                    if (nt < numLabels) {
                        String[] newDestNames = new String[nt];
                        String[] newLabelNames = new String[nt];
                        int t = 0;
                        while (t < nt) {
                            newDestNames[t] = destNames[t];
                            newLabelNames[t] = labelNames[t];
                            ++t;
                        }
                        destNames = newDestNames;
                        labelNames = newLabelNames;
                    }
                    this.addState(stateName, 0.0, 0.0, destNames, labelNames);
                }
                int o = order - 1;
                while (o >= 0) {
                    int n = o;
                    historyIndexes[n] = historyIndexes[n] + 1;
                    if (historyIndexes[n] < numLabels) {
                        history[o] = (String)this.outputAlphabet.lookupObject(historyIndexes[o]);
                        continue block2;
                    }
                    if (o > 0) {
                        historyIndexes[o] = 0;
                        history[o] = label0;
                    }
                    --o;
                }
            }
            int i2 = 0;
            while (i2 < order) {
                history[i2] = start;
                ++i2;
            }
            return this.concatLabels(history);
        }
        String[] stateNames = new String[this.outputAlphabet.size()];
        int s2 = 0;
        while (s2 < this.outputAlphabet.size()) {
            stateNames[s2] = (String)this.outputAlphabet.lookupObject(s2);
            ++s2;
        }
        s2 = 0;
        while (s2 < this.outputAlphabet.size()) {
            this.addState(stateNames[s2], 0.0, 0.0, stateNames, stateNames);
            ++s2;
        }
        return start;
    }

    public State getState(String name) {
        return this.name2state.get(name);
    }

    @Override
    public int numStates() {
        return this.states.size();
    }

    @Override
    public Transducer.State getState(int index) {
        return this.states.get(index);
    }

    @Override
    public Iterator initialStateIterator() {
        return this.initialStates.iterator();
    }

    public boolean isTrainable() {
        return true;
    }

    private Alphabet getTransitionAlphabet() {
        Alphabet transitionAlphabet = new Alphabet();
        int i = 0;
        while (i < this.numStates()) {
            transitionAlphabet.lookupIndex(this.getState(i).getName(), true);
            ++i;
        }
        return transitionAlphabet;
    }

    @Deprecated
    public void reset() {
        this.emissionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
        this.transitionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
        this.emissionMultinomial = new Multinomial[this.numStates()];
        this.transitionMultinomial = new Multinomial[this.numStates()];
        Alphabet transitionAlphabet = this.getTransitionAlphabet();
        int i = 0;
        while (i < this.numStates()) {
            this.emissionEstimator[i] = new Multinomial.LaplaceEstimator(this.inputAlphabet);
            this.transitionEstimator[i] = new Multinomial.LaplaceEstimator(transitionAlphabet);
            this.emissionMultinomial[i] = new Multinomial(this.getUniformArray(this.inputAlphabet.size()), this.inputAlphabet);
            this.transitionMultinomial[i] = new Multinomial(this.getUniformArray(transitionAlphabet.size()), transitionAlphabet);
            ++i;
        }
        this.initialMultinomial = new Multinomial(this.getUniformArray(transitionAlphabet.size()), transitionAlphabet);
        this.initialEstimator = new Multinomial.LaplaceEstimator(transitionAlphabet);
    }

    public void initTransitions(Random random, double noise) {
        Alphabet transitionAlphabet = this.getTransitionAlphabet();
        this.initialMultinomial = new Multinomial(this.getRandomArray(transitionAlphabet.size(), random, noise), transitionAlphabet);
        this.initialEstimator = new Multinomial.LaplaceEstimator(transitionAlphabet);
        this.transitionMultinomial = new Multinomial[this.numStates()];
        this.transitionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
        int i = 0;
        while (i < this.numStates()) {
            this.transitionMultinomial[i] = new Multinomial(this.getRandomArray(transitionAlphabet.size(), random, noise), transitionAlphabet);
            this.transitionEstimator[i] = new Multinomial.LaplaceEstimator(transitionAlphabet);
            State s2 = (State)this.getState(i);
            s2.setInitialWeight(this.initialMultinomial.logProbability(s2.getName()));
            ++i;
        }
    }

    public void initEmissions(Random random, double noise) {
        this.emissionMultinomial = new Multinomial[this.numStates()];
        this.emissionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
        int i = 0;
        while (i < this.numStates()) {
            this.emissionMultinomial[i] = new Multinomial(this.getRandomArray(this.inputAlphabet.size(), random, noise), this.inputAlphabet);
            this.emissionEstimator[i] = new Multinomial.LaplaceEstimator(this.inputAlphabet);
            ++i;
        }
    }

    public void estimate() {
        Alphabet transitionAlphabet = this.getTransitionAlphabet();
        this.initialMultinomial = this.initialEstimator.estimate();
        this.initialEstimator = new Multinomial.LaplaceEstimator(transitionAlphabet);
        int i = 0;
        while (i < this.numStates()) {
            State s2 = (State)this.getState(i);
            this.emissionMultinomial[i] = this.emissionEstimator[i].estimate();
            this.transitionMultinomial[i] = this.transitionEstimator[i].estimate();
            s2.setInitialWeight(this.initialMultinomial.logProbability(s2.getName()));
            this.emissionEstimator[i] = new Multinomial.LaplaceEstimator(this.inputAlphabet);
            this.transitionEstimator[i] = new Multinomial.LaplaceEstimator(transitionAlphabet);
            ++i;
        }
    }

    public boolean train(InstanceList ilist) {
        return this.train(ilist, null, null);
    }

    public boolean train(InstanceList ilist, InstanceList validation, InstanceList testing) {
        return this.train(ilist, validation, testing, null);
    }

    public boolean train(InstanceList ilist, InstanceList validation, InstanceList testing, TransducerEvaluator eval) {
        assert (ilist.size() > 0);
        if (this.emissionEstimator == null) {
            this.emissionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
            this.transitionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
            this.emissionMultinomial = new Multinomial[this.numStates()];
            this.transitionMultinomial = new Multinomial[this.numStates()];
            Alphabet transitionAlphabet = new Alphabet();
            int i = 0;
            while (i < this.numStates()) {
                transitionAlphabet.lookupIndex(this.states.get(i).getName(), true);
                ++i;
            }
            i = 0;
            while (i < this.numStates()) {
                this.emissionEstimator[i] = new Multinomial.LaplaceEstimator(this.inputAlphabet);
                this.transitionEstimator[i] = new Multinomial.LaplaceEstimator(transitionAlphabet);
                this.emissionMultinomial[i] = new Multinomial(this.getUniformArray(this.inputAlphabet.size()), this.inputAlphabet);
                this.transitionMultinomial[i] = new Multinomial(this.getUniformArray(transitionAlphabet.size()), transitionAlphabet);
                ++i;
            }
            this.initialEstimator = new Multinomial.LaplaceEstimator(transitionAlphabet);
        }
        for (Instance instance : ilist) {
            FeatureSequence input = (FeatureSequence)instance.getData();
            FeatureSequence output = (FeatureSequence)instance.getTarget();
            new SumLatticeDefault(this, input, output, new Incrementor());
        }
        this.initialMultinomial = this.initialEstimator.estimate();
        int i = 0;
        while (i < this.numStates()) {
            this.emissionMultinomial[i] = this.emissionEstimator[i].estimate();
            this.transitionMultinomial[i] = this.transitionEstimator[i].estimate();
            this.getState(i).setInitialWeight(this.initialMultinomial.logProbability(this.getState(i).getName()));
            ++i;
        }
        return true;
    }

    public void write(File f) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f + ": " + e);
        }
    }

    private double[] getUniformArray(int size) {
        double[] ret = new double[size];
        int i = 0;
        while (i < size) {
            ret[i] = 1.0 / (double)size;
            ++i;
        }
        return ret;
    }

    private double[] getRandomArray(int size, Random random, double noise) {
        double[] ret = new double[size];
        double sum = 0.0;
        int i = 0;
        while (i < size) {
            ret[i] = random == null ? 1.0 : Math.pow(1.0 + random.nextDouble(), noise);
            sum += ret[i];
            ++i;
        }
        i = 0;
        while (i < size) {
            int n = i++;
            ret[n] = ret[n] / sum;
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.inputPipe);
        out.writeObject(this.outputPipe);
        out.writeObject(this.inputAlphabet);
        out.writeObject(this.outputAlphabet);
        int size = this.states.size();
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            out.writeObject(this.states.get(i));
            ++i;
        }
        size = this.initialStates.size();
        out.writeInt(size);
        i = 0;
        while (i < size) {
            out.writeObject(this.initialStates.get(i));
            ++i;
        }
        out.writeObject(this.name2state);
        if (this.emissionEstimator != null) {
            size = this.emissionEstimator.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.emissionEstimator[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.emissionMultinomial != null) {
            size = this.emissionMultinomial.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.emissionMultinomial[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.transitionEstimator != null) {
            size = this.transitionEstimator.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.transitionEstimator[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
        if (this.transitionMultinomial != null) {
            size = this.transitionMultinomial.length;
            out.writeInt(size);
            i = 0;
            while (i < size) {
                out.writeObject(this.transitionMultinomial[i]);
                ++i;
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        State s2;
        int version2 = in.readInt();
        this.inputPipe = (Pipe)in.readObject();
        this.outputPipe = (Pipe)in.readObject();
        this.inputAlphabet = (Alphabet)in.readObject();
        this.outputAlphabet = (Alphabet)in.readObject();
        int size = in.readInt();
        this.states = new ArrayList();
        int i = 0;
        while (i < size) {
            s2 = (State)in.readObject();
            this.states.add(s2);
            ++i;
        }
        size = in.readInt();
        this.initialStates = new ArrayList();
        i = 0;
        while (i < size) {
            s2 = (State)in.readObject();
            this.initialStates.add(s2);
            ++i;
        }
        this.name2state = (HashMap)in.readObject();
        size = in.readInt();
        if (size == -1) {
            this.emissionEstimator = null;
        } else {
            this.emissionEstimator = new Multinomial.Estimator[size];
            i = 0;
            while (i < size) {
                this.emissionEstimator[i] = (Multinomial.Estimator)in.readObject();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.emissionMultinomial = null;
        } else {
            this.emissionMultinomial = new Multinomial[size];
            i = 0;
            while (i < size) {
                this.emissionMultinomial[i] = (Multinomial)in.readObject();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.transitionEstimator = null;
        } else {
            this.transitionEstimator = new Multinomial.Estimator[size];
            i = 0;
            while (i < size) {
                this.transitionEstimator[i] = (Multinomial.Estimator)in.readObject();
                ++i;
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.transitionMultinomial = null;
        } else {
            this.transitionMultinomial = new Multinomial[size];
            i = 0;
            while (i < size) {
                this.transitionMultinomial[i] = (Multinomial)in.readObject();
                ++i;
            }
        }
    }

    public class Incrementor
    implements Transducer.Incrementor {
        @Override
        public void incrementFinalState(Transducer.State s2, double count) {
        }

        @Override
        public void incrementInitialState(Transducer.State s2, double count) {
            HMM.this.initialEstimator.increment(s2.getName(), count);
        }

        @Override
        public void incrementTransition(Transducer.TransitionIterator ti, double count) {
            int inputFtr = (Integer)ti.getInput();
            State src = (State)((TransitionIterator)ti).getSourceState();
            State dest = (State)((TransitionIterator)ti).getDestinationState();
            int index = ti.getIndex();
            HMM.this.emissionEstimator[index].increment(inputFtr, count);
            HMM.this.transitionEstimator[src.getIndex()].increment(dest.getName(), count);
        }
    }

    public static class State
    extends Transducer.State
    implements Serializable {
        String name;
        int index;
        double initialWeight;
        double finalWeight;
        String[] destinationNames;
        State[] destinations;
        String[] labels;
        HMM hmm;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;
        private static final int NULL_INTEGER = -1;

        protected State() {
        }

        protected State(String name, int index, double initialWeight, double finalWeight, String[] destinationNames, String[] labelNames, HMM hmm) {
            assert (destinationNames.length == labelNames.length);
            this.name = name;
            this.index = index;
            this.initialWeight = initialWeight;
            this.finalWeight = finalWeight;
            this.destinationNames = new String[destinationNames.length];
            this.destinations = new State[labelNames.length];
            this.labels = new String[labelNames.length];
            this.hmm = hmm;
            int i = 0;
            while (i < labelNames.length) {
                hmm.outputAlphabet.lookupIndex(labelNames[i]);
                this.destinationNames[i] = destinationNames[i];
                this.labels[i] = labelNames[i];
                ++i;
            }
        }

        @Override
        public Transducer getTransducer() {
            return this.hmm;
        }

        @Override
        public double getFinalWeight() {
            return this.finalWeight;
        }

        @Override
        public double getInitialWeight() {
            return this.initialWeight;
        }

        @Override
        public void setFinalWeight(double c) {
            this.finalWeight = c;
        }

        @Override
        public void setInitialWeight(double c) {
            this.initialWeight = c;
        }

        public void print() {
            System.out.println("State #" + this.index + " \"" + this.name + "\"");
            System.out.println("initialWeight=" + this.initialWeight + ", finalWeight=" + this.finalWeight);
            System.out.println("#destinations=" + this.destinations.length);
            int i = 0;
            while (i < this.destinations.length) {
                System.out.println("-> " + this.destinationNames[i]);
                ++i;
            }
        }

        public State getDestinationState(int index) {
            State ret = this.destinations[index];
            if (ret == null) {
                ret = this.destinations[index] = this.hmm.name2state.get(this.destinationNames[index]);
                assert (ret != null) : index;
            }
            return ret;
        }

        @Override
        public Transducer.TransitionIterator transitionIterator(Sequence inputSequence, int inputPosition, Sequence outputSequence, int outputPosition) {
            if (inputPosition < 0 || outputPosition < 0) {
                throw new UnsupportedOperationException("Epsilon transitions not implemented.");
            }
            if (inputSequence == null) {
                throw new UnsupportedOperationException("HMMs are generative models; but this is not yet implemented.");
            }
            if (!(inputSequence instanceof FeatureSequence)) {
                throw new UnsupportedOperationException("HMMs currently expect Instances to have FeatureSequence data");
            }
            return new TransitionIterator(this, (FeatureSequence)inputSequence, inputPosition, outputSequence == null ? null : (String)outputSequence.get(outputPosition), this.hmm);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public void incrementInitialCount(double count) {
        }

        public void incrementFinalCount(double count) {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            int i;
            out.writeInt(0);
            out.writeObject(this.name);
            out.writeInt(this.index);
            int size = this.destinationNames == null ? -1 : this.destinationNames.length;
            out.writeInt(size);
            if (size != -1) {
                i = 0;
                while (i < size) {
                    out.writeObject(this.destinationNames[i]);
                    ++i;
                }
            }
            size = this.destinations == null ? -1 : this.destinations.length;
            out.writeInt(size);
            if (size != -1) {
                i = 0;
                while (i < size) {
                    out.writeObject(this.destinations[i]);
                    ++i;
                }
            }
            size = this.labels == null ? -1 : this.labels.length;
            out.writeInt(size);
            if (size != -1) {
                i = 0;
                while (i < size) {
                    out.writeObject(this.labels[i]);
                    ++i;
                }
            }
            out.writeObject(this.hmm);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int i;
            int version2 = in.readInt();
            this.name = (String)in.readObject();
            this.index = in.readInt();
            int size = in.readInt();
            if (size != -1) {
                this.destinationNames = new String[size];
                i = 0;
                while (i < size) {
                    this.destinationNames[i] = (String)in.readObject();
                    ++i;
                }
            } else {
                this.destinationNames = null;
            }
            size = in.readInt();
            if (size != -1) {
                this.destinations = new State[size];
                i = 0;
                while (i < size) {
                    this.destinations[i] = (State)in.readObject();
                    ++i;
                }
            } else {
                this.destinations = null;
            }
            size = in.readInt();
            if (size != -1) {
                this.labels = new String[size];
                i = 0;
                while (i < size) {
                    this.labels[i] = (String)in.readObject();
                    ++i;
                }
            } else {
                this.labels = null;
            }
            this.hmm = (HMM)in.readObject();
        }
    }

    protected static class TransitionIterator
    extends Transducer.TransitionIterator
    implements Serializable {
        State source;
        int index;
        int nextIndex;
        int inputPos;
        double[] weights;
        FeatureSequence inputSequence;
        Integer inputFeature;
        HMM hmm;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;
        private static final int NULL_INTEGER = -1;

        public TransitionIterator(State source, FeatureSequence inputSeq, int inputPosition, String output, HMM hmm) {
            this.source = source;
            this.hmm = hmm;
            this.inputSequence = inputSeq;
            this.inputFeature = new Integer(this.inputSequence.getIndexAtPosition(inputPosition));
            this.inputPos = inputPosition;
            this.weights = new double[source.destinations.length];
            int transIndex = 0;
            while (transIndex < source.destinations.length) {
                if (output == null || output.equals(source.labels[transIndex])) {
                    this.weights[transIndex] = 0.0;
                    int destIndex = source.getDestinationState(transIndex).getIndex();
                    double logEmissionProb = hmm.emissionMultinomial[destIndex].logProbability(inputSeq.get(inputPosition));
                    double logTransitionProb = hmm.transitionMultinomial[source.getIndex()].logProbability(source.destinationNames[transIndex]);
                    this.weights[transIndex] = logEmissionProb + logTransitionProb;
                    assert (!Double.isNaN(this.weights[transIndex]));
                } else {
                    this.weights[transIndex] = Double.NEGATIVE_INFINITY;
                }
                ++transIndex;
            }
            this.nextIndex = 0;
            while (this.nextIndex < source.destinations.length && this.weights[this.nextIndex] == Double.NEGATIVE_INFINITY) {
                ++this.nextIndex;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.source.destinations.length;
        }

        @Override
        public Transducer.State nextState() {
            assert (this.nextIndex < this.source.destinations.length);
            this.index = this.nextIndex++;
            while (this.nextIndex < this.source.destinations.length && this.weights[this.nextIndex] == Double.NEGATIVE_INFINITY) {
                ++this.nextIndex;
            }
            return this.source.getDestinationState(this.index);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Object getInput() {
            return this.inputFeature;
        }

        @Override
        public Object getOutput() {
            return this.source.labels[this.index];
        }

        @Override
        public double getWeight() {
            return this.weights[this.index];
        }

        @Override
        public Transducer.State getSourceState() {
            return this.source;
        }

        @Override
        public Transducer.State getDestinationState() {
            return this.source.getDestinationState(this.index);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeObject(this.source);
            out.writeInt(this.index);
            out.writeInt(this.nextIndex);
            out.writeInt(this.inputPos);
            if (this.weights != null) {
                out.writeInt(this.weights.length);
                int i = 0;
                while (i < this.weights.length) {
                    out.writeDouble(this.weights[i]);
                    ++i;
                }
            } else {
                out.writeInt(-1);
            }
            out.writeObject(this.inputSequence);
            out.writeObject(this.inputFeature);
            out.writeObject(this.hmm);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version2 = in.readInt();
            this.source = (State)in.readObject();
            this.index = in.readInt();
            this.nextIndex = in.readInt();
            this.inputPos = in.readInt();
            int size = in.readInt();
            if (size == -1) {
                this.weights = null;
            } else {
                this.weights = new double[size];
                int i = 0;
                while (i < size) {
                    this.weights[i] = in.readDouble();
                    ++i;
                }
            }
            this.inputSequence = (FeatureSequence)in.readObject();
            this.inputFeature = (Integer)in.readObject();
            this.hmm = (HMM)in.readObject();
        }
    }

    public class WeightedIncrementor
    implements Transducer.Incrementor {
        double weight = 1.0;

        public WeightedIncrementor(double wt) {
            this.weight = wt;
        }

        @Override
        public void incrementFinalState(Transducer.State s2, double count) {
        }

        @Override
        public void incrementInitialState(Transducer.State s2, double count) {
            HMM.this.initialEstimator.increment(s2.getName(), this.weight * count);
        }

        @Override
        public void incrementTransition(Transducer.TransitionIterator ti, double count) {
            int inputFtr = (Integer)ti.getInput();
            State src = (State)((TransitionIterator)ti).getSourceState();
            State dest = (State)((TransitionIterator)ti).getDestinationState();
            int index = ti.getIndex();
            HMM.this.emissionEstimator[index].increment(inputFtr, this.weight * count);
            HMM.this.transitionEstimator[src.getIndex()].increment(dest.getName(), this.weight * count);
        }
    }
}

