/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.util;

import java.io.Serializable;

public class PairwiseMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    double[][] vals;

    public PairwiseMatrix(int size) {
        this.vals = new double[size - 1][];
        int i = 0;
        while (i < size - 1) {
            this.vals[i] = new double[size - i - 1];
            int j = 0;
            while (j < this.vals[i].length) {
                this.vals[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void set(int i, int j, double v) {
        int[] indices = this.sort(i, j);
        this.vals[indices[0]][indices[1] - indices[0] - 1] = v;
    }

    public double get(int i, int j) {
        int[] indices = this.sort(i, j);
        return this.vals[indices[0]][indices[1] - indices[0] - 1];
    }

    public int length(int i) {
        return this.vals[i].length;
    }

    private int[] sort(int i, int j) {
        int[] ret = new int[2];
        if (i < j) {
            ret[0] = i;
            ret[1] = j;
        } else {
            ret[0] = j;
            ret[1] = i;
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.vals.length) {
            int j = 0;
            while (j < this.vals[i].length) {
                buf.append(String.valueOf(this.vals[i][j]) + "    ");
                ++j;
            }
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        int size = Integer.parseInt(args[0]);
        PairwiseMatrix m3 = new PairwiseMatrix(size);
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                m3.set(i, j, Double.parseDouble(String.valueOf(i) + j));
                ++j;
            }
            ++i;
        }
        System.err.println(m3);
    }
}

