#!/usr/bin/perl

use strict;
use warnings;

package Jls::Uri;

use Exporter;
our @ISA = 'Exporter';
our @EXPORT = 'query_string_to_hash decode_uri_string_to_ascii';

=head 1

# Converts a uri query string to a hash.
sub query_string_to_hash 
# $query_string_ // $ENV{'QUERY_STRING'}

# Decodes an encoded uri string to ascii.
sub decode_uri_string_to_ascii 
# $string_ // encoded uri string

=cut

# Converts a uri query string to a hash.
sub query_string_to_hash 
# $query_string_ // $ENV{'QUERY_STRING'}
{
    (my $query_string_) = $_ [0];

    my %param;

    if (length ($query_string_) == 0) { return %param; }

    my @pairs = split (/&|;/, $query_string_);

    foreach my $pair (@pairs)
    {
        my @array = split (/=/, $pair);
        if ($#array == -1) { next; }
        if ($#array == 0) { next; }
        elsif (1 < $#array) { die $!; }
        my $name = $array [0];
        my $value = $array [1];
        $value = decode_uri_string_to_ascii ($value);
        $param {$name} = $value; 
    }    

    return %param;
}

# Decodes an encoded uri string to ascii.
sub decode_uri_string_to_ascii 
# $string_ // encoded uri string
{
    (my $string_) = $_ [0];

# Code is from: 
#     http://glennf.com/writing/hexadecimal.url.encoding.html 
    $string_ =~ s/%([a-fA-F0-9][a-fA-F0-9])/chr(hex($1))/eg;
# Another variant from
#     http://glennf.com/writing/hexadecimal.url.encoding.html 
#     $string_ =~ s/([\W])/"%" . uc(sprintf("%2.2x",ord($1)))/eg;

# Faulty variants follow:
#    $string_ =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

    return $string_;
}

1;
