/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.utils.dict;

import de.julielab.genemapper.utils.dict.Column;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.TreeSet;

public class ThesaurusCleaner {
    private final boolean debug = false;
    ArrayList<Column> positive = new ArrayList();
    ArrayList<Column> negative = new ArrayList();
    ArrayList<String> negSources = new ArrayList();
    TreeSet<String> acSet = new TreeSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSelection(File selection) {
        BufferedReader bis = null;
        try {
            String line;
            bis = new BufferedReader(new FileReader(selection));
            System.out.println("------------------ cleaning definition ----------");
            while ((line = bis.readLine()) != null) {
                if (line.startsWith("##")) continue;
                String[] values = line.split("\t");
                if (values[1].charAt(0) == '+') {
                    System.out.println("cleaning def: positive entry: " + line);
                    this.positive.add(new Column(Integer.parseInt(values[0]), values[1].substring(1), Boolean.parseBoolean(values[2])));
                    continue;
                }
                if (values[1].charAt(0) == '-') {
                    System.out.println("cleaning def: negative entry: " + line);
                    int col = Integer.parseInt(values[0]);
                    if (col == 3) {
                        this.negSources.add(values[1].substring(1));
                        continue;
                    }
                    System.out.println(col);
                    this.negative.add(new Column(col, values[1].substring(1), Boolean.parseBoolean(values[2])));
                    continue;
                }
                System.err.println("Undefined sequence!");
                break;
            }
            System.out.println("-----------------------------------------\n");
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean trustSources(String sources) {
        boolean trust = true;
        int neg = 0;
        String[] split = sources.split("\\+\\+\\+");
        block0: for (int i = 0; i < split.length; ++i) {
            for (int j = 0; j < this.negSources.size(); ++j) {
                if (!split[i].contains(this.negSources.get(j))) continue;
                ++neg;
                continue block0;
            }
        }
        if (neg == split.length) {
            trust = false;
        }
        return trust;
    }

    void pickLines(File from, String to) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(from));
            FileWriter writer = new FileWriter(to);
            int counter = 0;
            while ((line = reader.readLine()) != null) {
                String[] tokens;
                boolean removeLine = false;
                String[] fields = line.split("\t");
                if (!this.acSet.contains(fields[0])) {
                    this.debug("removing because of review status: " + fields[0]);
                    continue;
                }
                if (this.acSet.contains("Q8N2L1")) {
                    this.debug("Q8N2L1 is in AC set!!!!!");
                }
                for (Column column : this.negative) {
                    if (!column.getMatchStyle()) {
                        if (!fields[column.getColumn() - 1].contains(column.getFilter())) continue;
                        removeLine = true;
                        this.debug("removing because of negative filter: " + column.getFilter() + "\t" + column.getColumn());
                        break;
                    }
                    if (!fields[column.getColumn() - 1].equals(column.getFilter())) continue;
                    removeLine = true;
                    this.debug("removing because of negative filter: " + column.getFilter() + "\t" + column.getColumn());
                    break;
                }
                if (this.negSources.size() > 0 && !this.trustSources(fields[2])) {
                    removeLine = true;
                    this.debug("removing because of source: " + fields[2]);
                }
                if (!removeLine && (tokens = fields[1].split("\\s")).length < 2) {
                    if (tokens[0].length() == 1) {
                        removeLine = true;
                        continue;
                    }
                    if (tokens[0].matches("[0-9]+")) {
                        removeLine = true;
                        continue;
                    }
                }
                if (!removeLine) {
                    removeLine = true;
                    for (Column column : this.positive) {
                        if (!column.getMatchStyle()) {
                            if (!fields[column.getColumn() - 1].contains(column.getFilter())) continue;
                            removeLine = false;
                            this.debug("keeping because of positive filter: " + column.getFilter() + "\t" + column.getColumn());
                            break;
                        }
                        this.debug("THERE: " + fields[0]);
                        if (!fields[column.getColumn() - 1].equals(column.getFilter())) continue;
                        removeLine = false;
                        this.debug("keeping because of positive filter: " + column.getFilter() + "\t" + column.getColumn());
                        break;
                    }
                }
                if (removeLine) continue;
                if (++counter % 10000 == 0) {
                    System.out.println("# cleaned entries: " + counter);
                }
                writer.write(line + "\n");
                writer.flush();
            }
            reader.close();
            writer.close();
            System.out.println(counter);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ThesaurusCleaner select = new ThesaurusCleaner();
        if (args.length != 4) {
            System.err.println("Usage: ThesaurusCleaner <cleaning definition> <BT file> <UniProt AC set> <outout file>");
            System.exit(-1);
        }
        File selection = new File(args[0]);
        File thesaurus = new File(args[1]);
        File uniprotAC = new File(args[2]);
        String outFile = args[3];
        if (!selection.isFile()) {
            System.err.println("Could not find specified cleaning definition file: " + selection);
            System.exit(-1);
        } else if (!thesaurus.isFile()) {
            System.err.println("Could not find specified thesaurus file: " + thesaurus);
            System.exit(-1);
        } else if (!thesaurus.isFile()) {
            System.err.println("Could not find specified thesaurus file: " + thesaurus);
            System.exit(-1);
        }
        try {
            System.out.println("reading set of AC entries...");
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(uniprotAC));
            select.acSet = (TreeSet)ois.readObject();
            select.readSelection(selection);
            System.out.println("cleaning thesaurus...");
            long t1 = System.currentTimeMillis();
            select.pickLines(thesaurus, outFile);
            long t2 = System.currentTimeMillis();
            System.out.println("done");
            System.out.println("time needed for cleaning: " + (t2 - t1) / 1000L + " sec");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void debug(String text) {
    }
}

