/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.utils.dict;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

public class EntrezGeneUniProtLexcionCreator {
    private static final File ENTREZUNIPROT_FILE = new File("/home/jwermter/biocreative2_data/semantic_context/up2eg.test");
    private static final File UNIPROT_FILE = new File("/data/data_resources/biology/Julie_BT/uniprot_subset/bt_iproclass_cleaned.reviewed.allOrgs.uniprot.2_11.human.norm.unique");
    private static final File ENTREZ_DESIGNATIONS_FILE = new File("/data/data_resources/biology/entrez/gene/gene2other_designations.human");
    private HashMap<String, String> uniprot2Syns;

    public static void main(String[] args) throws IOException {
        EntrezGeneUniProtLexcionCreator creator = new EntrezGeneUniProtLexcionCreator();
        creator.makeEntrezDesignations(ENTREZ_DESIGNATIONS_FILE);
    }

    private void makeEntrezDesignations(File entrezDesignationsFile) throws IOException {
        BufferedReader biothesaurusReader = new BufferedReader(new FileReader(entrezDesignationsFile));
        String line = "";
        PrintWriter pw = new PrintWriter(new FileWriter("/home/jwermter/biocreative2_data/entrezGeneDesignationsLexicon"));
        try {
            while ((line = biothesaurusReader.readLine()) != null) {
                String[] values = line.split("\t");
                String entrezID = values[0];
                String designations = values[1].trim();
                String[] syns = designations.split("\\|");
                for (int i = 0; i < syns.length; ++i) {
                    pw.println(syns[i] + "\t" + entrezID);
                }
            }
            biothesaurusReader.close();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeEntrezFile(File entrez2uniprot) throws IOException {
        BufferedReader biothesaurusReader = new BufferedReader(new FileReader(entrez2uniprot));
        String line = "";
        PrintWriter pw = new PrintWriter(new FileWriter("/home/jwermter/biocreative2_data/entrezGeneUniprotSynsLexicon"));
        try {
            while ((line = biothesaurusReader.readLine()) != null) {
                String[] values = line.split("\t");
                String uniprotID = values[0];
                String entrezID = values[1].trim();
                if (!this.uniprot2Syns.containsKey(uniprotID)) continue;
                String uniprotSyns = this.uniprot2Syns.get(uniprotID);
                String[] syns = uniprotSyns.split("\\|");
                for (int i = 0; i < syns.length; ++i) {
                    pw.println(syns[i] + "\t" + entrezID);
                }
            }
            biothesaurusReader.close();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeUniprotSyns(File uniprot) throws FileNotFoundException {
        BufferedReader biothesaurusReader = new BufferedReader(new FileReader(uniprot));
        String line = "";
        this.uniprot2Syns = new HashMap();
        try {
            while ((line = biothesaurusReader.readLine()) != null) {
                String[] values = line.split("\t");
                String id = values[1].trim();
                Object uniprotSyn = values[0].trim();
                if (this.uniprot2Syns.containsKey(id)) {
                    uniprotSyn = (String)uniprotSyn + "|" + this.uniprot2Syns.get(id);
                    this.uniprot2Syns.put(id, (String)uniprotSyn);
                    continue;
                }
                this.uniprot2Syns.put(id, (String)uniprotSyn);
            }
            biothesaurusReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

