/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.uima;

import de.julielab.jcore.types.Gene;
import de.julielab.jcore.types.Protein;
import java.util.ArrayList;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;

@ResourceMetaData(name="Protein to Gene Annotation Converter", description="Auxiliary component to make annotations of type de.julielab.jcore.types.Gene from de.julielab.jcore.types.Protein annotations. Creates Gene annotations and removes the source Protein annotations. This is useful when the Protein annotations used by GeNo need to be changed to Genes for downstream processing.")
@TypeCapability(inputs={"de.julielab.jcore.types.Gene"}, outputs={"de.julielab.jcore.types.Protein"})
public class ProteinToGeneConverter
extends JCasAnnotator_ImplBase {
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        ArrayList<Protein> proteins = new ArrayList<Protein>();
        for (Protein p : jCas.getAnnotationIndex(Protein.type)) {
            Gene g = new Gene(jCas, p.getBegin(), p.getEnd());
            g.setConfidence(p.getConfidence());
            g.setComponentId(p.getComponentId());
            g.setSpecificType(p.getSpecificType());
            g.setResourceEntryList(p.getResourceEntryList());
            g.addToIndexes();
            proteins.add(p);
        }
        proteins.forEach(TOP::removeFromIndexes);
    }
}

