/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.uima;

import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.jcore.types.AbstractText;
import de.julielab.jcore.types.Caption;
import de.julielab.jcore.types.ChunkNP;
import de.julielab.jcore.types.Gene;
import de.julielab.jcore.types.Organism;
import de.julielab.jcore.types.Paragraph;
import de.julielab.jcore.types.Section;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Title;
import de.julielab.jcore.utility.index.Comparators;
import de.julielab.jcore.utility.index.IndexTermGenerator;
import de.julielab.jcore.utility.index.JCoReTreeMapAnnotationIndex;
import de.julielab.jcore.utility.index.TermGenerators;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Gene Name TaxId Occurrence Count Writer", description="This components counts for each normalized (via the TermNormalizer#normalize method) gene mention name how often it co-occurs with species mentions (via taxonomy ID) in sentences, titles, abstracts etc.")
@TypeCapability(inputs={"de.julielab.jcore.types.Organism", "de.julielab.jcore.types.GeneMention", "de.julielab.jcore.types.ChunkNP", "de.julielab.jcore.types.Section", "de.julielab.jcore.types.Title", "de.julielab.jcore.types.AbstractText", "de.julielab.jcore.types.Paragraph", "de.julielab.jcore.types.Caption", "de.julielab.jcore.types.Sentence"})
public class GeneMentionTaxIdCountWriter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUT_PATH = "OutputPath";
    private static final Logger log = LoggerFactory.getLogger(GeneMentionTaxIdCountWriter.class);
    private static final Map<GeneNameTaxPair, GeneOccurrenceCount> counts = new ConcurrentHashMap<GeneNameTaxPair, GeneOccurrenceCount>();
    @ConfigurationParameter(name="OutputPath", description="The path to the file to be written.")
    private String outputPath;
    private TermNormalizer normalizer;
    private Map<GeneNameTaxPair, GeneOccurrenceCount> localCounts = new ConcurrentHashMap<GeneNameTaxPair, GeneOccurrenceCount>();
    private static final Phaser phaser = new Phaser();
    private boolean isRegistered;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.outputPath = (String)aContext.getConfigParameterValue(PARAM_OUTPUT_PATH);
        this.normalizer = new TermNormalizer();
        this.localCounts = new HashMap<GeneNameTaxPair, GeneOccurrenceCount>();
        log.info("{}: {}", (Object)PARAM_OUTPUT_PATH, (Object)this.outputPath);
    }

    public void process(JCas jCas) {
        if (!this.isRegistered) {
            phaser.register();
            this.isRegistered = true;
        }
        boolean hasGenes = jCas.getAnnotationIndex(Gene.type).iterator().hasNext();
        boolean hasOrganisms = jCas.getAnnotationIndex(Organism.type).iterator().hasNext();
        if (hasGenes && hasOrganisms) {
            String normalizedGeneName;
            JCoReTreeMapAnnotationIndex titleIndex = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), jCas, Title.type);
            JCoReTreeMapAnnotationIndex captionIndex = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), jCas, Caption.type);
            JCoReTreeMapAnnotationIndex npIndex = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), jCas, ChunkNP.type);
            JCoReTreeMapAnnotationIndex sentIndex = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), jCas, Sentence.type);
            JCoReTreeMapAnnotationIndex paragraphIndex = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), jCas, Paragraph.type);
            JCoReTreeMapAnnotationIndex sectionIndex = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), jCas, Section.type);
            JCoReTreeMapAnnotationIndex abstractIndex = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), jCas, AbstractText.type);
            JCoReTreeMapAnnotationIndex orgIndex = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), (IndexTermGenerator)TermGenerators.longOffsetTermGenerator(), jCas, Organism.type);
            HashSet<GeneNameTaxPair> mentionsCountedForDoc = new HashSet<GeneNameTaxPair>();
            for (Gene g : jCas.getAnnotationIndex(Gene.type)) {
                normalizedGeneName = this.normalizer.normalize(g.getCoveredText()).intern();
                Optional titleOptional = titleIndex.searchFuzzy((Annotation)g).findAny();
                if (titleOptional.isPresent()) {
                    Title title = (Title)titleOptional.get();
                    if (title.getTitleType() != null && title.getTitleType().equals("document")) {
                        this.incrementCountsForCoveredOrganisms(normalizedGeneName, (de.julielab.jcore.types.Annotation)title, GeneOccurrenceCount::incNumDocumentTitles, mentionsCountedForDoc, (JCoReTreeMapAnnotationIndex<Long, Organism>)orgIndex, this.localCounts);
                        continue;
                    }
                    this.incrementCountsForCoveredOrganisms(normalizedGeneName, (de.julielab.jcore.types.Annotation)title, GeneOccurrenceCount::incNumTitles, mentionsCountedForDoc, (JCoReTreeMapAnnotationIndex<Long, Organism>)orgIndex, this.localCounts);
                    continue;
                }
                Optional captionOptional = captionIndex.searchFuzzy((Annotation)g).findAny();
                if (captionOptional.isPresent()) {
                    this.incrementCountsForCoveredOrganisms(normalizedGeneName, (de.julielab.jcore.types.Annotation)captionOptional.get(), GeneOccurrenceCount::incNumCaptions, mentionsCountedForDoc, (JCoReTreeMapAnnotationIndex<Long, Organism>)orgIndex, this.localCounts);
                    continue;
                }
                Optional chunkNPOptional = npIndex.searchFuzzy((Annotation)g).findAny();
                if (chunkNPOptional.isPresent()) {
                    this.incrementCountsForCoveredOrganisms(normalizedGeneName, (de.julielab.jcore.types.Annotation)chunkNPOptional.get(), GeneOccurrenceCount::incNumNps, mentionsCountedForDoc, (JCoReTreeMapAnnotationIndex<Long, Organism>)orgIndex, this.localCounts);
                    continue;
                }
                Optional sentenceOptional = sentIndex.searchFuzzy((Annotation)g).findAny();
                if (sentenceOptional.isPresent()) {
                    this.incrementCountsForCoveredOrganisms(normalizedGeneName, (de.julielab.jcore.types.Annotation)sentenceOptional.get(), GeneOccurrenceCount::incNumSentences, mentionsCountedForDoc, (JCoReTreeMapAnnotationIndex<Long, Organism>)orgIndex, this.localCounts);
                    continue;
                }
                Optional paragraphOptional = paragraphIndex.searchFuzzy((Annotation)g).findAny();
                if (paragraphOptional.isPresent()) {
                    this.incrementCountsForCoveredOrganisms(normalizedGeneName, (de.julielab.jcore.types.Annotation)paragraphOptional.get(), GeneOccurrenceCount::incNumParagraphs, mentionsCountedForDoc, (JCoReTreeMapAnnotationIndex<Long, Organism>)orgIndex, this.localCounts);
                    continue;
                }
                Optional abstractOptional = abstractIndex.searchFuzzy((Annotation)g).findAny();
                if (abstractOptional.isPresent()) {
                    this.incrementCountsForCoveredOrganisms(normalizedGeneName, (de.julielab.jcore.types.Annotation)abstractOptional.get(), GeneOccurrenceCount::incNumAbstracts, mentionsCountedForDoc, (JCoReTreeMapAnnotationIndex<Long, Organism>)orgIndex, this.localCounts);
                    continue;
                }
                Optional sectionOptional = sectionIndex.searchFuzzy((Annotation)g).findAny();
                if (!sectionOptional.isPresent()) continue;
                this.incrementCountsForCoveredOrganisms(normalizedGeneName, (de.julielab.jcore.types.Annotation)sectionOptional.get(), GeneOccurrenceCount::incNumSections, mentionsCountedForDoc, (JCoReTreeMapAnnotationIndex<Long, Organism>)orgIndex, this.localCounts);
            }
            for (Gene g : jCas.getAnnotationIndex(Gene.type)) {
                normalizedGeneName = this.normalizer.normalize(g.getCoveredText()).intern();
                for (Organism o : jCas.getAnnotationIndex(Organism.type)) {
                    String taxId;
                    GeneNameTaxPair p;
                    if (o.getResourceEntryList() == null || !mentionsCountedForDoc.add(p = new GeneNameTaxPair(normalizedGeneName, taxId = o.getResourceEntryList(0).getEntryId()))) continue;
                    this.localCounts.compute(p, (k, v) -> v != null ? v : new GeneOccurrenceCount()).incNumDocs();
                }
            }
        }
    }

    public void batchProcessComplete() {
        this.mergeCounts(this.localCounts);
        this.localCounts.clear();
    }

    private void mergeCounts(Map<GeneNameTaxPair, GeneOccurrenceCount> counts) {
        for (GeneNameTaxPair key : counts.keySet()) {
            GeneOccurrenceCount geneOccurrenceCount = counts.get(key);
            GeneOccurrenceCount officialCount = GeneMentionTaxIdCountWriter.counts.compute(key, (k, v) -> v != null ? v : new GeneOccurrenceCount());
            officialCount.incNumDocs(geneOccurrenceCount.getNumDocs());
            officialCount.incNumNps(geneOccurrenceCount.getNumNps());
            officialCount.incNumAbstracts(geneOccurrenceCount.getNumAbstracts());
            officialCount.incNumCaptions(geneOccurrenceCount.getNumCaptions());
            officialCount.incNumDocumentTitles(geneOccurrenceCount.getNumDocumentTitles());
            officialCount.incNumParagraphs(geneOccurrenceCount.getNumParagraphs());
            officialCount.incNumSections(geneOccurrenceCount.getNumSections());
            officialCount.incNumSentences(geneOccurrenceCount.getNumSentences());
            officialCount.incNumTitles(geneOccurrenceCount.getNumTitles());
        }
    }

    public void incrementCountsForCoveredOrganisms(String normalizedGeneName, de.julielab.jcore.types.Annotation a, Consumer<GeneOccurrenceCount> npIncrementer, Set<GeneNameTaxPair> mentionsCountedForDoc, JCoReTreeMapAnnotationIndex<Long, Organism> orgIndex, Map<GeneNameTaxPair, GeneOccurrenceCount> counts) {
        orgIndex.searchFuzzy((Annotation)a).forEach(o -> {
            if (o.getResourceEntryList() != null) {
                String taxId = o.getResourceEntryList(0).getEntryId().intern();
                GeneNameTaxPair pair = new GeneNameTaxPair(normalizedGeneName, taxId);
                GeneOccurrenceCount count = counts.compute(pair, (k, v) -> v != null ? v : new GeneOccurrenceCount());
                npIncrementer.accept(count);
                mentionsCountedForDoc.add(new GeneNameTaxPair(normalizedGeneName, taxId));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectionProcessComplete() {
        this.batchProcessComplete();
        phaser.arriveAndDeregister();
        Class<GeneMentionTaxIdCountWriter> clazz = GeneMentionTaxIdCountWriter.class;
        synchronized (GeneMentionTaxIdCountWriter.class) {
            if (phaser.getUnarrivedParties() == 0) {
                log.info("Writing the taxonomy ID counts for {} gene names to {}", (Object)counts.size(), (Object)this.outputPath);
                List<String> header = Arrays.asList("genename", "taxid", "#abstracts", "#captions", "#docs", "#document_titles", "#nps", "#paragraphs", "#sections", "#sentences", "#titles");
                File file = new File(this.outputPath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                try (BufferedWriter writer = FileUtilities.getWriterToFile((File)file);){
                    writer.write(String.join((CharSequence)"\t", header));
                    writer.newLine();
                    ArrayList<String> columns = new ArrayList<String>();
                    log.info("Writing {} gene-organism occurrence counts to {}", (Object)counts.size(), (Object)this.outputPath);
                    for (GeneNameTaxPair p : counts.keySet()) {
                        GeneOccurrenceCount count = counts.get(p);
                        columns.add(p.getGeneName());
                        columns.add(p.getTaxId());
                        columns.add(String.valueOf(count.getNumAbstracts() > 0 ? Integer.valueOf(count.getNumAbstracts()) : ""));
                        columns.add(String.valueOf(count.getNumCaptions() > 0 ? Integer.valueOf(count.getNumCaptions()) : ""));
                        columns.add(String.valueOf(count.getNumDocs() > 0 ? Integer.valueOf(count.getNumDocs()) : ""));
                        columns.add(String.valueOf(count.getNumDocumentTitles() > 0 ? Integer.valueOf(count.getNumDocumentTitles()) : ""));
                        columns.add(String.valueOf(count.getNumNps() > 0 ? Integer.valueOf(count.getNumNps()) : ""));
                        columns.add(String.valueOf(count.getNumParagraphs() > 0 ? Integer.valueOf(count.getNumParagraphs()) : ""));
                        columns.add(String.valueOf(count.getNumSections() > 0 ? Integer.valueOf(count.getNumSections()) : ""));
                        columns.add(String.valueOf(count.getNumSentences() > 0 ? Integer.valueOf(count.getNumSentences()) : ""));
                        columns.add(String.valueOf(count.getNumTitles() > 0 ? Integer.valueOf(count.getNumTitles()) : ""));
                        writer.write(String.join((CharSequence)"\t", columns));
                        writer.newLine();
                        columns.clear();
                    }
                    log.info("Done.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class GeneNameTaxPair {
        private final String geneName;
        private final String taxId;

        public GeneNameTaxPair(String geneName, String taxId) {
            this.geneName = geneName;
            this.taxId = taxId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GeneNameTaxPair that = (GeneNameTaxPair)o;
            return this.geneName.equals(that.geneName) && this.taxId.equals(that.taxId);
        }

        public String toString() {
            return "GeneNameTaxPair{geneName='" + this.geneName + "', taxId='" + this.taxId + "'}";
        }

        public int hashCode() {
            return Objects.hash(this.geneName, this.taxId);
        }

        public String getGeneName() {
            return this.geneName;
        }

        public String getTaxId() {
            return this.taxId;
        }
    }

    private static class GeneOccurrenceCount {
        private AtomicInteger numCaptions;
        private AtomicInteger numNps;
        private AtomicInteger numDocumentTitles;
        private AtomicInteger numTitles;
        private AtomicInteger numSentences;
        private AtomicInteger numParagraphs;
        private AtomicInteger numSections;
        private AtomicInteger numAbstracts;
        private AtomicInteger numDocs;

        public void incNumDocumentTitles() {
            if (this.numDocumentTitles == null) {
                this.numDocumentTitles = new AtomicInteger();
            }
            this.numDocumentTitles.incrementAndGet();
        }

        public void incNumCaptions() {
            if (this.numCaptions == null) {
                this.numCaptions = new AtomicInteger();
            }
            this.numCaptions.incrementAndGet();
        }

        public void incNumTitles() {
            if (this.numTitles == null) {
                this.numTitles = new AtomicInteger();
            }
            this.numTitles.incrementAndGet();
        }

        public void incNumNps() {
            if (this.numNps == null) {
                this.numNps = new AtomicInteger();
            }
            this.numNps.incrementAndGet();
        }

        public void incNumSentences() {
            if (this.numSentences == null) {
                this.numSentences = new AtomicInteger();
            }
            this.numSentences.incrementAndGet();
        }

        public void incNumDocs() {
            if (this.numDocs == null) {
                this.numDocs = new AtomicInteger();
            }
            this.numDocs.incrementAndGet();
        }

        public void incNumParagraphs() {
            if (this.numParagraphs == null) {
                this.numParagraphs = new AtomicInteger();
            }
            this.numParagraphs.incrementAndGet();
        }

        public void incNumAbstracts() {
            if (this.numAbstracts == null) {
                this.numAbstracts = new AtomicInteger();
            }
            this.numAbstracts.incrementAndGet();
        }

        public void incNumSections() {
            if (this.numSections == null) {
                this.numSections = new AtomicInteger();
            }
            this.numSections.incrementAndGet();
        }

        public void incNumDocumentTitles(int num) {
            if (this.numDocumentTitles == null) {
                this.numDocumentTitles = new AtomicInteger();
            }
            this.numDocumentTitles.addAndGet(num);
        }

        public void incNumCaptions(int num) {
            if (this.numCaptions == null) {
                this.numCaptions = new AtomicInteger();
            }
            this.numCaptions.addAndGet(num);
        }

        public void incNumTitles(int num) {
            if (this.numTitles == null) {
                this.numTitles = new AtomicInteger();
            }
            this.numTitles.addAndGet(num);
        }

        public void incNumNps(int num) {
            if (this.numNps == null) {
                this.numNps = new AtomicInteger();
            }
            this.numNps.addAndGet(num);
        }

        public void incNumSentences(int num) {
            if (this.numSentences == null) {
                this.numSentences = new AtomicInteger();
            }
            this.numSentences.addAndGet(num);
        }

        public void incNumDocs(int num) {
            if (this.numDocs == null) {
                this.numDocs = new AtomicInteger();
            }
            this.numDocs.addAndGet(num);
        }

        public void incNumParagraphs(int num) {
            if (this.numParagraphs == null) {
                this.numParagraphs = new AtomicInteger();
            }
            this.numParagraphs.addAndGet(num);
        }

        public void incNumAbstracts(int num) {
            if (this.numAbstracts == null) {
                this.numAbstracts = new AtomicInteger();
            }
            this.numAbstracts.addAndGet(num);
        }

        public void incNumSections(int num) {
            if (this.numSections == null) {
                this.numSections = new AtomicInteger();
            }
            this.numSections.addAndGet(num);
        }

        public int getNumDocumentTitles() {
            return this.numDocumentTitles != null ? this.numDocumentTitles.get() : 0;
        }

        public int getNumTitles() {
            return this.numTitles != null ? this.numTitles.get() : 0;
        }

        public int getNumNps() {
            return this.numNps != null ? this.numNps.get() : 0;
        }

        public int getNumCaptions() {
            return this.numCaptions != null ? this.numCaptions.get() : 0;
        }

        public int getNumSentences() {
            return this.numSentences != null ? this.numSentences.get() : 0;
        }

        public int getNumDocs() {
            return this.numDocs != null ? this.numDocs.get() : 0;
        }

        public int getNumParagraphs() {
            return this.numParagraphs != null ? this.numParagraphs.get() : 0;
        }

        public int getNumSections() {
            return this.numSections != null ? this.numSections.get() : 0;
        }

        public int getNumAbstracts() {
            return this.numAbstracts != null ? this.numAbstracts.get() : 0;
        }
    }
}

