/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.uima;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.GeneMapper;
import de.julielab.genemapper.evaluation.tools.Stats;
import de.julielab.genemapper.genemodel.GeneDocumentFactory;
import de.julielab.genemapper.ioc.GeneMappingModule;
import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.GeneResourceEntry;
import de.julielab.jcore.utility.JCoReTools;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.search.BooleanQuery;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Gene Mapper AE", description="Assigns NCBI Gene IDs to entity annotations. The IDs are set to the entity annotations via the resourceEntryList feature. For this purpose, the component requires extensive external resources, especially the Lucene indexes containing information about gene names and gene context information like descriptions. These resource can be built using the gene-mapper-resources module.")
public class GeneMapperAnnotator
extends JCasAnnotator_ImplBase {
    public static final String COMPONENT_ID = GeneMapper.class.getCanonicalName();
    public static final String CONTEXT_WINDOW_SIZE = "ContextWindowSize";
    public static final String TOKEN_CONTEXT = "TokenContext";
    public static final String ENTITY_MAPPING_TYPES = "EntityMappingTypes";
    public static final String MAPPER_CONFIG_FILE = "MapperConfigFile";
    public static final String REMOVE_EXISTING_RESOURCE_ENTRIES = "RemoveExistingResourceEntries";
    private static final Logger log = LoggerFactory.getLogger(GeneMapperAnnotator.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000");
    private static Injector injector;
    @ConfigurationParameter(name="EntityMappingTypes", description="A list of fully qualified UIMA entity types and regexp patterns which will be applied to the specificType attribute. Each line in the string array is assumed to have the following format: <class-name-of-entity>=<specType regexes> where the specTypes should be delimited with a '|'. An entity will be mapped as a gene/protein if any of the given regular expressions match its specificType feature value.")
    private String[] entityTypeMappings;
    @ConfigurationParameter(name="MapperConfigFile", description="A properties file containing configuration settings for the mapping.")
    private String mapperConfigFile;
    @ConfigurationParameter(name="TokenContext")
    private Boolean useTokenContext;
    @ConfigurationParameter(name="ContextWindowSize", description="The size - in the number of tokens - to be used for the window around an entity mention to be mapped.", mandatory=false)
    private Integer contextTokenWindowSize;
    @ConfigurationParameter(name="RemoveExistingResourceEntries", mandatory=false, description="If set to true, already existing ResourceEntry items set to a mapped entity's resourceEntryList feature will be cleared before setting the ID mapping calculated by this component.")
    private Boolean removeExistingResourceEntries;
    private HashMap<String, Matcher> entityMappingTypes = null;
    private GeneMapper mapper = null;
    private GeneDocumentFactory documentFactory;
    private Parameters parameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mapperConfigFile = (String)aContext.getConfigParameterValue(MAPPER_CONFIG_FILE);
        this.getEntityMappingTypes(aContext);
        this.useTokenContext = (Boolean)aContext.getConfigParameterValue(TOKEN_CONTEXT);
        this.contextTokenWindowSize = this.useTokenContext != false ? Optional.ofNullable(Integer.valueOf((Integer)aContext.getConfigParameterValue(CONTEXT_WINDOW_SIZE))).orElse(50) : 0;
        this.removeExistingResourceEntries = Optional.ofNullable((Boolean)aContext.getConfigParameterValue(REMOVE_EXISTING_RESOURCE_ENTRIES)).orElse(false);
        try {
            Configuration configuration = new Configuration(new File(this.mapperConfigFile));
            this.parameters = new Parameters((Properties)((Object)configuration));
            Class<GeneMapperAnnotator> clazz = GeneMapperAnnotator.class;
            synchronized (GeneMapperAnnotator.class) {
                if (injector == null) {
                    injector = Guice.createInjector((Module[])new Module[]{new GeneMappingModule(configuration)});
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
                this.mapper = (GeneMapper)injector.getInstance(GeneMapper.class);
                this.documentFactory = (GeneDocumentFactory)injector.getInstance(GeneDocumentFactory.class);
            }
        }
        catch (IOException e) {
            log.error("Could not load configuration from {}", (Object)this.mapperConfigFile);
            throw new ResourceInitializationException((Throwable)e);
        }
        {
            this.logConfigurationParameters();
            return;
        }
    }

    private void logConfigurationParameters() {
        log.info("{}: {}", (Object)CONTEXT_WINDOW_SIZE, (Object)this.contextTokenWindowSize);
        log.info("{}: {}", (Object)TOKEN_CONTEXT, (Object)this.useTokenContext);
        log.info("{}: {}", (Object)CONTEXT_WINDOW_SIZE, (Object)this.contextTokenWindowSize);
        log.info("{}: {}", (Object)MAPPER_CONFIG_FILE, (Object)this.mapperConfigFile);
    }

    private void getEntityMappingTypes(UimaContext aContext) throws ResourceInitializationException {
        this.entityTypeMappings = (String[])aContext.getConfigParameterValue(ENTITY_MAPPING_TYPES);
        if (this.entityTypeMappings != null) {
            this.entityMappingTypes = new HashMap();
            for (String entityTypeMapping : this.entityTypeMappings) {
                String[] entDefinition = entityTypeMapping.split("=");
                if (entDefinition.length != 2) {
                    log.error("EntityMappingTypes in wrong format: {}", (Object)entityTypeMapping);
                }
                String entName = entDefinition[0];
                Pattern entSpecificPattern = Pattern.compile(entDefinition[1]);
                this.entityMappingTypes.put(entName, entSpecificPattern.matcher(""));
            }
            if (log.isInfoEnabled()) {
                log.info("Entity types to be considered for mapping: {}", this.entityMappingTypes.keySet().stream().collect(Collectors.toMap(Function.identity(), key -> this.entityMappingTypes.get(key).pattern())));
            }
        } else {
            String msg = "No entity mapping types defined. Please check the value of the EntityMappingTypes parameter.";
            log.error(msg);
            throw new ResourceInitializationException((Throwable)new IllegalArgumentException(msg));
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        try {
            Function<EntityMention, Pair<String, BooleanQuery>> contextFun = null;
            GeneDocument geneDocument = this.documentFactory.createGeneDocument(aJCas, this.entityMappingTypes, contextFun, this.parameters);
            this.doMapping(aJCas, geneDocument);
        }
        catch (Throwable t) {
            String docId = JCoReTools.getDocId((JCas)aJCas);
            log.error("Error while trying to map genes of document {}", (Object)docId, (Object)t);
            throw t;
        }
    }

    private void doMapping(JCas aJCas, GeneDocument geneDocument) throws AnalysisEngineProcessException {
        try {
            this.mapper.map(geneDocument, this.parameters, new Stats());
        }
        catch (GeneMapperException e) {
            String msg = "Document with ID " + geneDocument.getId() + " could not be gene/protein ID-mapped.";
            log.error(msg, (Throwable)((Object)e));
            throw new AnalysisEngineProcessException((Throwable)new IllegalStateException(msg));
        }
        this.writeMappingsToCAS(aJCas, geneDocument);
    }

    private void writeMappingsToCAS(JCas aJCas, GeneDocument document) {
        if (this.removeExistingResourceEntries.booleanValue()) {
            for (GeneMention gm : document.getGenesIterable()) {
                EntityMention entity = (EntityMention)gm.getOriginalMappedObject();
                if (entity.getResourceEntryList() == null) continue;
                entity.setResourceEntryList(null);
            }
        }
        for (GeneMention gm : document.getNonRejectedGenesIterable()) {
            assert (gm.getMentionMappingResult() != null) : "A non-rejected gene does not have a mapping result: " + gm;
            assert (gm.getMentionMappingResult().tax2finalRankedCandidates != null) : "A non-rejected gene does not have the tax2finalRankedCandidates map: " + gm;
            assert (!gm.getMentionMappingResult().tax2finalRankedCandidates.isEmpty()) : "A non-rejected gene has an empty tax2finalRankedCandidates map: " + gm;
            ArrayList<GeneResourceEntry> newResourceEntries = new ArrayList<GeneResourceEntry>(gm.getMentionMappingResult().tax2finalRankedCandidates.keySet().size());
            for (String taxId : gm.getNonRejectedTaxonomyIds()) {
                SynHit hit = (SynHit)((List)gm.getMentionMappingResult().tax2finalRankedCandidates.get(taxId)).get(0);
                GeneResourceEntry resourceEntry = new GeneResourceEntry(aJCas);
                resourceEntry.setSource("NCBI Gene");
                String geneId = hit.getId();
                resourceEntry.setEntryId(geneId);
                resourceEntry.setTaxonomyId(hit.getTaxId());
                resourceEntry.setBegin(gm.getBegin());
                resourceEntry.setEnd(gm.getEnd());
                resourceEntry.setComponentId(COMPONENT_ID + " / " + this.mapper.getMappingCore().getClass().getSimpleName());
                String confidence = DECIMAL_FORMAT.format(hit.getLexicalScore()) + " / " + DECIMAL_FORMAT.format(hit.getContextualScore());
                resourceEntry.setConfidence(confidence);
                resourceEntry.setId(gm.getNormalizedText());
                resourceEntry.setSynonym(hit.getSynonym());
                newResourceEntries.add(resourceEntry);
            }
            EntityMention entity = (EntityMention)gm.getOriginalMappedObject();
            FSArray resourceEntryList = entity.getResourceEntryList();
            if (null == resourceEntryList && newResourceEntries.size() > 0) {
                resourceEntryList = new FSArray(aJCas, newResourceEntries.size());
            }
            FSArray newEntryList = JCoReTools.addToFSArray((FSArray)resourceEntryList, newResourceEntries);
            entity.setResourceEntryList(newEntryList);
        }
    }
}

