/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.uima;

import de.julielab.jcore.types.Zone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;

@ResourceMetaData(name="JCoRe EG Summary Structure Annotator", description="Takes the eg2summary file produced by the GeneXMLFromASN1Extractor and annotates the gene ID and the actual summaries with Zones.")
@TypeCapability(outputs={"de.julielab.jcore.types.Zone", "de.julielab.jcore.types.Title"})
public class EGSummaryStructureAnnotator
extends JCasAnnotator_ImplBase {
    private final Matcher idMatcher = Pattern.compile("(" + System.getProperty("line.separator") + "|^)([0-9]+)\t").matcher("");
    private final Matcher summaryMatcher = Pattern.compile("\t(.*)($|" + System.getProperty("line.separator") + ")").matcher("");

    public void process(JCas jCas) {
        int end;
        int start;
        String docText = jCas.getDocumentText();
        this.idMatcher.reset(docText);
        while (this.idMatcher.find()) {
            start = this.idMatcher.start(2);
            end = this.idMatcher.end(2);
            if (start <= -1) continue;
            new Zone(jCas, start, end).addToIndexes();
        }
        this.summaryMatcher.reset(docText);
        while (this.summaryMatcher.find()) {
            start = this.summaryMatcher.start(1);
            end = this.summaryMatcher.end(1);
            if (start <= -1) continue;
            new Zone(jCas, start, end).addToIndexes();
        }
    }
}

