/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.mappingcores.quercus;

import de.julielab.gene.candidateretrieval.BooleanQueryGenerator;
import de.julielab.gene.candidateretrieval.NameCentricRetrieval;
import de.julielab.geneexpbase.CandidateFilter;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.genemapper.mappingcores.quercus.QuercusDisambiguationStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.lucene.search.BooleanClause;

public class UnderspecifiedNameDisambiguationStep
implements QuercusDisambiguationStep {
    private final NameCentricRetrieval nameCentricRetrieval;
    private final BooleanQueryGenerator queryGenerator;

    @Inject
    public UnderspecifiedNameDisambiguationStep(NameCentricRetrieval nameCentricRetrieval) {
        this.nameCentricRetrieval = nameCentricRetrieval;
        this.queryGenerator = new BooleanQueryGenerator(BooleanClause.Occur.SHOULD, -1);
    }

    @Override
    public void disambiguate(GeneMention gm, SynHit candidate) {
        String lowestSpecifierId;
        if (CandidateFilter.hasSpecifier((String)gm.getNormalizedText())) {
            return;
        }
        Map priorityNamesMap = this.nameCentricRetrieval.getPriorityNamesMap((Collection)candidate.getIds(), -1);
        String prefix = this.getCommonPrefix(new ArrayList<String>(priorityNamesMap.values()));
        if (!prefix.isBlank() && (lowestSpecifierId = this.getIdWithLowestSpecifier(prefix, priorityNamesMap)) != null) {
            candidate.setId(lowestSpecifierId);
        }
    }

    private String getIdWithLowestSpecifier(String prefix, Map<String, String> priorityNamesMap) {
        TreeMap<String, String> suffix2id = new TreeMap<String, String>();
        for (String geneId : priorityNamesMap.keySet()) {
            String name = priorityNamesMap.get(geneId);
            String suffix = name.substring(prefix.length()).trim();
            if (suffix.split("\\s+").length > 1) {
                return null;
            }
            try {
                suffix2id.put(suffix, geneId);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return (String)suffix2id.get(suffix2id.firstKey());
    }

    private String getCommonPrefix(Collection<String> geneNames) {
        List tokenizedNames = geneNames.stream().map(name -> name.split("\\s+")).collect(Collectors.toList());
        OptionalInt shortestNameLength = tokenizedNames.stream().mapToInt(name -> ((String[])name).length).min();
        StringBuilder longestPrefix = new StringBuilder();
        if (shortestNameLength.isPresent()) {
            String currentWord = null;
            for (int prefixLength = 1; prefixLength < shortestNameLength.getAsInt(); ++prefixLength) {
                for (int i = 0; i < tokenizedNames.size(); ++i) {
                    String[] name2 = (String[])tokenizedNames.get(i);
                    if (currentWord == null) {
                        currentWord = name2[prefixLength - 1];
                        continue;
                    }
                    if (((String[])tokenizedNames.get(i))[prefixLength - 1].equals(currentWord)) continue;
                    currentWord = null;
                    break;
                }
                if (currentWord != null) {
                    if (longestPrefix.length() > 0) {
                        longestPrefix.append(" ");
                    }
                    longestPrefix.append(currentWord);
                }
                currentWord = null;
            }
        }
        return longestPrefix.toString();
    }
}

