/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.mappingcores.quercus;

import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.genemapper.mappingcores.quercus.QuercusDisambiguationStep;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TestDisambiguationStep
implements QuercusDisambiguationStep {
    @Override
    public void disambiguate(GeneMention gm, SynHit candidate) {
        for (String taxId : gm.getTaxonomyIds()) {
            Set<String> commonTokens = this.getCommonTokens(((List)gm.getMentionMappingResult().tax2finalRankedCandidates.get(taxId)).stream().map(SynHit::getSynonym).collect(Collectors.toList()));
            System.out.println("hier");
        }
    }

    public Set<String> getCommonTokens(Collection<String> geneNames) {
        Set commonTokens = null;
        for (String name : geneNames) {
            Set tokenSet = Arrays.stream(name.split("\\s+")).collect(Collectors.toSet());
            if (commonTokens == null) {
                commonTokens = tokenSet;
                continue;
            }
            commonTokens = commonTokens.stream().filter(tokenSet::contains).collect(Collectors.toSet());
        }
        return commonTokens;
    }

    private void idCountDisambiguation(GeneMention gm, SynHit candidate) {
        List possibleIds = candidate.getIds();
        HashMap<String, Integer> idCount = new HashMap<String, Integer>();
        for (String taxId : gm.getTaxonomyIds()) {
            List candidates = (List)gm.getMentionMappingResult().tax2finalRankedCandidates.get(taxId);
            for (SynHit sh : candidates) {
                for (String id : possibleIds) {
                    if (!sh.getIds().contains(id)) continue;
                    idCount.merge(id, 1, Integer::sum);
                }
            }
        }
        String bestId = null;
        int bestCount = 0;
        for (String id : idCount.keySet()) {
            if ((Integer)idCount.get(id) <= bestCount) continue;
            bestCount = (Integer)idCount.get(id);
            bestId = id;
        }
        candidate.setId(bestId);
    }
}

