/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.mappingcores.quercus;

import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.gene.candidateretrieval.GeneRecordQueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.genemapper.mappingcores.quercus.QuercusDisambiguationStep;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneRecordQueryDisambiguationStep
implements QuercusDisambiguationStep {
    private static final Logger log = LoggerFactory.getLogger(GeneRecordQueryDisambiguationStep.class);
    private final CandidateRetrieval geneRecordCandidateRetrieval;
    private final GeneRecordQueryGenerator queryGenerator;

    @Inject
    public GeneRecordQueryDisambiguationStep(CandidateRetrieval geneRecordCandidateRetrieval) {
        this.geneRecordCandidateRetrieval = geneRecordCandidateRetrieval;
        this.queryGenerator = new GeneRecordQueryGenerator(true, false, true, true, true, true, true, Integer.MAX_VALUE);
    }

    @Override
    public void disambiguate(GeneMention gm, SynHit candidate) {
        List geneRecordCandidates = this.geneRecordCandidateRetrieval.getCandidates(gm, (Collection)candidate.getIds(), (Collection)gm.getTaxonomyIds(), (QueryGenerator)this.queryGenerator);
        assert (!geneRecordCandidates.isEmpty()) : "The gene record result for a disambiguation query was empty. This points to a discrepancy between the name centered index and the record index. The gene mention was " + gm + " and the requested IDs for disambiguation were " + candidate.getIds();
        if (geneRecordCandidates.isEmpty()) {
            log.error("Gene mention {} has name-centric candidate {} with IDs {}. The error is that no gene record candidates for those IDs were found.", new Object[]{gm, candidate, candidate.getIds()});
        }
        SynHit bestRecordCandidate = (SynHit)geneRecordCandidates.get(0);
        candidate.setId(bestRecordCandidate.getId());
    }
}

