/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.mappingcores;

import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.geneexpbase.CandidateFilter;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.DocumentMappingResult;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import de.julielab.genemapper.composites.GeneCompositeNameResolver;
import de.julielab.genemapper.disambig.ContextRanker;
import de.julielab.genemapper.evaluation.tools.Stats;
import de.julielab.genemapper.mappingcores.MappingCore;
import de.julielab.genemapper.mappingcores.QuercusCandidateSetter;
import de.julielab.genemapper.mappingcores.QuercusDisambiguation;
import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.java.utilities.IOStreamUtilities;
import de.julielab.speciesassignment.GeneSpeciesAssigner;
import de.julielab.speciesassignment.SpeciesAssignmentException;
import de.julielab.speciesassignment.services.SpeciesHintSetter;
import de.julielab.speciesassignment.spi.SpeciesAssignmentFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuercusMappingCore
implements MappingCore {
    private static final Logger log = LoggerFactory.getLogger(QuercusMappingCore.class);
    private final QuercusDisambiguation disambiguation;
    private final GeneCompositeNameResolver geneCompositeNameResolver;
    private final QuercusCandidateSetter candidateSetter;
    private final Set<String> familyNames;
    private final GeneSpeciesAssigner speciesAssigner;
    private final SpeciesAssignmentFilter speciesAssignmentFilter;

    @Inject
    public QuercusMappingCore(GeneCompositeNameResolver geneCompositeNameResolver, QuercusCandidateSetter candidateSetter, QuercusDisambiguation disambiguation, GeneSpeciesAssigner speciesAssigner, SpeciesAssignmentFilter speciesAssignmentFilter) throws IOException {
        this.geneCompositeNameResolver = geneCompositeNameResolver;
        this.candidateSetter = candidateSetter;
        this.disambiguation = disambiguation;
        this.speciesAssigner = speciesAssigner;
        this.speciesAssignmentFilter = speciesAssignmentFilter;
        TermNormalizer normalizer = new TermNormalizer();
        this.familyNames = IOStreamUtilities.getLinesFromInputStream((InputStream)FileUtilities.findResource((String)"familyrecords.dict.gz")).stream().map((? super T line) -> line.split("\t")[0]).map(arg_0 -> ((TermNormalizer)normalizer).normalize(arg_0)).flatMap(famname -> Stream.of(famname, famname.replaceAll("\\s+(family)|(families)", "").strip())).collect(Collectors.toSet());
    }

    @Override
    public MentionMappingResult map(GeneMention geneMention) throws GeneMapperException {
        return null;
    }

    @Override
    public ContextRanker getContextualRanking() {
        return null;
    }

    @Override
    public CandidateRetrieval getCandidateRetrieval() {
        return null;
    }

    @Override
    public TermNormalizer getTermNormalizer() {
        return null;
    }

    @Override
    public DocumentMappingResult map(GeneDocument document) throws GeneMapperException {
        throw new GeneMapperException("This method is not implemented. Use map(GeneDocument, Parameters) instead.");
    }

    @Override
    public DocumentMappingResult map(GeneDocument document, Parameters parameterMap, Stats stats) throws GeneMapperException {
        try {
            document.clearSelectedGenes();
            document.selectGeneMentionsByTagger(new GeneMention.GeneTagger[]{GeneMention.GeneTagger.FLAIR, GeneMention.GeneTagger.FLAIR_JPG_NOBC2TEST_NOTEST_COLLAPSED_VAR, GeneMention.GeneTagger.CONSISTENCY_TAGGER, GeneMention.GeneTagger.EXPANSION_TAGGER});
            this.assignSpecies(document, parameterMap);
            this.handleCompositeMentions(document, stats);
            this.candidateSetter.setCandidates(document);
            this.filterFalsePositives(document);
            this.filterApproximateMatches(document);
            this.disambiguation.disambiguate(document);
            this.candidateSetter.setCandidatesToGoldMentions(document);
            DocumentMappingResult documentMappingResult = new DocumentMappingResult(document.getId());
            documentMappingResult.mentionResults = document.getNonRejectedGenes().map((? super T g) -> g.getMentionMappingResult()).collect(Collectors.toList());
            return documentMappingResult;
        }
        catch (SpeciesAssignmentException e) {
            throw new GeneMapperException(e);
        }
    }

    private void assignSpecies(GeneDocument document, Parameters parameterMap) throws SpeciesAssignmentException {
        String fixedTaxId = parameterMap.getString("fixed_tax_id", null);
        if (fixedTaxId == null || fixedTaxId.isBlank()) {
            SpeciesHintSetter.setSpeciesMeshHeadings((GeneDocument)document);
            this.speciesAssignmentFilter.filterAssignments(document);
            this.speciesAssigner.setSpeciesHints(parameterMap, document);
            this.speciesAssigner.assign(document, parameterMap);
        } else {
            for (GeneMention gm : document.getNonRejectedGenesIterable()) {
                gm.setTaxonomyId(fixedTaxId);
                if (!"gold".equals(fixedTaxId) || !gm.hasGoldMentions()) continue;
                gm.setTaxonomyIds(gm.getAllGoldTaxonomyIds().distinct().collect(Collectors.toList()));
            }
        }
    }

    private void filterApproximateMatches(GeneDocument document) {
        for (GeneMention gm : document.getNonRejectedGenesIterable()) {
            for (String taxId : gm.getTaxonomyIds()) {
                if (gm.hasExactMatchInTax(taxId)) continue;
                gm.reject(taxId, MentionMappingResult.RejectReason.NO_CANDIDATES);
            }
        }
    }

    private void filterCandidates(GeneDocument document) {
        CandidateFilter cf = new CandidateFilter();
        for (GeneMention gm : document.getNonRejectedGenesIterable()) {
            for (String taxId : gm.getNonRejectedTaxonomyIds()) {
                List synHits = (List)gm.getMentionMappingResult().tax2lexicallyRerankedCandidates.get(taxId);
                Iterator synIt = synHits.iterator();
                while (synIt.hasNext()) {
                    SynHit sh = (SynHit)synIt.next();
                    if (!cf.filterOut(gm.getNormalizedText(), sh.getSynonym())) continue;
                    synIt.remove();
                }
                if (!synHits.isEmpty()) continue;
                gm.reject(taxId, MentionMappingResult.RejectReason.NO_CANDIDATES);
            }
        }
    }

    private void applyFilterRules(GeneDocument document) {
        for (GeneMention gm : document.getNonRejectedGenesIterable()) {
            String reducedGeneName = gm.getNormalizedText();
            reducedGeneName = TermNormalizer.removeDomainFamilies((String)reducedGeneName);
            reducedGeneName = TermNormalizer.removePremodifiers((String)reducedGeneName);
            reducedGeneName = TermNormalizer.removeModifiers((String)reducedGeneName);
            reducedGeneName = TermNormalizer.removeNondescriptives((String)reducedGeneName);
            if (!(reducedGeneName = TermNormalizer.removeUnspecifieds((String)reducedGeneName)).isBlank()) continue;
            gm.reject(MentionMappingResult.RejectReason.IS_UNSPECIFIC);
        }
    }

    private void filterFalsePositives(GeneDocument document) {
        for (GeneMention gm : document.getNonRejectedGenesIterable()) {
            if (gm.getSpecificType() != GeneMention.SpecificType.GENE && (gm.getNormalizedText().split("\\s").length == 1 || this.familyNames.contains(gm.getNormalizedText()))) {
                gm.reject(MentionMappingResult.RejectReason.IS_FAMILY);
            }
            if (!this.familyNames.contains(gm.getNormalizedText())) continue;
            gm.reject(MentionMappingResult.RejectReason.IS_FAMILY);
        }
    }

    private void handleCompositeMentions(GeneDocument document, Stats stats) throws GeneMapperException {
        ArrayList<GeneMention> obsoleteMentions = new ArrayList<GeneMention>();
        ArrayList<GeneMention> newMentions = new ArrayList<GeneMention>();
        for (GeneMention predGm : document.getNonRejectedGenesIterable()) {
            List<GeneMention> identifiedGms;
            NavigableSet allGeneMentions = document.getAllGeneMentions(predGm, GeneMention.GeneTagger.GAZETTEER);
            if (!allGeneMentions.isEmpty()) continue;
            try {
                identifiedGms = this.geneCompositeNameResolver.resolve(predGm, new boolean[0]);
            }
            catch (Exception e) {
                log.debug("Error when trying to resolve composites in mention {}. Skipping.", (Object)predGm);
                identifiedGms = List.of(predGm);
            }
            if (identifiedGms.size() <= 1 && identifiedGms.get(0).equals((Object)predGm)) continue;
            log.debug("Adding {} composite-resolved gene names to document {}. Original gene name was '{}'.", new Object[]{identifiedGms.size(), document.getId(), predGm.getText()});
            if (obsoleteMentions != null) {
                obsoleteMentions.add(predGm);
            }
            if (newMentions == null) continue;
            newMentions.addAll(identifiedGms);
        }
        obsoleteMentions.forEach(arg_0 -> ((GeneDocument)document).removeGene(arg_0));
        newMentions.forEach(arg_0 -> ((GeneDocument)document).selectGene(arg_0));
    }

    @Override
    public void shutdown() throws GeneMapperException {
    }

    @Override
    public void clear() {
    }
}

