/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.mappingcores;

import com.google.common.collect.Sets;
import de.julielab.gene.candidateretrieval.BooleanQueryGenerator;
import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.gene.candidateretrieval.GeneRecordQueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.genemapper.mappingcores.quercus.AnchorDisambiguationStep;
import de.julielab.genemapper.mappingcores.quercus.BioThesaurusFilterDisambiguationStep;
import de.julielab.genemapper.mappingcores.quercus.GeneRecordQueryDisambiguationStep;
import de.julielab.genemapper.mappingcores.quercus.OfficialSymbolPromotionDisambiguationStep;
import de.julielab.genemapper.mappingcores.quercus.QuercusDisambiguationStep;
import de.julielab.genemapper.mappingcores.quercus.SemanticIndexDisambiguationStep;
import de.julielab.genemapper.mappingcores.quercus.TestDisambiguationStep;
import de.julielab.genemapper.mappingcores.quercus.UnderspecifiedNameDisambiguationStep;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.lucene.search.BooleanClause;

public class QuercusDisambiguation {
    private final BooleanQueryGenerator nameCentricQueryGenerator;
    private final CandidateRetrieval geneRecordCandidateRetrieval;
    private final QueryGenerator queryGenerator;
    private final List<QuercusDisambiguationStep> disambiguationSteps;

    @Inject
    public QuercusDisambiguation(CandidateRetrieval geneRecordCandidateRetrieval, OfficialSymbolPromotionDisambiguationStep officialSymbolStep, BioThesaurusFilterDisambiguationStep bioThesaurusStep, TestDisambiguationStep testDisambiguationStep, UnderspecifiedNameDisambiguationStep underspecifiedNameDisambiguationStep, GeneRecordQueryDisambiguationStep geneRecordStep, SemanticIndexDisambiguationStep semanticIndexDisambiguationStep, AnchorDisambiguationStep anchorDisambiguationStep) {
        this.geneRecordCandidateRetrieval = geneRecordCandidateRetrieval;
        this.queryGenerator = new GeneRecordQueryGenerator(true, false, true, true, true, true, true, Integer.MAX_VALUE);
        this.nameCentricQueryGenerator = new BooleanQueryGenerator(BooleanClause.Occur.SHOULD, -1);
        this.disambiguationSteps = List.of(officialSymbolStep, bioThesaurusStep, semanticIndexDisambiguationStep, geneRecordStep);
    }

    public void disambiguate(GeneDocument document) {
        for (GeneMention gm : document.getNonRejectedGenesIterable()) {
            assert (gm.getMentionMappingResult() != null) : "The gene mention has no mention mapping result: " + gm;
            assert (gm.getMentionMappingResult().tax2lexicallyRerankedCandidates != null) : "The mention mapping result of a gene does not have lexically (re-)ranked candidates";
            for (String taxId : gm.getNonRejectedTaxonomyIds()) {
                List candidates = (List)gm.getMentionMappingResult().tax2lexicallyRerankedCandidates.get(taxId);
                assert (candidates != null) : "The lexically (re-)ranked candidates for taxId " + taxId + " are null for gene mention " + gm;
                assert (!candidates.isEmpty()) : "The list of lexically (re-)ranked candidates for taxId " + taxId + " is empty for gene mention " + gm;
                SynHit bestHit = (SynHit)candidates.get(0);
                assert (bestHit.isRejectionCandidate() || bestHit.getTaxIds() != null) : "The top candidate for a gene mention does not have its taxonomy IDs set " + gm;
                assert (!bestHit.getTaxIds().isEmpty()) : "The top candidate for a gene mention has an empty taxonomy ID list " + gm;
                this.matchIdsOfOtherGenes(gm, taxId, bestHit);
                for (int i = 0; i < this.disambiguationSteps.size() && !bestHit.isDisambiguated(); ++i) {
                    this.disambiguationSteps.get(i).disambiguate(gm, bestHit);
                }
                assert (bestHit.getId() != null) : "There are SynHits without an ID after disambiguation for GeneMention " + gm + ": " + candidates.stream().filter(sh -> sh.getId() == null).collect(Collectors.toList());
            }
        }
    }

    private void matchIdsOfOtherGenes(GeneMention gm, String taxId, SynHit bestHit) {
        for (GeneMention otherGm : gm.getGeneDocument().getNonRejectedGenesIterable()) {
            Sets.SetView intersection;
            SynHit otherSh;
            Map tax2lexicallyRerankedCandidates;
            if (gm == otherGm || !(tax2lexicallyRerankedCandidates = otherGm.getMentionMappingResult().tax2lexicallyRerankedCandidates).containsKey(taxId) || (otherSh = (SynHit)((List)tax2lexicallyRerankedCandidates.get(taxId)).iterator().next()).isRejectionCandidate() || (intersection = Sets.intersection((Set)bestHit.getIdsSet(), (Set)otherSh.getIdsSet())).size() != 1 || !otherSh.isDisambiguated()) continue;
            bestHit.setId((String)intersection.stream().iterator().next());
            break;
        }
    }
}

