/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.index;

import de.julielab.geneexpbase.CandidateFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ContextGenerator {
    private final Map<String, StringBuilder> id2go = new HashMap<String, StringBuilder>();
    private final HashMap<String, String> go2syns = new HashMap();
    private final Map<String, StringBuilder> id2summary = new HashMap<String, StringBuilder>();
    private final Map<String, StringBuilder> id2designations = new HashMap<String, StringBuilder>();
    private final Map<String, StringBuilder> id2upContext = new HashMap<String, StringBuilder>();
    private final Map<String, StringBuilder> id2intact = new HashMap<String, StringBuilder>();
    private final Map<String, StringBuilder> id2generif = new HashMap<String, StringBuilder>();
    private final Map<String, StringBuilder> id2disease = new HashMap<String, StringBuilder>();
    private final Map<String, StringBuilder> id2function = new HashMap<String, StringBuilder>();
    private final Map<String, StringBuilder> id2induction = new HashMap<String, StringBuilder>();

    public ContextGenerator(String resourcesDir, String db) throws FileNotFoundException, IOException {
        File id2generifFile;
        File id2EgDesignationFile;
        File id2InteractFile;
        File id2UniprotContextFile;
        File go2SynFile;
        File id2GoFile;
        String idType = "";
        if (db.equals("gene")) {
            idType = "eg";
        } else if (db.equals("protein")) {
            idType = "up";
        }
        File id2SummaryFile = new File(resourcesDir + idType + "2summary");
        if (!id2SummaryFile.isFile()) {
            System.err.println("Could not find file " + id2SummaryFile.getAbsolutePath());
            System.exit(-1);
        }
        if (!(id2GoFile = new File(resourcesDir + idType + "2go")).isFile()) {
            System.err.println("Could not find id2GoFile (" + idType + "2go)");
            System.exit(-1);
        }
        if (!(go2SynFile = new File(resourcesDir + "go_all")).isFile()) {
            System.err.println("Could not find go2SynFile (go_all)");
            System.exit(-1);
        }
        if (!(id2UniprotContextFile = new File(resourcesDir + idType + "2freetext_chromo.context")).isFile()) {
            System.err.println("Could not find id2uniprotContextFile (" + idType + "2freetext_chromo.context)");
            System.exit(-1);
        }
        if (!(id2InteractFile = new File(resourcesDir + idType + "2interaction")).isFile()) {
            System.err.println("Could not find id2InteractFile (" + idType + "2interaction)");
            System.exit(-1);
        }
        if (!(id2EgDesignationFile = new File(resourcesDir + idType + "2designation")).isFile()) {
            System.err.println("Could not find id2DesignationFile (" + idType + "2designation)");
            System.exit(-1);
        }
        if (!(id2generifFile = new File(resourcesDir + idType + "2generif")).isFile()) {
            System.err.println("Could not find id2generifFile (" + idType + "2generif)");
            System.exit(-1);
        }
        this.readSimpleId2ContextFile(id2SummaryFile, this.id2summary);
        this.readId2GoFile(id2GoFile);
        this.readGo2SynFile(go2SynFile);
        this.readSimpleId2ContextFile(id2UniprotContextFile, this.id2upContext);
        this.readSimpleId2ContextFile(id2InteractFile, this.id2intact);
        this.readId2EgDesignationFile(id2EgDesignationFile);
        this.readSimpleId2ContextFile(id2generifFile, this.id2generif);
    }

    public String getContext(String id) {
        ArrayList<StringBuilder> context = new ArrayList<StringBuilder>();
        if (this.id2upContext.get(id) != null) {
            context.add(this.id2upContext.get(id));
        }
        if (this.id2designations.get(id) != null) {
            context.add(this.id2designations.get(id));
        }
        if (this.id2summary.get(id) != null) {
            context.add(this.id2summary.get(id));
        }
        if (this.id2intact.get(id) != null) {
            context.add(this.id2intact.get(id));
        }
        if (this.id2generif.get(id) != null) {
            context.add(this.id2generif.get(id));
        }
        if (this.id2disease.get(id) != null) {
            context.add(this.id2disease.get(id));
        }
        if (this.id2function.get(id) != null) {
            context.add(this.id2function.get(id));
        }
        if (this.id2induction.get(id) != null) {
            context.add(this.id2induction.get(id));
        }
        if (this.id2go.get(id) != null) {
            String goCodes = this.id2go.get(id).toString();
            String[] codes = goCodes.split("\\|");
            for (int i = 0; i < codes.length; ++i) {
                String code = codes[i];
                if (this.go2syns.get(code) == null) continue;
                String syn = this.go2syns.get(code);
                syn = syn.replaceAll("\\|", " ");
                context.add(new StringBuilder(syn));
            }
        }
        return context.stream().map(StringBuilder::toString).collect(Collectors.joining(" "));
    }

    private void readId2GoFile(File goFile) throws IOException {
        String line;
        BufferedReader goReader = new BufferedReader(new FileReader(goFile));
        while ((line = goReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] values = line.split("\t");
            if (values.length != 2) {
                System.err.println("ERR: goFile not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String id = values[0];
            String go = values[1].trim();
            this.id2go.compute(id, (k, v) -> v == null ? new StringBuilder(go) : v.append("|").append(go));
        }
        goReader.close();
        System.out.println("Done processing id2go file.");
    }

    private void readGo2SynFile(File goFile) throws IOException {
        BufferedReader goReader = new BufferedReader(new FileReader(goFile));
        String line = "";
        while ((line = goReader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] values = line.split("\t");
            if (values.length != 2) {
                System.err.println("ERR: go2syns not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String go = values[0];
            String syns = values[1].trim();
            this.go2syns.put(go, syns);
        }
        goReader.close();
        System.out.println("Done processing go2syns file.");
    }

    private void readId2EgDesignationFile(File id2DesignFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(id2DesignFile));
        String line = "";
        CandidateFilter cf = new CandidateFilter();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] values = line.split("\t");
            if (values.length != 2) {
                System.err.println("ERR: id2designate not in expected format. \ncritical line: " + line);
                System.exit(-1);
            }
            String id = values[0].intern();
            Pattern p = CandidateFilter.patternDomainFamilies;
            String designation = values[1].trim();
            Matcher m = p.matcher(designation);
            if (m.matches() || (m = (p = CandidateFilter.patternUnspecifieds).matcher(designation)).matches()) continue;
            this.id2designations.compute(id, (k, v) -> v == null ? new StringBuilder(designation) : v.append(" ").append(designation));
        }
        reader.close();
        System.out.println("Done processing id2designations file.");
    }

    private void readSimpleId2ContextFile(File contextFile, Map<String, StringBuilder> contextMap) throws IOException {
        try (BufferedReader contextFileReader = new BufferedReader(new FileReader(contextFile));){
            String line = "";
            while ((line = contextFileReader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] values = line.split("\t");
                if (values.length != 2) {
                    System.err.println("ERR: " + contextFile.getAbsolutePath() + " not in expected format. \ncritical line: " + line);
                    System.exit(-1);
                }
                String id = values[0].intern();
                String context = values[1].trim();
                contextMap.compute(id, (k, v) -> v == null ? new StringBuilder(context) : v.append(" ").append(context));
            }
        }
        System.out.println("Done processing " + contextFile.getName() + " file.");
    }
}

