/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.hpo;

import de.julielab.geneexpbase.hpo.HttpParamOptClient;
import de.julielab.genemapper.hpo.GnHpoServer;
import de.julielab.smac.FullyEvaluatedConfiguration;
import de.julielab.smac.SmacLiveRundataCollection;
import de.julielab.smac.SmacLiveRundataCollectionReader;
import java.io.File;
import java.util.List;
import java.util.Map;

public class PrintBestSmacConfiguration {
    public static void main(String[] args) throws Exception {
        int port = 32100;
        GnHpoServer.main(new String[]{String.valueOf(port)});
        SmacLiveRundataCollectionReader collectionReader = new SmacLiveRundataCollectionReader();
        String smacDataPath = "smac-output/candidate_filter_gnpbc2nlmiat";
        SmacLiveRundataCollection collection = collectionReader.read(new File(smacDataPath));
        List bestConfigurations = collection.getBestFullyEvaluatedConfigurations(5);
        if (bestConfigurations.isEmpty()) {
            System.err.println("No evaluated configurations found.");
        }
        for (FullyEvaluatedConfiguration c : bestConfigurations) {
            System.out.println(c.getPcid() + ": " + c.getAvgQuality());
            Map settings = c.getConfiguration().getSettings();
            for (String k : settings.keySet()) {
                System.out.println(k + " = " + (String)settings.get(k));
            }
            Map settingsAsConfigurationMap = c.getConfiguration().getSettingsAsConfigurationMap();
            String instance = "candidateranking-merged-testsplit-0";
            String score = HttpParamOptClient.requestScoreFromServer((Map)settingsAsConfigurationMap, (String)instance, (String)"", (String)"get_mention_score_search", (int)port);
            System.out.println("Instance score for \"" + instance + "\": " + score);
            System.out.println();
        }
        System.exit(0);
    }
}

