/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;

public class UnspecifiedPipe
extends Pipe {
    private final String featureName;

    public UnspecifiedPipe(String prefix) {
        this.featureName = prefix;
    }

    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneSet geneSet = (GeneSet)t.getProperty("gs");
        for (GeneMention gm : geneSet) {
            String normalizedText = gm.getNormalizedText();
            String filteredText = TermNormalizer.removeNondescriptives((String)normalizedText);
            filteredText = TermNormalizer.removeDomainFamilies((String)normalizedText);
            if ((filteredText = TermNormalizer.removeUnspecifieds((String)filteredText)).equals("") || filteredText.equals("s")) {
                t.setFeatureValue(this.featureName, 1.0);
                continue;
            }
            String rightExtendedText = gm.getRightExtendedText().toLowerCase();
            if (!rightExtendedText.contains("type") || !rightExtendedText.contains("channel")) continue;
            t.setFeatureValue(this.featureName, 1.0);
        }
        return inst;
    }
}

