/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import com.google.common.collect.HashMultiset;
import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.GeneSets;
import de.julielab.genemapper.filtering.families.InstanceListCreator;
import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.genemapper.utils.GeneMapperRuntimeException;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.java.utilities.IOStreamUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RuleBasedFamilyAssigner {
    private final CandidateRetrieval candidateRetrieval;
    private final List<String> moleculegroups;
    private final InstanceListCreator instanceListCreator;

    public RuleBasedFamilyAssigner(CandidateRetrieval candidateRetrieval) {
        this.candidateRetrieval = candidateRetrieval;
        try {
            this.moleculegroups = IOStreamUtilities.getReaderFromInputStream((InputStream)FileUtilities.findResource((String)"/moleculeGroups.txt")).lines().collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new GeneMapperRuntimeException(e);
        }
        this.instanceListCreator = new InstanceListCreator();
    }

    public void doit(Collection<GeneDocument> docs) throws GeneMapperException {
        for (GeneDocument doc : docs) {
            this.doit(doc);
        }
    }

    private void doConsistency(GeneDocument doc) {
        doc.agglomerateByAcronyms();
        doc.agglomerateByNames(false);
        for (GeneSet gs : doc.getGeneSets()) {
            HashMultiset gsTypes = HashMultiset.create();
            GeneMention.SpecificType longformType = null;
            for (GeneMention gm2 : gs) {
                gsTypes.add((Object)gm2.getSpecificType());
                if (!gm2.isAbbreviationLongForm()) continue;
                longformType = gm2.getSpecificType();
            }
            if (gsTypes.elementSet().size() <= 1) continue;
            GeneMention.SpecificType newType = longformType;
            gs.forEach(gm -> gm.setSpecificType(newType));
            gs.forEach(gm -> gm.freezeSpecificType());
        }
    }

    public void doit(GeneDocument document) throws GeneMapperException {
        GeneSets geneSets = document.getGeneSets();
        if (!geneSets.isEmpty() && ((GeneSet)geneSets.iterator().next()).getFeatureVector() == null) {
            this.instanceListCreator.createInstanceList(Stream.of(document), null);
        }
        for (GeneSet gs : geneSets) {
            FeatureVector fv = gs.getFeatureVector();
            block1: for (GeneMention gm : gs) {
                int index;
                String priorities;
                if (!gm.hasGoldMentions()) continue;
                boolean classified = false;
                Alphabet alphabet = fv.getAlphabet();
                SynHit bestMatch = gm.getMentionMappingResult() != null && gm.getMentionMappingResult().tax2bestCandidates != null && !gm.getMentionMappingResult().tax2bestCandidates.values().stream().flatMap(Collection::stream).findAny().isEmpty() ? (SynHit)gm.getMentionMappingResult().tax2bestCandidates.values().stream().flatMap(Collection::stream).findFirst().get() : null;
                String string = priorities = bestMatch != null && bestMatch.getTaxonomySpecificIds() != null ? bestMatch.getPrioritiesOfIds(bestMatch.getTaxonomySpecificIds()).stream().map(String::valueOf).collect(Collectors.joining(",")) : null;
                if (!classified && gm.getSpecificType() == GeneMention.SpecificType.FAMILYNAME && gm.getSpecificTypeConfidence() < 0.7) {
                    gm.setSpecificType(GeneMention.SpecificType.GENE);
                }
                if (fv.value(index = alphabet.lookupIndex((Object)"IS_FAMILY")) > 0.0) {
                    gm.setSpecificType(GeneMention.SpecificType.FAMILYNAME);
                    classified = true;
                }
                index = alphabet.lookupIndex((Object)"HAS_MOTIF");
                if (!classified && fv.value(index) > 0.0) {
                    gm.setSpecificType(GeneMention.SpecificType.FAMILYNAME);
                    classified = true;
                }
                index = alphabet.lookupIndex((Object)"NUM_SUFFIX");
                if (!classified && fv.value(index) > 0.0) {
                    gm.setSpecificType(GeneMention.SpecificType.FAMILYNAME);
                    classified = true;
                }
                index = alphabet.lookupIndex((Object)"UNSPEC_DET");
                if (!classified && fv.value(index) > 0.0) {
                    gm.setSpecificType(GeneMention.SpecificType.FAMILYNAME);
                    classified = true;
                }
                index = alphabet.lookupIndex((Object)"UNSPEC_KINASE");
                if (!classified && fv.value(index) > 0.0) {
                    gm.setSpecificType(GeneMention.SpecificType.FAMILYNAME);
                    classified = true;
                }
                index = alphabet.lookupIndex((Object)"IS-member");
                if (!classified && fv.value(index) > 0.0) {
                    gm.setSpecificType(GeneMention.SpecificType.GENE);
                    classified = true;
                }
                index = alphabet.lookupIndex((Object)"RELATED");
                if (!classified && fv.value(index) > 0.0) {
                    gm.setSpecificType(GeneMention.SpecificType.FAMILYNAME);
                    classified = true;
                }
                index = alphabet.lookupIndex((Object)"IS_CONTAINING");
                if (!classified && fv.value(index) > 0.0) {
                    gm.setSpecificType(GeneMention.SpecificType.FAMILYNAME);
                    classified = true;
                }
                for (String groupName : this.moleculegroups) {
                    index = alphabet.lookupIndex((Object)("IS-" + groupName));
                    if (classified || !(fv.value(index) > 0.0)) continue;
                    gm.setSpecificType(GeneMention.SpecificType.FAMILYNAME);
                    classified = true;
                    continue block1;
                }
            }
        }
    }
}

