/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.java.utilities.spanutils.OffsetMap;
import de.julielab.java.utilities.spanutils.Span;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Range;

public class IsAPipe
extends Pipe {
    private final String prefix;

    public IsAPipe(String prefix) {
        this.prefix = prefix;
    }

    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneSet geneSet = (GeneSet)t.getProperty("gs");
        GeneDocument geneDocument = (GeneDocument)inst.getSource();
        for (GeneMention gm : geneSet) {
            Map.Entry floorEntry;
            String chunkText;
            Range sentence = geneDocument.getOverlappingSentence((Span)gm);
            String coveredText = geneDocument.getCoveredText(gm.getBegin(), Math.min(gm.getBegin() + 100, (Integer)sentence.getMaximum()));
            Map.Entry np = null;
            Map.Entry vp = null;
            Map.Entry pp = null;
            Map.Entry ppnp = null;
            OffsetMap chunks = geneDocument.getChunks();
            Range geneChunk = (Range)chunks.floorKey((Object)gm.getOffsets());
            if (geneChunk != null && (chunkText = geneDocument.getCoveredText(geneChunk)).startsWith("a ")) {
                Map.Entry previousGene = geneDocument.getGeneMap().lowerEntry((Object)gm.getOffsets());
                Range previousGenePosition = null;
                if (previousGene != null) {
                    previousGenePosition = (Range)previousGene.getKey();
                }
            }
            if (!coveredText.contains("is a ") && !coveredText.contains("is an ")) continue;
            Range floorKey = (Range)chunks.floorKey((Object)gm.getOffsets());
            while ((Integer)floorKey.getMaximum() <= (Integer)sentence.getMaximum() && (floorEntry = chunks.higherEntry((Object)floorKey)) != null) {
                floorKey = (Range)floorEntry.getKey();
                if (((String)chunks.get((Object)floorKey)).contains("VP") && geneDocument.getCoveredText(floorKey).equals("is")) {
                    vp = floorEntry;
                }
                if (vp != null && np == null && ((String)chunks.get((Object)floorKey)).contains("NP")) {
                    np = floorEntry;
                }
                if (vp != null && np != null && ((String)chunks.get((Object)floorKey)).contains("PP")) {
                    pp = floorEntry;
                }
                if (pp == null || !((String)chunks.get((Object)floorKey)).contains("NP")) continue;
                ppnp = floorEntry;
                break;
            }
            if (np != null) {
                Optional npTag = geneDocument.getOverlappingPosTags((Range)np.getKey()).stream().reduce((p1, p2) -> p2);
                Range offsets = npTag.isPresent() ? ((PosTag)npTag.get()).getOffsets() : (Range)np.getKey();
                String npWord = geneDocument.getCoveredText(offsets);
                t.setFeatureValue("IS-" + npWord.toLowerCase(), 1.0);
            }
            if (pp != null) {
                String ppWord = geneDocument.getCoveredText((Range)pp.getKey());
                t.setFeatureValue("IS-PREP=" + ppWord, 1.0);
            }
            if (ppnp == null) continue;
            Optional ppnpTag = geneDocument.getOverlappingPosTags((Range)ppnp.getKey()).stream().reduce((p1, p2) -> p2);
            Range ppnpOffsets = ppnpTag.isPresent() ? ((PosTag)ppnpTag.get()).getOffsets() : (Range)ppnp.getKey();
            String ppnpWord = geneDocument.getCoveredText(ppnpOffsets);
            t.setFeatureValue("IS-PP-NP=" + ppnpWord, 1.0);
        }
        return inst;
    }
}

