/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Labeling;
import cc.mallet.types.Token;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneSet2Token
extends Pipe {
    private static final Logger log = LoggerFactory.getLogger(GeneSet2Token.class);
    private static final long serialVersionUID = 5719493241780864829L;

    public GeneSet2Token() {
        this.setTargetAlphabet((Alphabet)new LabelAlphabet());
    }

    public Instance pipe(Instance inst) {
        GeneSet gs = (GeneSet)inst.getData();
        Token t = new Token(((GeneMention)gs.stream().findAny().get()).getText());
        t.setProperty("gs", (Object)gs);
        inst.setData((Object)t);
        LabelAlphabet la = (LabelAlphabet)this.getTargetAlphabet();
        HashMultiset typeSet = HashMultiset.create();
        gs.stream().filter(GeneMention::hasGoldMentions).forEach(arg_0 -> GeneSet2Token.lambda$pipe$1((Multiset)typeSet, arg_0));
        if (log.isWarnEnabled() && typeSet.elementSet().size() > 1) {
            log.warn("GeneSet \"{}\" of document {} has multiple mentions out of families, genes and false positive mentions. Mention in the set: {}", new Object[]{gs.getRepresentationText(), ((GeneDocument)inst.getSource()).getId(), gs.stream().map(GeneMention::getText).collect(Collectors.joining(", "))});
        }
        GeneMention.SpecificType majorityType = GeneMention.SpecificType.GENE;
        int max = -1;
        for (GeneMention.SpecificType type : typeSet.elementSet()) {
            int typeCount = typeSet.count((Object)type);
            if (max < 0) {
                max = typeCount;
                majorityType = type;
                continue;
            }
            if (typeCount <= max) continue;
            max = typeCount;
            majorityType = type;
        }
        Label label = la.lookupLabel((Object)"NOTHING");
        if (majorityType == GeneMention.SpecificType.GENE) {
            label = la.lookupLabel((Object)"GENE");
        } else if (majorityType == GeneMention.SpecificType.FAMILYNAME) {
            label = la.lookupLabel((Object)"FAMILY");
        } else if (majorityType == GeneMention.SpecificType.NO_GENE) {
            label = la.lookupLabel((Object)"NO_GENE");
        }
        inst.setLabeling((Labeling)label);
        return inst;
    }

    private static /* synthetic */ void lambda$pipe$1(Multiset typeSet, GeneMention gm) {
        gm.getOverlappingGoldMentions().forEach(gold -> typeSet.add((Object)gold.getSpecificType()));
    }
}

