/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import java.util.function.Function;
import java.util.stream.DoubleStream;

public class FamilyGenegroupProbabilityPipe
extends Pipe {
    private final Function<GeneMention, Double> familyProbFunction = gm -> gm.getSpecificType() == GeneMention.SpecificType.FAMILYNAME ? gm.getSpecificTypeConfidence() : 1.0 - gm.getSpecificTypeConfidence();

    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneMention geneMention = (GeneMention)inst.getProperty("gm");
        t.setFeatureValue("FAMILYPROB=", this.familyProbFunction.apply(geneMention).doubleValue());
        GeneSet geneSet = (GeneSet)inst.getProperty("gs");
        DoubleStream.Builder avgFamilyScoreBuilder = DoubleStream.builder();
        for (GeneMention gm : geneSet) {
            avgFamilyScoreBuilder.accept(this.familyProbFunction.apply(gm));
        }
        avgFamilyScoreBuilder.build().average().ifPresent(avg -> t.setFeatureValue("FAMILYGSPROB=", avg));
        return inst;
    }
}

