/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering.families;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;

public class FamilyConfidencePipe
extends Pipe {
    private static final long serialVersionUID = -9008919110526729880L;

    public Instance pipe(Instance carrier) {
        Token t = (Token)carrier.getData();
        GeneDocument geneDocument = (GeneDocument)carrier.getSource();
        GeneSet gs = (GeneSet)t.getProperty("gs");
        double familyConf = 0.0;
        double geneConf = 0.0;
        boolean nogene = false;
        for (GeneMention gm : gs) {
            if (gm.getSpecificType() == GeneMention.SpecificType.FAMILYNAME) {
                familyConf += gm.getSpecificTypeConfidence();
            } else {
                geneConf += gm.getSpecificTypeConfidence();
            }
            if (((GeneMention)gm.getOverlappingGoldMentions().get(0)).getSpecificType() != GeneMention.SpecificType.NO_GENE) continue;
            nogene = true;
        }
        familyConf /= (double)gs.size();
        geneConf /= (double)gs.size();
        return carrier;
    }
}

