/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TokenPrefixPipe
extends Pipe {
    private static final long serialVersionUID = -7163636109881859558L;
    private String prefix;
    private int prefixLength;

    public TokenPrefixPipe(String prefix, int prefixLength) {
        this.prefix = prefix;
        this.prefixLength = prefixLength;
    }

    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            String s = t.getText();
            if (s.length() <= this.prefixLength) continue;
            t.setFeatureValue(this.prefix + s.substring(0, this.prefixLength), 1.0);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.prefix);
        out.writeInt(this.prefixLength);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.prefix = (String)in.readObject();
        this.prefixLength = in.readInt();
    }
}

