/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Pattern;

public class RegExPipe
extends Pipe {
    private static final long serialVersionUID = -3413642492165269351L;
    private Pattern regex;
    private String feature;

    public RegExPipe(String featureName, Pattern regex) {
        this.feature = featureName;
        this.regex = regex;
    }

    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            String s = t.getText();
            String conS = s;
            if (conS.startsWith("(")) {
                conS = conS.substring(1);
            }
            if (conS.endsWith(")") || conS.endsWith(".")) {
                conS = conS.substring(0, conS.length() - 1);
            }
            if (this.regex.matcher(s).matches()) {
                t.setFeatureValue(this.feature, 1.0);
            }
            if (conS.compareTo(s) == 0 || !this.regex.matcher(conS).matches()) continue;
            t.setFeatureValue(this.feature, 1.0);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.regex);
        out.writeObject(this.feature);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.regex = (Pattern)in.readObject();
        this.feature = (String)in.readObject();
    }
}

