/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.PosTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;

public class NounPipe
extends Pipe {
    private static final long serialVersionUID = -4682006591893008027L;
    private String featureName;

    public NounPipe(String featureName) {
        this.featureName = featureName;
    }

    public Instance pipe(Instance inst) {
        GeneDocument document = (GeneDocument)inst.getSource();
        TokenSequence ts = (TokenSequence)inst.getData();
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            GeneMention gm = (GeneMention)t.getProperty("gm");
            Optional<PosTag> noun = document.getOverlappingPosTags(gm.getOffsets()).stream().filter(pos -> pos.getTag().startsWith("N")).findAny();
            noun.ifPresent(tag -> t.setFeatureValue(this.featureName, 1.0));
        }
        return inst;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.featureName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.featureName = (String)in.readObject();
    }
}

