/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import java.util.stream.Stream;

public class GeneSet2GeneSequence
extends Pipe {
    private static final long serialVersionUID = 1L;

    public GeneSet2GeneSequence() {
        super(null, (Alphabet)new LabelAlphabet());
    }

    public Instance pipe(Instance carrier) {
        GeneSet geneSet = (GeneSet)carrier.getData();
        GeneDocument document = (GeneDocument)carrier.getSource();
        if (geneSet.isEmpty()) {
            throw new IllegalArgumentException("This given gene set is empty.");
        }
        TokenSequence tokenSequence = new TokenSequence(geneSet.size());
        LabelSequence labels = new LabelSequence((LabelAlphabet)this.getTargetAlphabet(), geneSet.size());
        for (GeneMention gm : geneSet) {
            Stream goldGenes = document.getOverlappingGoldGenes(gm.getOffsets());
            labels.add((Object)(goldGenes.findAny().isPresent() ? "TRUE" : "FALSE"));
            Token token = new Token(gm.getText());
            token.setProperty("gm", (Object)gm);
            tokenSequence.add((Object)token);
        }
        carrier.setData((Object)tokenSequence);
        carrier.setTarget((Object)labels);
        return carrier;
    }
}

