/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.filtering;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.java.utilities.spanutils.OffsetMap;
import de.julielab.java.utilities.spanutils.Span;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.apache.commons.lang3.Range;

public class ContextPosPipe
extends Pipe {
    private static final long serialVersionUID = -950513387211046959L;
    private String prefix;
    private int position;
    private boolean addWord;

    public ContextPosPipe(String prefix, int position, boolean addWord) {
        this.prefix = prefix;
        this.position = position;
        this.addWord = addWord;
    }

    public Instance pipe(Instance inst) {
        TokenSequence ts = (TokenSequence)inst.getData();
        GeneDocument document = (GeneDocument)inst.getSource();
        for (Token t : ts) {
            int currentPosition;
            GeneMention gm = (GeneMention)t.getProperty("gm");
            Range sentence = document.getOverlappingSentence((Span)gm);
            OffsetMap posTags = document.getPosTags();
            if (this.position < 0) {
                currentPosition = -1;
                Map.Entry prevPos = posTags.lowerEntry((Object)gm.getOffsets());
                do {
                    if (prevPos != null && (Integer)((Range)prevPos.getKey()).getMinimum() >= (Integer)sentence.getMinimum()) {
                        t.setFeatureValue(this.prefix + currentPosition + "=" + ((PosTag)prevPos.getValue()).getTag(), 1.0);
                        if (this.addWord) {
                            t.setFeatureValue(this.prefix + "-word" + currentPosition + "=" + document.getCoveredText((Span)prevPos.getValue()), 1.0);
                        }
                    } else {
                        t.setFeatureValue(this.prefix + currentPosition + "=<S>", 1.0);
                        if (this.addWord) {
                            t.setFeatureValue(this.prefix + "-word" + currentPosition + "=<S>", 1.0);
                        }
                    }
                    --currentPosition;
                    if (prevPos == null) continue;
                    prevPos = posTags.lowerEntry((Object)((Range)prevPos.getKey()));
                } while (currentPosition > this.position);
                continue;
            }
            if (this.position <= 0) continue;
            currentPosition = 1;
            Map.Entry nextPos = posTags.higherEntry((Object)gm.getOffsets());
            do {
                if (nextPos != null && (Integer)((Range)nextPos.getKey()).getMaximum() <= (Integer)sentence.getMaximum()) {
                    t.setFeatureValue(this.prefix + currentPosition + "=" + ((PosTag)nextPos.getValue()).getTag(), 1.0);
                    if (this.addWord) {
                        t.setFeatureValue(this.prefix + "-word" + currentPosition + "=" + document.getCoveredText((Span)nextPos.getValue()), 1.0);
                    }
                } else {
                    t.setFeatureValue(this.prefix + currentPosition + "=<S>", 1.0);
                    if (this.addWord) {
                        t.setFeatureValue(this.prefix + "-word" + currentPosition + "=<S>", 1.0);
                    }
                }
                ++currentPosition;
                if (nextPos == null) continue;
                nextPos = posTags.higherEntry((Object)((Range)nextPos.getKey()));
            } while (currentPosition < this.position);
        }
        return inst;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.prefix);
        out.writeInt(this.position);
        out.writeBoolean(this.addWord);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.prefix = (String)in.readObject();
        this.position = in.readInt();
        this.addWord = in.readBoolean();
    }
}

