/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.evaluation.tools;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;

public class Stats {
    private int numGenes;
    private int numGenesRecognized;
    private int correctGenesInCandidateList;
    private int correctGeneIdAfterRelaxed1;
    private int correctGeneIdAfterRelaxed2;
    private int correctGeneIdAfterRelaxed3;
    private int numExactMatchFirstTry;
    private int numExactMatchWithOrthologResolution;
    private int numCorrectGenesInCandidateListExactMatchFirstTry;
    private int numExactMatchAfterSpeciesRestriction;
    private int numCorrectGenesInCandidateListAfterSpeciesRestriction;
    private int numCorrectGenesInOrthologsOfExactMatch;
    private int numNoCorrectGenesInOrthologsOfExactMatch;
    private int numOrthologsOfExactMatchEmpty;
    private int numCorrectInInitialSearchNotInOrthologs;
    private int noCorrectAfterExactSearch;
    private int noCorrectAfterRelaxed1;
    private int noCorrectAfterRelaxed2;
    private int noCorrectAfterRelaxed3;
    private int totalCandidates;
    private int numCorrectMajorityGeneId;
    private int numCorrectFirstGeneId;
    private int numCorrectHighestMentionScoreGeneId;
    private int numUncertainAndWrong;
    private int numUncertainAndCorrect;
    private final DecimalFormat df = new DecimalFormat();
    private int numCertainAndWrong;
    private int numMissedMentions;
    private int numFpMentions;
    private int numGoldOverlappingMentions;
    private int numCorrectGeneIdInBestCandidates;
    private int numCorrectUnambiguousGeneIdsInBestCandidates;
    private int numBestCandidateHasCorrectId;
    private int numBestCandidateHasCorrectTaxId;
    private int numAmbiguousCorrectBestCandidates;
    private int numAmbiguousBestCandidateHasCorrectSelected;
    private int numAmbiguous;
    private int numDisambiguated;
    private int numCorrectlyDisambiguated;
    private int numCorrectExactHightestMentionScoreGeneId;
    private int numCorrectApprxHightestMentionScoreGeneId;
    private int numExactMatchedMentionsNotOverlappingGold;
    private int numApprxMatchedMentionsNotOverlappingGold;
    private int numCorrectExactTop3WithGold;
    private int numCorrectExactTop5WithGold;
    private int numCorrectApprxTop3WithGold;
    private int numCorrectApprxTop5WithGold;
    private int numCorrectExactTop10WithGold;
    private int numCorrectExactTop15WithGold;
    private int numCorrectApprxTop10WithGold;
    private int numCorrectApprxTop15WithGold;
    private int numCorrectGeneIdInExactBestCandidates;
    private int numCorrectGeneIdInApprxBestCandidates;
    private int numExactBestCandidateHasCorrectId;
    private int numApprxBestCandidateHasCorrectId;
    private int numExactGoldOverlappingMentions;
    private int numApprxGoldOverlappingMentions;
    private int numExactAmbiguous;
    private int numApprxAmbiguous;
    private int numExactAmbiguousCorrectBestCandidates;
    private int numApprxAmbiguousCorrectBestCandidates;
    private int numAmbiguousExactBestCandidateHasCorrectSelected;
    private int numAmbiguousApprxBestCandidateHasCorrectSelected;
    private int numExactCorrectlyDisambiguated;
    private int numApprxCorrectlyDisambiguated;
    private int numBestExactCandidateHasCorrectTaxId;
    private int numBestApprxCandidateHasCorrectTaxId;
    private int numApprxGenesRecognized;
    private int numExactGenesRecognized;
    private int numCandidateSearches;

    public void incNumFpMentions() {
        ++this.numFpMentions;
    }

    public void incNumUncertainAndWrong() {
        ++this.numUncertainAndWrong;
    }

    public void incNumUncertainAndCorrect() {
        ++this.numUncertainAndCorrect;
    }

    public void incNumCorrectHighestMentionScoreGeneId(boolean b) {
        if (b) {
            ++this.numCorrectHighestMentionScoreGeneId;
        }
    }

    public void incNumCorrectFirstGeneId(boolean b) {
        if (b) {
            ++this.numCorrectFirstGeneId;
        }
    }

    public void incNumCorrectMajorityGeneId(boolean b) {
        if (b) {
            ++this.numCorrectMajorityGeneId;
        }
    }

    public void incTotalNumberCandidates(int size) {
        this.totalCandidates += size;
    }

    public int getTotalNumberCandidates() {
        return this.totalCandidates;
    }

    public void incNoCorrectAfterExactSearch(boolean b) {
        if (b) {
            ++this.noCorrectAfterExactSearch;
        }
    }

    public void incNoCorrectAfterRelaxed1(boolean b) {
        if (b) {
            ++this.noCorrectAfterRelaxed1;
        }
    }

    public void incNoCorrectAfterRelaxed2(boolean b) {
        if (b) {
            ++this.noCorrectAfterRelaxed2;
        }
    }

    public void incNoCorrectAfterRelaxed3(boolean b) {
        if (b) {
            ++this.noCorrectAfterRelaxed3;
        }
    }

    public void incNumCorrectInInitialSearchNotInOrthologs(boolean correctInOrthologs, boolean correctBeforeOrthologsResolution) {
        if (!correctInOrthologs && correctBeforeOrthologsResolution) {
            ++this.numCorrectInInitialSearchNotInOrthologs;
        }
    }

    public void incCorrectGeneIdAfterRelaxed1(boolean b) {
        if (b) {
            ++this.correctGeneIdAfterRelaxed1;
        }
    }

    public void incNumExcactMatchWithOrthologResolution(boolean b) {
        if (b) {
            ++this.numExactMatchWithOrthologResolution;
        }
    }

    public int getNumCorrectGenesInOrthologsOfExactMatch() {
        return this.numCorrectGenesInOrthologsOfExactMatch;
    }

    public void incNumCorrectGenesInOrthologsOfExactMatchIfTrue(boolean orthologsEmpty, boolean correctInOrthologs) {
        if (correctInOrthologs) {
            ++this.numCorrectGenesInOrthologsOfExactMatch;
        } else {
            ++this.numNoCorrectGenesInOrthologsOfExactMatch;
        }
        if (orthologsEmpty) {
            ++this.numOrthologsOfExactMatchEmpty;
        }
    }

    public int getNumCorrectGenesInCandidateListAfterSpeciesRestriction() {
        return this.numCorrectGenesInCandidateListAfterSpeciesRestriction;
    }

    public void incNumCorrectGenesInCandidateListAfterSpeciesRestrictionIfTrue(boolean b) {
        if (b) {
            ++this.numCorrectGenesInCandidateListAfterSpeciesRestriction;
        }
    }

    public int getNumExactMatchAfterSpeciesRestriction() {
        return this.numExactMatchAfterSpeciesRestriction;
    }

    public void incNumExactMatchAfterSpeciesRestrictionIfTrue(Boolean b) {
        if (b.booleanValue()) {
            ++this.numExactMatchAfterSpeciesRestriction;
        }
    }

    public void incExactMatchFirstTryIfTrue(boolean b) {
        if (b) {
            ++this.numExactMatchFirstTry;
        }
    }

    public int getNumGenesRecognized() {
        return this.numGenesRecognized;
    }

    public int getNumApprxGenesRecognized() {
        return this.numApprxGenesRecognized;
    }

    public int getNumExactGenesRecognized() {
        return this.numExactGenesRecognized;
    }

    public String getReport() {
        List<String> report = Arrays.asList("Total genes: " + this.numGenes, "Genes recognized: " + this.numGenesRecognized, "    exact: " + this.numExactGenesRecognized, "    apprx: " + this.numApprxGenesRecognized, "Genes overlapping a gold mention recognized: " + this.numGoldOverlappingMentions, "    exact matches: " + this.numExactGoldOverlappingMentions, this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numExactGoldOverlappingMentions / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num gold overlapping not counted>)", "    apprx matches: " + this.numApprxGoldOverlappingMentions, this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numApprxGoldOverlappingMentions / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num gold overlapping not counted>)", "Counted missed mentions: " + this.numMissedMentions, "Correct ID in candidate list of correct pred: " + this.correctGenesInCandidateList + (String)(this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.correctGenesInCandidateList / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num gold overlapping not counted>)"), "Correct ID in candidate list of total genes: " + this.correctGenesInCandidateList + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.correctGenesInCandidateList / (double)this.numGenes * 100.0) + "%)" : " (<num genes not counted>)"), "Correct ID in best candidates of total: " + this.numCorrectGeneIdInBestCandidates + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.numCorrectGeneIdInBestCandidates / (double)this.numGenes * 100.0) + "%)" : " (<num genes not counted>)"), "    exact candidates: " + this.numCorrectGeneIdInExactBestCandidates + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.numCorrectGeneIdInExactBestCandidates / (double)this.numCorrectGeneIdInBestCandidates * 100.0) + "%)" : " (<num genes not counted>)") + " of all exact: " + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.numCorrectGeneIdInExactBestCandidates / (double)this.numExactGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)"), "    apprx candidates: " + this.numCorrectGeneIdInApprxBestCandidates + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.numCorrectGeneIdInApprxBestCandidates / (double)this.numCorrectGeneIdInBestCandidates * 100.0) + "%)" : " (<num genes not counted>)") + " of all apprx: " + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.numCorrectGeneIdInApprxBestCandidates / (double)this.numApprxGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)"), "Correct ID in best candidates unambiguous of correct pred: " + this.numCorrectUnambiguousGeneIdsInBestCandidates + (String)(this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectUnambiguousGeneIdsInBestCandidates / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)"), "Correct ID is the unambiguous best candidate of correct pred: " + this.numBestCandidateHasCorrectId + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.numBestCandidateHasCorrectId / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)"), "    exact best candidate of correct pred: " + this.numExactBestCandidateHasCorrectId + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.numExactBestCandidateHasCorrectId / (double)this.numBestCandidateHasCorrectId * 100.0) + "%)" : " (<num genes not counted>)") + " of all exact: " + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.numExactBestCandidateHasCorrectId / (double)this.numExactGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)"), "    apprx best candidate of correct pred: " + this.numApprxBestCandidateHasCorrectId + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.numApprxBestCandidateHasCorrectId / (double)this.numBestCandidateHasCorrectId * 100.0) + "%)" : " (<num genes not counted>)") + " of all apprx: " + (String)(this.numGenes > 0 ? " (" + this.df.format((double)this.numApprxBestCandidateHasCorrectId / (double)this.numApprxGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)"), "Number of ambiguous synonym hits of correct pred: " + this.numAmbiguous + (String)(this.numGenesRecognized > 0 ? " (" + this.df.format((double)this.numAmbiguous / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<no genes recognized>)"), "    exact: " + this.numExactAmbiguous + (String)(this.numAmbiguous > 0 ? " (" + this.df.format((double)this.numExactAmbiguous / (double)this.numAmbiguous * 100.0) + "%)" : " (<no genes recognized>)"), "    apprx: " + this.numApprxAmbiguous + (String)(this.numAmbiguous > 0 ? " (" + this.df.format((double)this.numApprxAmbiguous / (double)this.numAmbiguous * 100.0) + "%)" : " (<no genes recognized>)"), "Number of ambiguous correct best candidates of ambig: " + this.numAmbiguousCorrectBestCandidates + (String)(this.numAmbiguous > 0 ? " (" + this.df.format((double)this.numAmbiguousCorrectBestCandidates / (double)this.numAmbiguous * 100.0) + "%)" : " (<no ambiguous gene names>)"), "    exact: " + this.numExactAmbiguousCorrectBestCandidates + (String)(this.numAmbiguousCorrectBestCandidates > 0 ? " (" + this.df.format((double)this.numExactAmbiguousCorrectBestCandidates / (double)this.numAmbiguousCorrectBestCandidates * 100.0) + "%)" : " (<no ambiguous gene names>)"), "    apprx: " + this.numApprxAmbiguousCorrectBestCandidates + (String)(this.numAmbiguousCorrectBestCandidates > 0 ? " (" + this.df.format((double)this.numApprxAmbiguousCorrectBestCandidates / (double)this.numAmbiguousCorrectBestCandidates * 100.0) + "%)" : " (<no ambiguous gene names>)"), "Number of ambiguous best candidates having correct ID selected of ambig: " + this.numAmbiguousBestCandidateHasCorrectSelected + (String)(this.numAmbiguous > 0 ? " (" + this.df.format((double)this.numAmbiguousBestCandidateHasCorrectSelected / (double)this.numAmbiguous * 100.0) + "%)" : " (<no ambiguous gene names>)"), "    exact: " + this.numAmbiguousExactBestCandidateHasCorrectSelected + (String)(this.numAmbiguousBestCandidateHasCorrectSelected > 0 ? " (" + this.df.format((double)this.numAmbiguousExactBestCandidateHasCorrectSelected / (double)this.numAmbiguousBestCandidateHasCorrectSelected * 100.0) + "%)" : " (<no ambiguous gene names>)") + " of all ambiguous exact: " + (String)(this.numExactAmbiguous > 0 ? " (" + this.df.format((double)this.numAmbiguousExactBestCandidateHasCorrectSelected / (double)this.numExactAmbiguous * 100.0) + "%)" : " (<no exact ambiguous gene names>)"), "    apprx: " + this.numAmbiguousApprxBestCandidateHasCorrectSelected + (String)(this.numAmbiguousBestCandidateHasCorrectSelected > 0 ? " (" + this.df.format((double)this.numAmbiguousApprxBestCandidateHasCorrectSelected / (double)this.numAmbiguousBestCandidateHasCorrectSelected * 100.0) + "%)" : " (<no ambiguous gene names>)") + " of all ambiguous apprx: " + (String)(this.numApprxAmbiguous > 0 ? " (" + this.df.format((double)this.numAmbiguousApprxBestCandidateHasCorrectSelected / (double)this.numApprxAmbiguous * 100.0) + "%)" : " (<no apprx ambiguous gene names>)"), "Number disambiguated of ambig: " + this.numDisambiguated + (String)(this.numAmbiguous > 0 ? " (" + this.df.format((double)this.numDisambiguated / (double)this.numAmbiguous * 100.0) + "%)" : " (<no ambiguous gene names>)"), "Number correctly disambiguated: " + this.numCorrectlyDisambiguated + (String)(this.numDisambiguated > 0 ? " (" + this.df.format((double)this.numCorrectlyDisambiguated / (double)this.numDisambiguated * 100.0) + "%)" : " (<no gene names disambiguated>)"), "    exact: " + this.numExactCorrectlyDisambiguated + (String)(this.numCorrectlyDisambiguated > 0 ? " (" + this.df.format((double)this.numExactCorrectlyDisambiguated / (double)this.numCorrectlyDisambiguated * 100.0) + "%)" : " (<no gene names correctly disambiguated>)") + " of all ambiguous exact: " + (String)(this.numExactCorrectlyDisambiguated > 0 ? " (" + this.df.format((double)this.numExactCorrectlyDisambiguated / (double)this.numExactAmbiguous * 100.0) + "%)" : " (<no exact ambiguous gene names>)"), "    apprx: " + this.numApprxCorrectlyDisambiguated + (String)(this.numCorrectlyDisambiguated > 0 ? " (" + this.df.format((double)this.numApprxCorrectlyDisambiguated / (double)this.numCorrectlyDisambiguated * 100.0) + "%)" : " (<no gene names correctly disambiguated>)") + " of all ambiguous apprx: " + (String)(this.numExactCorrectlyDisambiguated > 0 ? " (" + this.df.format((double)this.numExactCorrectlyDisambiguated / (double)this.numApprxAmbiguous * 100.0) + "%)" : " (<no apprx ambiguous gene names>)"), "Best candidate has correct tax Id of gold overlapping: " + this.numBestCandidateHasCorrectTaxId + (String)(this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numBestCandidateHasCorrectTaxId / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)"), "    exact: " + this.numBestExactCandidateHasCorrectTaxId + (String)(this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numBestExactCandidateHasCorrectTaxId / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)") + " of exact overlapping: " + (String)(this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numBestExactCandidateHasCorrectTaxId / (double)this.numExactGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)"), "    apprx: " + this.numBestApprxCandidateHasCorrectTaxId + (String)(this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numBestApprxCandidateHasCorrectTaxId / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)") + " of apprx overlapping: " + (String)(this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numBestApprxCandidateHasCorrectTaxId / (double)this.numApprxGoldOverlappingMentions * 100.0) + "%)" : " (<num genes not counted>)"), "Synonym matches:", "    Exact synonym match on first search: " + this.numExactMatchFirstTry, "    Exact synonym match after species restriction: " + this.numExactMatchAfterSpeciesRestriction, "    Exact synonym match with tax ID match after ortholog resolution: " + this.numExactMatchWithOrthologResolution, "    Final number exact matched gene mentions with gold: " + this.numExactGoldOverlappingMentions, "    Final number exact approx  gene mentions with gold: " + this.numApprxGoldOverlappingMentions, "    Final number exact matched gene mentions no gold: " + this.numExactMatchedMentionsNotOverlappingGold, "    Final number exact approx  gene mentions no gold: " + this.numApprxMatchedMentionsNotOverlappingGold, "Correct gene ID in candidate list:", "    Correct genes in candidate list in exact match at first search: " + this.numCorrectGenesInCandidateListExactMatchFirstTry, "    Correct genes in candidate list after species restriction: " + this.numCorrectGenesInCandidateListAfterSpeciesRestriction, "    Correct genes in candidate lists after relaxation 1: " + this.correctGeneIdAfterRelaxed1, "    Correct genes in candidate lists after relaxation 2: " + this.correctGeneIdAfterRelaxed2, "    Correct genes in candidate lists after relaxation 3: " + this.correctGeneIdAfterRelaxed3, "    Correct exact matches top 3 with gold of all exact: " + this.numCorrectExactTop3WithGold + (String)(this.numExactGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectExactTop3WithGold / (double)this.numExactGoldOverlappingMentions * 100.0) + "%)" : " (<no exact matches overlapping gold>)"), "    Correct exact matches top 5 with gold of all exact: " + this.numCorrectExactTop5WithGold + (String)(this.numExactGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectExactTop5WithGold / (double)this.numExactGoldOverlappingMentions * 100.0) + "%)" : " (<no exact matches overlapping gold>)"), "    Correct exact matches top 10 with gold of all exact: " + this.numCorrectExactTop10WithGold + (String)(this.numExactGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectExactTop10WithGold / (double)this.numExactGoldOverlappingMentions * 100.0) + "%)" : " (<no exact matches overlapping gold>)"), "    Correct exact matches top 15 with gold of all exact: " + this.numCorrectExactTop15WithGold + (String)(this.numExactGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectExactTop15WithGold / (double)this.numExactGoldOverlappingMentions * 100.0) + "%)" : " (<no exact matches overlapping gold>)"), "    Correct apprx matches top 3 with gold of all apprx: " + this.numCorrectApprxTop3WithGold + (String)(this.numApprxGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectApprxTop3WithGold / (double)this.numApprxGoldOverlappingMentions * 100.0) + "%)" : " (<no apprx matches overlapping gold>)"), "    Correct apprx matches top 5 with gold of all apprx: " + this.numCorrectApprxTop5WithGold + (String)(this.numApprxGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectApprxTop5WithGold / (double)this.numApprxGoldOverlappingMentions * 100.0) + "%)" : " (<no apprx matches overlapping gold>)"), "    Correct apprx matches top 10 with gold of all apprx: " + this.numCorrectApprxTop10WithGold + (String)(this.numApprxGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectApprxTop10WithGold / (double)this.numApprxGoldOverlappingMentions * 100.0) + "%)" : " (<no apprx matches overlapping gold>)"), "    Correct apprx matches top 15 with gold of all apprx: " + this.numCorrectApprxTop15WithGold + (String)(this.numApprxGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectApprxTop15WithGold / (double)this.numApprxGoldOverlappingMentions * 100.0) + "%)" : " (<no apprx matches overlapping gold>)"), "Orthology resolution of exact match:", "    Correct SynHit found in orthologs: " + this.numCorrectGenesInOrthologsOfExactMatch, "    No correct SynHit found in orthologs: " + this.numNoCorrectGenesInOrthologsOfExactMatch, "    Found correct before orthology resolution but not after: " + this.numCorrectInInitialSearchNotInOrthologs, "    Ortholog list empty: " + this.numOrthologsOfExactMatchEmpty, "No correct gene IDs found:", "    After exact match: " + this.noCorrectAfterExactSearch, "    After relaxation 1: " + this.noCorrectAfterRelaxed1, "    After relaxation 2: " + this.noCorrectAfterRelaxed2, "    After relaxation 3: " + this.noCorrectAfterRelaxed3, "Average number of candidates per recognized gene mention: " + (Serializable)(this.numGoldOverlappingMentions > 0 ? Integer.valueOf(this.totalCandidates / this.numGoldOverlappingMentions) : "<num overlapping gold not counted>"), "Majority geneId of candidate list was correct for derived genes: " + this.numCorrectMajorityGeneId + (String)(this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectMajorityGeneId / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num overlapping gold not counted>)"), "First geneId of candidate list was correct for derived genes: " + this.numCorrectFirstGeneId + (String)(this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectFirstGeneId / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num overlapping gold not counted>)"), "Highest mention score geneId of candidate list was correct for derived genes: " + this.numCorrectHighestMentionScoreGeneId + (String)(this.numGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectHighestMentionScoreGeneId / (double)this.numGoldOverlappingMentions * 100.0) + "%)" : " (<num overlapping gold not counted>)"), "Exact matches have correct ID in highest scored SynHits: " + this.numCorrectExactHightestMentionScoreGeneId + (String)(this.numExactGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectExactHightestMentionScoreGeneId / (double)this.numExactGoldOverlappingMentions * 100.0) + "%)" : " (<no exact matches overlapping gold>)"), "Apprx matches have correct ID in highest scored SynHits: " + this.numCorrectApprxHightestMentionScoreGeneId + (String)(this.numApprxGoldOverlappingMentions > 0 ? " (" + this.df.format((double)this.numCorrectApprxHightestMentionScoreGeneId / (double)this.numApprxGoldOverlappingMentions * 100.0) + "%)" : " (<no apprx matches overlapping gold>)"), "Number of uncertain mentions that do not have a correct candidate: " + this.numUncertainAndWrong, "Number of uncertain mentions that have a correct candidate: " + this.numUncertainAndCorrect, "Number of certain mentions that do not have a correct candidate: " + this.numCertainAndWrong, "Number of false positive mentions not overlapping any gold mention: " + this.numFpMentions);
        return String.join((CharSequence)"\n", report);
    }

    public int getNumExactGoldOverlappingMentions() {
        return this.numExactGoldOverlappingMentions;
    }

    public int getNumApprxGoldOverlappingMentions() {
        return this.numApprxGoldOverlappingMentions;
    }

    public int getNumCorrectExactTop3WithGold() {
        return this.numCorrectExactTop3WithGold;
    }

    public int getNumCorrectExactTop5WithGold() {
        return this.numCorrectExactTop5WithGold;
    }

    public int getNumCorrectApprxTop3WithGold() {
        return this.numCorrectApprxTop3WithGold;
    }

    public int getNumCorrectApprxTop5WithGold() {
        return this.numCorrectApprxTop5WithGold;
    }

    public int getNumCorrectExactTop10WithGold() {
        return this.numCorrectExactTop10WithGold;
    }

    public int getNumCorrectExactTop15WithGold() {
        return this.numCorrectExactTop15WithGold;
    }

    public int getNumCorrectApprxTop10WithGold() {
        return this.numCorrectApprxTop10WithGold;
    }

    public int getNumCorrectApprxTop15WithGold() {
        return this.numCorrectApprxTop15WithGold;
    }

    public void incNumPerfectMatchFirstTry() {
        ++this.numExactMatchFirstTry;
    }

    public void incNumCorrectGenesInCandidateListExactMatchFirstTry() {
        ++this.numCorrectGenesInCandidateListExactMatchFirstTry;
    }

    public void incNumCorrectGenesInCandidateListExactMatchFirstTryIfTrue(boolean b) {
        if (b) {
            ++this.numCorrectGenesInCandidateListExactMatchFirstTry;
        }
    }

    public int getNumExactMatchFirstTry() {
        return this.numExactMatchFirstTry;
    }

    public int getNumCorrectGenesInCandidateListExactMatchFirstTry() {
        return this.numCorrectGenesInCandidateListExactMatchFirstTry;
    }

    public int getNumGenes() {
        return this.numGenes;
    }

    public int getCorrectGenesInCandidateList() {
        return this.correctGenesInCandidateList;
    }

    public void incNumGenes() {
        ++this.numGenes;
    }

    public void incCorrectGenesInCandidateList() {
        ++this.correctGenesInCandidateList;
    }

    public void incCorrectGenesInCandidateList(Boolean hasCorrectEntryInOrthologs) {
        if (hasCorrectEntryInOrthologs.booleanValue()) {
            ++this.correctGenesInCandidateList;
        }
    }

    public void incCorrectGeneIdAfterRelaxed2(Boolean b) {
        if (b.booleanValue()) {
            ++this.correctGeneIdAfterRelaxed2;
        }
    }

    public void incCorrectGeneIdAfterRelaxed3(Boolean b) {
        if (b.booleanValue()) {
            ++this.correctGeneIdAfterRelaxed3;
        }
    }

    public void incNumGenesRecognized() {
        ++this.numGenesRecognized;
    }

    public void incNumCertainAndWrong() {
        ++this.numCertainAndWrong;
    }

    public void incMissedMentions() {
        ++this.numMissedMentions;
    }

    public void incNumGoldOverlappingGenesRecognized() {
        ++this.numGoldOverlappingMentions;
    }

    public void incCorrectGeneIdInBestCandidates() {
        ++this.numCorrectGeneIdInBestCandidates;
    }

    public void incUnambiguousCorrectGeneInBestCandidates() {
        ++this.numCorrectUnambiguousGeneIdsInBestCandidates;
    }

    public void incBestCandidateHasCorrectId() {
        ++this.numBestCandidateHasCorrectId;
    }

    public void incBestCandidateHasCorrectTaxId() {
        ++this.numBestCandidateHasCorrectTaxId;
    }

    public void incBestCandidateWithCorrectIdIsAmbiguous() {
        ++this.numAmbiguousCorrectBestCandidates;
    }

    public void incAmbiguousBestCandidateHasCorrectIdSelected() {
        ++this.numAmbiguousBestCandidateHasCorrectSelected;
    }

    public void incNumAmbiguous() {
        ++this.numAmbiguous;
    }

    public void incDisambiguated() {
        ++this.numDisambiguated;
    }

    public void incCorrectlyDisambiguated() {
        ++this.numCorrectlyDisambiguated;
    }

    public void incExactCorrectlyDisambiguated() {
        ++this.numExactCorrectlyDisambiguated;
    }

    public void incApprxCorrectlyDisambiguated() {
        ++this.numApprxCorrectlyDisambiguated;
    }

    public void incNumCorrectExactHightestMentionScoreGeneId(Boolean b) {
        if (b.booleanValue()) {
            ++this.numCorrectExactHightestMentionScoreGeneId;
        }
    }

    public void incNumCorrectApprxHightestMentionScoreGeneId(Boolean b) {
        if (b.booleanValue()) {
            ++this.numCorrectApprxHightestMentionScoreGeneId;
        }
    }

    public void incNotGoldOverlappingMatchType(boolean exactMatch) {
        if (exactMatch) {
            ++this.numExactMatchedMentionsNotOverlappingGold;
        } else {
            ++this.numApprxMatchedMentionsNotOverlappingGold;
        }
    }

    public void incNumCorrectExactMatchesTop3(Boolean b) {
        if (b.booleanValue()) {
            ++this.numCorrectExactTop3WithGold;
        }
    }

    public void incNumCorrectExactMatchesTop5(Boolean b) {
        if (b.booleanValue()) {
            ++this.numCorrectExactTop5WithGold;
        }
    }

    public void incNumCorrectApprxMatchesTop3(Boolean b) {
        if (b.booleanValue()) {
            ++this.numCorrectApprxTop3WithGold;
        }
    }

    public void incNumCorrectApprxMatchesTop5(Boolean b) {
        if (b.booleanValue()) {
            ++this.numCorrectApprxTop5WithGold;
        }
    }

    public void incNumCorrectExactMatchesTop10(Boolean b) {
        if (b.booleanValue()) {
            ++this.numCorrectExactTop10WithGold;
        }
    }

    public void incNumCorrectExactMatchesTop15(Boolean b) {
        if (b.booleanValue()) {
            ++this.numCorrectExactTop15WithGold;
        }
    }

    public void incNumCorrectApprxMatchesTop10(Boolean b) {
        if (b.booleanValue()) {
            ++this.numCorrectApprxTop10WithGold;
        }
    }

    public void incNumCorrectApprxMatchesTop15(Boolean b) {
        if (b.booleanValue()) {
            ++this.numCorrectApprxTop15WithGold;
        }
    }

    public void incCorrectGeneIdInExactBestCandidates() {
        ++this.numCorrectGeneIdInExactBestCandidates;
    }

    public void incCorrectGeneIdInApprxBestCandidates() {
        ++this.numCorrectGeneIdInApprxBestCandidates;
    }

    public void incExactBestCandidateHasCorrectId() {
        ++this.numExactBestCandidateHasCorrectId;
    }

    public void incApprxBestCandidateHasCorrectId() {
        ++this.numApprxBestCandidateHasCorrectId;
    }

    public void incNumExactGoldOverlappingGenesRecognized() {
        ++this.numExactGoldOverlappingMentions;
    }

    public void incNumApprxGoldOverlappingGenesRecognized() {
        ++this.numApprxGoldOverlappingMentions;
    }

    public void incNumExactAmbiguous() {
        ++this.numExactAmbiguous;
    }

    public void incNumApprxAmbiguous() {
        ++this.numApprxAmbiguous;
    }

    public void incExactBestCandidateWithCorrectIdIsAmbiguous() {
        ++this.numExactAmbiguousCorrectBestCandidates;
    }

    public void incApprxBestCandidateWithCorrectIdIsAmbiguous() {
        ++this.numApprxAmbiguousCorrectBestCandidates;
    }

    public void incAmbiguousExactBestCandidateHasCorrectIdSelected() {
        ++this.numAmbiguousExactBestCandidateHasCorrectSelected;
    }

    public void incAmbiguousApprxBestCandidateHasCorrectIdSelected() {
        ++this.numAmbiguousApprxBestCandidateHasCorrectSelected;
    }

    public void incBestExactCandidateHasCorrectTaxId() {
        ++this.numBestExactCandidateHasCorrectTaxId;
    }

    public void incBestApprxCandidateHasCorrectTaxId() {
        ++this.numBestApprxCandidateHasCorrectTaxId;
    }

    public void incNumExactGenesRecognized() {
        ++this.numExactGenesRecognized;
    }

    public void incNumApprxGenesRecognized() {
        ++this.numApprxGenesRecognized;
    }

    public void incNumCandidateSearches() {
        ++this.numCandidateSearches;
    }

    public int getNumCandidateSearches() {
        return this.numCandidateSearches;
    }
}

