/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.evaluation.tools;

import de.julielab.java.utilities.FileUtilities;
import de.julielab.xml.JulieXMLTools;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;

public class GenelistIdUpdater {
    private static final String EUTILS = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=gene&id=";
    private static final String XPATH_RECORDS = "/eSummaryResult/DocumentSummarySet/DocumentSummary";
    private static final String XPATH_QUERY_ID = "@uid";
    private static final String XPATH_CURRENT_ID = "CurrentID";

    public static void main(String[] args) throws IOException {
        List records;
        String inputgenelist = "data/eval_data/gnormplus_data/bc2train/bc2train.genelist";
        String outputgenelist = "data/eval_data/gnormplus_data/bc2train/bc2train_updatedids.genelist";
        HashMap<String, String> updatedIds = new HashMap<String, String>();
        System.out.println("Reading genelist from " + inputgenelist);
        try (BufferedReader input = FileUtilities.getReaderFromFile((File)new File(inputgenelist));){
            records = input.lines().map(line -> line.split("\t")).collect(Collectors.toList());
        }
        Set sourceIds = records.stream().map(split -> split[1]).collect(Collectors.toSet());
        System.out.println("Got " + sourceIds.size() + " unique gene IDs for update.");
        int batchsize = 50;
        ArrayList<String> currentIdBatch = new ArrayList<String>();
        for (String string : sourceIds) {
            currentIdBatch.add(string);
            if (currentIdBatch.size() % 50 != 0) continue;
            String ids = currentIdBatch.stream().collect(Collectors.joining(","));
            URL url = new URL(EUTILS + ids);
            byte[] bytes = IOUtils.toByteArray((URL)url);
            ArrayList<Map> fields = new ArrayList<Map>();
            fields.add(JulieXMLTools.createField((String[])new String[]{"name", "queryid", "xpath", XPATH_QUERY_ID}));
            fields.add(JulieXMLTools.createField((String[])new String[]{"name", "currentid", "xpath", XPATH_CURRENT_ID}));
            Iterator it = JulieXMLTools.constructRowIterator((byte[])bytes, (int)8096, (String)XPATH_RECORDS, fields, (String)ids, (boolean)false);
            while (it.hasNext()) {
                Map row = (Map)it.next();
                String queryId = (String)row.get("queryid");
                String currentId = (String)row.get("currentid");
                if (currentId.equals("0")) continue;
                updatedIds.put(queryId, currentId);
            }
            currentIdBatch.clear();
        }
        System.out.println("All ID updates:");
        for (Map.Entry entry : updatedIds.entrySet()) {
            System.out.println((String)entry.getKey() + " -> " + (String)entry.getValue());
        }
        System.out.println("Writing updated genelist to: " + outputgenelist);
        try (BufferedWriter bw = FileUtilities.getWriterToFile((File)new File(outputgenelist));){
            for (String[] record : records) {
                String updatedId;
                record[1] = updatedId = updatedIds.getOrDefault(record[1], record[1]);
                String outputline = Stream.of(record).collect(Collectors.joining("\t"));
                bw.write(outputline);
                bw.newLine();
            }
        }
        System.out.println("Done.");
    }
}

