/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.evaluation;

import de.julielab.geneexpbase.candidateretrieval.CandidateRetrieval;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSet;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import de.julielab.java.utilities.Color;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class GeneIdCorrectnessRenderer {
    public static String renderCorrectIdGeneMention(GeneMention gm) {
        String matchType = gm.hasExactCandidateMatch() ? "E" : "A";
        String idString = gm.isRejected() ? "<rejected>" : gm.getMentionMappingResult().tax2finalRankedCandidates.values().stream().map(l -> ((SynHit)l.get(0)).getId()).collect(Collectors.joining(", ")) + " (TaxId: " + gm.getAllGoldTaxonomyIdsAsSet().stream().collect(Collectors.joining(", ")) + ")";
        return Color.GREEN + gm.getText() + " [" + matchType + "Id: " + idString + "]" + Color.RESET;
    }

    public static String renderCorrectGeneSetMention(GeneMention gm, String goldId) {
        return Color.GREEN + "[" + gm.getGeneSets().stream().map(GeneSet::getNumber).map(String::valueOf).collect(Collectors.joining(", ")) + "|" + goldId + " " + gm.getText() + "]" + Color.RESET;
    }

    public static String renderCorrectRejection(GeneMention gm) {
        String matchType = gm.hasExactCandidateMatch() ? "E" : "A";
        return Color.GREEN + gm.getText() + " [" + matchType + "]" + Color.RESET;
    }

    public static String renderIncorrectRejection(GeneMention gm) {
        String matchType = gm.hasExactCandidateMatch() ? "E" : "A";
        return Color.RED + gm.getText() + " [" + matchType + "]" + Color.RESET;
    }

    public static String renderMissedRejection(GeneMention gm) {
        String matchType = gm.hasExactCandidateMatch() ? "E" : "A";
        return Color.CYAN + gm.getText() + " [" + matchType + "]" + Color.RESET;
    }

    public static String renderWrongGeneSetMention(GeneMention gm, String goldId) {
        GeneSet firstGeneSetWithGoldId = gm.getGeneDocument().getGeneSets().stream().filter(gs -> gs.getAllGoldIdsAsSet().contains(goldId)).findFirst().get();
        int idColorIndex = (firstGeneSetWithGoldId.getNumber() % Color.values().length + 5) % Color.values().length;
        Color idColor = Color.values()[idColorIndex];
        int gsColorIndex = (((GeneSet)gm.getGeneSets().stream().findFirst().get()).getNumber() % Color.values().length + 5) % Color.values().length;
        Color gsColor = Color.values()[gsColorIndex];
        return gsColor + "[" + gm.getGeneSets().stream().map(GeneSet::getNumber).map(String::valueOf).collect(Collectors.joining(", ")) + "|" + idColor + goldId + gsColor + " " + gm.getText() + "]" + Color.RESET;
    }

    public static String renderWrongIdGeneMention(GeneMention gm, CandidateRetrieval candidateRetrieval, QueryGenerator queryGenerator) {
        Set correctIds;
        if (gm.getGeneDocument().isGoldHasOffsets()) {
            correctIds = gm.getAllGoldIdAsSet();
        } else {
            List candidates = candidateRetrieval.getCandidates(gm, (Collection)gm.getGeneDocument().getGoldIds(), queryGenerator);
            correctIds = candidates.stream().filter(SynHit::isExactMatch).map(SynHit::getId).collect(Collectors.toSet());
        }
        List<SynHit> bestCandidates = gm.isRejected() ? List.of(MentionMappingResult.REJECTION) : gm.getMentionMappingResult().tax2finalRankedCandidates.values().stream().map(l -> (SynHit)l.get(0)).collect(Collectors.toList());
        String matchType = gm.hasExactCandidateMatch() ? "E" : "A";
        return Color.RED + gm.getText() + " [" + matchType + "Id: " + bestCandidates.stream().map(SynHit::getId).collect(Collectors.joining(", ")) + " | Correct: " + Color.CYAN + correctIds.stream().collect(Collectors.joining(", ")) + " (Tax: " + gm.getAllGoldTaxonomyIdsAsSet().stream().collect(Collectors.joining(", ")) + ")" + Color.RED + "]" + Color.RESET;
    }

    public static String renderWrongIdGeneMention(GeneMention gm) {
        String matchType = gm.hasExactCandidateMatch() ? "E" : "A";
        return Color.RED + gm.getText() + " [" + matchType + "Id: " + gm.getMentionMappingResult().tax2finalRankedCandidates.values().stream().map(l -> ((SynHit)l.get(0)).getId()).collect(Collectors.joining(", ")) + " | Correct: " + Color.CYAN + (gm.getGeneDocument().isGoldHasOffsets() ? String.join((CharSequence)", ", gm.getAllGoldIdAsSet()) : "<doc level ids>") + Color.RED + "]" + Color.RESET;
    }

    public static String renderNoCorrectCandidateIdGeneMention(GeneMention gm) {
        String matchType = gm.hasExactCandidateMatch() ? "E" : "A";
        List<SynHit> bestCandidates = !gm.isRejected() ? gm.getMentionMappingResult().tax2finalRankedCandidates.values().stream().map(l -> (SynHit)l.get(0)).collect(Collectors.toList()) : List.of(MentionMappingResult.REJECTION);
        return Color.YELLOW + gm.getText() + " [" + matchType + "Id: " + bestCandidates.stream().map(SynHit::getId).collect(Collectors.joining(", ")) + ", FP]" + Color.RESET;
    }

    public static String renderNoCorrectMentionGeneSet(GeneMention gm, String goldId) {
        return Color.YELLOW + "[" + gm.getGeneSets().stream().map(GeneSet::getNumber).map(String::valueOf).collect(Collectors.joining(", ")) + " " + gm.getText() + "] " + Color.RESET;
    }
}

