/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.disambig.wikipedia;

import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.genemapper.disambig.wikipedia.WikipediaEntity;
import de.julielab.genemapper.disambig.wikipedia.WikipediaIndexReader;
import de.julielab.genemapper.utils.GeneMapperException;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class WikipediaEntityClassDecisionBear {
    private static final Set<String> FAMILY_CUES = Set.of("family", "superfamily", "families");
    private static final Set<String> NON_GENE_ENTITY_CUES = Set.of("disorder", "disease", "hormone");
    private static final Set<String> COMPLEX_CUES = Set.of("complex", "protein complex");
    private static final Set<String> GRPE = Set.of("gene", "protein");
    private final WikipediaIndexReader wikipedia;
    private final TermNormalizer normalizer;
    private static final Set<String> alreadySeen = Set.of();

    @Inject
    public WikipediaEntityClassDecisionBear(WikipediaIndexReader wikipediaIndexReader, TermNormalizer normalizer) throws GeneMapperException {
        this.wikipedia = wikipediaIndexReader;
        this.normalizer = normalizer;
    }

    public GeneMention.SpecificType lookupEntityType(GeneMention gm) {
        String normalizedGeneName;
        List<WikipediaEntity> pageHits;
        GeneMention.SpecificType ret = GeneMention.SpecificType.UNKNOWN;
        String geneName = gm.getText();
        GeneDocument document = gm.getGeneDocument();
        if (geneName.endsWith("s") && document.getOverlappingPosTags(gm.getOffsets()).stream().anyMatch(pos -> pos.getTag().equals("NNS"))) {
            geneName = geneName.substring(0, geneName.length() - 1);
        }
        if ((pageHits = this.wikipedia.searchWikipedia(normalizedGeneName = this.normalizer.normalize(geneName))).isEmpty() && normalizedGeneName.endsWith("s")) {
            pageHits = this.wikipedia.searchWikipedia(normalizedGeneName.substring(0, normalizedGeneName.length() - 1));
        }
        WikipediaEntity selectedPage = null;
        if (!pageHits.isEmpty()) {
            String alreadySeenKey;
            selectedPage = this.selectPage(pageHits);
            List<String> entities = selectedPage.getEntities();
            if (!entities.isEmpty()) {
                if (FAMILY_CUES.contains(entities.get(0))) {
                    ret = GeneMention.SpecificType.FAMILYNAME;
                } else if (GRPE.contains(entities.get(0))) {
                    ret = GeneMention.SpecificType.GENE;
                } else if (COMPLEX_CUES.contains(entities.get(0))) {
                    ret = GeneMention.SpecificType.COMPLEX;
                } else if (NON_GENE_ENTITY_CUES.contains(entities.get(0))) {
                    ret = GeneMention.SpecificType.NO_GENE;
                } else if (entities.get(0).equalsIgnoreCase("proteins")) {
                    ret = GeneMention.SpecificType.GROUP;
                }
            }
            if (ret != GeneMention.SpecificType.UNKNOWN || gm.hasGoldMentions() || gm.hasExactCandidateMatch() || !alreadySeen.contains(alreadySeenKey = gm.getDocId() + gm.getBegin() + gm.getEnd())) {
                // empty if block
            }
        }
        return ret;
    }

    private Pair<Set<ClassAncestor>, Set<ClassAncestor>> determineClasses(WikipediaEntity wikipediaPage, Set<ClassAncestor> entityClasses, Set<ClassAncestor> mentionedWikipediaPages) {
        for (String entity : wikipediaPage.getEntities()) {
            entityClasses.add(new ClassAncestor(entity, 0));
        }
        for (String mentionedWikipediaPage : wikipediaPage.getMentionedWikipediaEntities()) {
            mentionedWikipediaPages.add(new ClassAncestor(mentionedWikipediaPage, 0));
        }
        return new ImmutablePair(entityClasses, mentionedWikipediaPages);
    }

    private WikipediaEntity selectPage(List<WikipediaEntity> pageHits) {
        WikipediaEntity selectedPage = pageHits.get(0);
        if (selectedPage.getEntities().isEmpty()) {
            for (int i = 1; i < pageHits.size() && pageHits.get(i).getEntities().isEmpty(); ++i) {
                selectedPage = pageHits.get(i);
            }
        }
        return selectedPage;
    }

    private class ClassAncestor {
        private String classname;
        private int distance;

        public ClassAncestor(String classname, int distance) {
            this.classname = classname;
            this.distance = distance;
        }

        public String toString() {
            return "ClassAncestor{classname='" + this.classname + "', distance=" + this.distance + "}";
        }

        public String getClassname() {
            return this.classname;
        }

        public void setClassname(String classname) {
            this.classname = classname;
        }

        public int getDistance() {
            return this.distance;
        }

        public void setDistance(int distance) {
            this.distance = distance;
        }
    }
}

