/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.disambig;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.wcohen.ss.Jaccard;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.genemapper.disambig.SemanticIndex;
import de.julielab.genemapper.utils.ContextUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticContextIndex
implements SemanticIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticContextIndex.class);
    private static final ConcurrentHashMap<String, Cache<String, String>> caches = new ConcurrentHashMap();
    public IndexSearcher searcher = null;
    boolean debug = false;
    private Cache<String, String> geneContextCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SemanticContextIndex(File indexDir) throws IOException {
        DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((Path)indexDir.toPath()));
        this.searcher = new IndexSearcher((IndexReader)reader);
        this.searcher.setSimilarity((Similarity)new ClassicSimilarity());
        LOGGER.info("using " + indexDir.getAbsolutePath() + " as semantic disambiguation index with " + this.searcher.getIndexReader().numDocs() + " gene entries");
        String indexPath = indexDir.getCanonicalPath();
        ConcurrentHashMap<String, Cache<String, String>> concurrentHashMap = caches;
        synchronized (concurrentHashMap) {
            this.geneContextCache = caches.get(indexPath);
            if (this.geneContextCache == null) {
                LOGGER.info("Creating new gene context cache for index {}", (Object)indexPath);
                this.geneContextCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
                if (null != caches.put(indexPath, this.geneContextCache)) {
                    throw new IllegalStateException("There already is a candidate index for " + indexPath + " which points to a faulty concurrency implementation");
                }
            } else {
                LOGGER.info("Using existing gene context cache for index {}", (Object)indexPath);
            }
        }
    }

    public SynHit doDisambiguation(List<SynHit> filteredCandidates, Query query) throws IOException {
        return this.doDisambiguation(filteredCandidates, query, 0.0);
    }

    public SynHit doDisambiguation(List<SynHit> filteredCandidates, Query query, double minContextScore) throws IOException {
        ArrayList<SynHit> resultList = new ArrayList<SynHit>();
        HashMap<String, SynHit> hits = new HashMap<String, SynHit>();
        TopDocs foundDocs = this.getContextForSynHits(filteredCandidates, hits, query);
        ScoreDoc[] scoredDocs = foundDocs.scoreDocs;
        for (int i = 0; i < scoredDocs.length; ++i) {
            Document d = this.searcher.doc(scoredDocs[i].doc);
            String id = d.getField("indexed_id").stringValue();
            SynHit hit = hits.get(id);
            hit.setContextualScore((double)scoredDocs[i].score);
            hit.setCompareType(SynHit.CompareType.SEMSCORE);
            resultList.add(hit);
            LOGGER.debug("hit: " + hit);
            LOGGER.debug("TFIDF semantic score is: " + scoredDocs[i].score);
        }
        Collections.sort(resultList);
        if (resultList.size() == 0) {
            return null;
        }
        SynHit bestHit = (SynHit)resultList.get(0);
        LOGGER.debug("doDisambiguation() - bestHit: " + bestHit);
        if (bestHit.getContextualScore() >= minContextScore) {
            return bestHit;
        }
        return null;
    }

    public Map<String, String> retrieveGeneContexts(List<SynHit> candidates) throws IOException {
        HashMap<String, String> docContextById = new HashMap<String, String>();
        ArrayList<SynHit> candidatesNotInCache = new ArrayList<SynHit>();
        for (SynHit candidate : candidates) {
            String context = (String)this.geneContextCache.getIfPresent((Object)candidate.getId());
            if (context == null) {
                candidatesNotInCache.add(candidate);
                continue;
            }
            docContextById.put(candidate.getId(), context);
        }
        if (!candidatesNotInCache.isEmpty()) {
            ScoreDoc[] scoreDocs;
            HashMap<String, SynHit> hitsById = new HashMap<String, SynHit>();
            for (ScoreDoc scoreDoc : scoreDocs = this.getContextForSynHits(candidatesNotInCache, hitsById, null).scoreDocs) {
                Document doc = this.getSemanticIndexSearcher().doc(scoreDoc.doc);
                String geneId = doc.getField("indexed_id").stringValue();
                String geneContext = doc.getField("indexed_context").stringValue();
                docContextById.put(geneId, geneContext);
                this.geneContextCache.put((Object)geneId, (Object)geneContext);
            }
        }
        return docContextById;
    }

    public TopDocs getContextForSynHits(List<SynHit> hits, Map<String, SynHit> id2Hit, Query query) throws IOException {
        String[] ids = new String[hits.size()];
        for (int i = 0; i < hits.size(); ++i) {
            SynHit hit = hits.get(i);
            String id = hit.getId();
            id2Hit.put(id, hit);
            ids[i] = id;
        }
        LOGGER.debug("number of IDs: " + ids.length);
        Query q = this.makeQuery(ids, query);
        LOGGER.debug("query: " + q);
        TopDocs foundDocs = this.searcher.search(q, hits.size());
        ScoreDoc[] scoredDocs = foundDocs.scoreDocs;
        LOGGER.debug("scoredDocs.length: {}", (Object)scoredDocs.length);
        return foundDocs;
    }

    public BooleanQuery makeContextQuery(String context) throws IOException {
        BooleanQuery.Builder contextQuery = new BooleanQuery.Builder();
        try (TokenStream stemmer = ContextUtils.getStemmingStream(context);){
            CharTermAttribute cattr = (CharTermAttribute)stemmer.addAttribute(CharTermAttribute.class);
            while (stemmer.incrementToken()) {
                TermQuery q = new TermQuery(new Term("indexed_context", cattr.toString()));
                contextQuery.add((Query)q, BooleanClause.Occur.SHOULD);
            }
        }
        return contextQuery.build();
    }

    public Query makeQuery(String[] allowedIDs, Query query) throws IOException {
        BooleanQuery.Builder idQuery = new BooleanQuery.Builder();
        for (int i = 0; i < allowedIDs.length; ++i) {
            String id = allowedIDs[i];
            TermQuery q = new TermQuery(new Term("indexed_id", id));
            idQuery.add((Query)q, BooleanClause.Occur.SHOULD);
            LOGGER.debug("makeQuery() - id added to idQuery: " + id);
        }
        BooleanQuery.Builder contextQuery = new BooleanQuery.Builder();
        contextQuery.add(query, BooleanClause.Occur.MUST);
        contextQuery.add((Query)idQuery.build(), BooleanClause.Occur.FILTER);
        return contextQuery.build();
    }

    public BooleanQuery makeQuery(String allowedID, BooleanQuery contextQuery) throws IOException {
        BooleanQuery.Builder idQuery = new BooleanQuery.Builder();
        idQuery.add((Query)contextQuery, BooleanClause.Occur.MUST);
        TermQuery q = new TermQuery(new Term("indexed_id", allowedID));
        idQuery.add((Query)q, BooleanClause.Occur.FILTER);
        LOGGER.debug("makeQuery() - id added to idQuery: " + allowedID);
        return idQuery.build();
    }

    public SynHit doSeparateDisambiguation(ArrayList<SynHit> disambigList, String context, double minContextScore) throws IOException {
        String[] ids = new String[disambigList.size()];
        HashMap hits = new HashMap();
        for (int i = 0; i < disambigList.size(); ++i) {
            SynHit hit = disambigList.get(i);
            String id = hit.getId();
            StringBuilder queryTerms = new StringBuilder();
            try (TokenStream stemmer = ContextUtils.getStemmingStream(context);){
                CharTermAttribute cta = (CharTermAttribute)stemmer.addAttribute(CharTermAttribute.class);
                while (stemmer.incrementToken()) {
                    queryTerms.append(cta.toString());
                    queryTerms.append(" ");
                }
            }
            queryTerms.deleteCharAt(queryTerms.length() - 1);
            BooleanQuery q = this.makeSeparateQuery(id, queryTerms.toString());
            TopDocs foundDocs = this.searcher.search((Query)q, disambigList.size());
            double semScore = foundDocs.scoreDocs.length > 0 ? (double)foundDocs.scoreDocs[0].score : 0.0;
            ScoreDoc[] scoredDocs = foundDocs.scoreDocs;
            for (int j = 0; scoredDocs.length > 0 && j < 1; ++j) {
                Document d = this.searcher.doc(scoredDocs[j].doc);
                String matchedContext = d.getField("indexed_context").stringValue();
                Jaccard jac = new Jaccard();
                System.out.println(jac.explainScore(context, matchedContext));
            }
            hit.setContextualScore(semScore);
            LOGGER.debug("doSeparateDisambiguation() - next hit: " + hit);
            LOGGER.debug("doSeparateDisambiguation() - semantic score is: " + semScore);
            LOGGER.debug("doSeaprateDisambiguation() - semantic score is: " + semScore);
        }
        for (SynHit hit : disambigList) {
            hit.setCompareType(SynHit.CompareType.SEMSCORE);
        }
        Collections.sort(disambigList);
        SynHit bestHit = disambigList.get(0);
        if (bestHit.getContextualScore() >= minContextScore) {
            return bestHit;
        }
        return null;
    }

    public BooleanQuery makeSeparateQuery(String id, String context) throws IOException {
        TermQuery idQuery = new TermQuery(new Term("indexed_id", id));
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.add((Query)idQuery, BooleanClause.Occur.MUST);
        try (TokenStream ts = ContextUtils.getStemmingStream(context);){
            CharTermAttribute cta = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            while (ts.incrementToken()) {
                query.add((Query)new TermQuery(new Term("indexed_context", cta.toString())), BooleanClause.Occur.SHOULD);
            }
        }
        return query.build();
    }

    public IndexSearcher getSemanticIndexSearcher() {
        return this.searcher;
    }
}

