/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.disambig;

import de.julielab.gene.candidateretrieval.GeneRecordHit;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneLocation;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.scoring.JaroWinklerScorer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.utils.StringUtils;

public class DypsisMapLocationDisambiguator {
    private static final Logger log = LoggerFactory.getLogger(DypsisMapLocationDisambiguator.class);

    public static void disambiguateByMapLocations(GeneDocument document, Parameters parameters) {
        Set chromosomeLocations;
        if (parameters.getBoolean("disambiguate_by_map_location", false) && !(chromosomeLocations = document.findChromosomeLocations()).isEmpty()) {
            JaroWinklerScorer scorer = new JaroWinklerScorer();
            for (GeneMention gm : document.getNonRejectedGenesIterable()) {
                double bestMatchScore = 0.0;
                HashMap<SynHit, Double> candidates2locScore = new HashMap<SynHit, Double>();
                Map tax2finalRankedCandidates = gm.getMentionMappingResult().tax2finalRankedCandidates;
                for (String taxId : tax2finalRankedCandidates.keySet()) {
                    List candidates4tax = (List)tax2finalRankedCandidates.get(taxId);
                    if (candidates4tax.size() <= 1) continue;
                    Map geneLoc2SynHit = null;
                    try {
                        boolean wascorrectbutisntanymore;
                        geneLoc2SynHit = candidates4tax.stream().map(GeneRecordHit.class::cast).filter(gr -> !StringUtils.isBlank((CharSequence)gr.getMapLocation()) || !StringUtils.isBlank((CharSequence)gr.getChromosome())).collect(Collectors.toMap(gr -> {
                            GeneLocation loc;
                            if (!StringUtils.isBlank((CharSequence)gr.getMapLocation())) {
                                loc = new GeneLocation(gr.getMapLocation().replace(" ", ""));
                            } else {
                                loc = new GeneLocation();
                                loc.setChromosome(gr.getChromosome());
                            }
                            return loc;
                        }, Function.identity()));
                        Set candidateChromosomes = geneLoc2SynHit.keySet().stream().map(GeneLocation::getChromosome).collect(Collectors.toSet());
                        Set filteredChromosomeLocations = chromosomeLocations.stream().filter(cl -> candidateChromosomes.contains(cl.getChromosome())).collect(Collectors.toSet());
                        if (!filteredChromosomeLocations.isEmpty()) {
                            for (GeneLocation filteredChromosomeLoc : filteredChromosomeLocations) {
                                for (GeneLocation geneLoc : geneLoc2SynHit.keySet()) {
                                    double matchScore = scorer.getScore(filteredChromosomeLoc.toString(), geneLoc.toString());
                                    candidates2locScore.put((SynHit)geneLoc2SynHit.get(geneLoc), matchScore);
                                }
                            }
                        }
                        boolean wascorrect = gm.getAllGoldIdAsSet().contains(candidates4tax.get(0));
                        candidates4tax.sort(Comparator.comparingDouble(sh -> candidates2locScore.getOrDefault(sh, 0.0)).reversed());
                        boolean isnowcorrect = gm.getAllGoldIdAsSet().contains(candidates4tax.get(0));
                        boolean bl = wascorrectbutisntanymore = wascorrect && !isnowcorrect;
                        if (wascorrectbutisntanymore) {
                            System.out.println("hier");
                        }
                        if (!isnowcorrect) continue;
                        System.out.println("isnowcorrect");
                    }
                    catch (Exception e) {
                        log.warn("Could not parse chromosomal locations in at least one of {}", (Object)candidates4tax.stream().map(GeneRecordHit.class::cast).map(GeneRecordHit::getMapLocation).toArray(), (Object)e);
                    }
                }
            }
        }
    }
}

