/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.disambig;

import com.google.common.cache.LoadingCache;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.services.CacheService;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.ContextItemsCacheKey;
import de.julielab.genemapper.disambig.SemanticIndex;
import de.julielab.genemapper.utils.GeneMapperException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.cache.Cache;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextItemsIndex
implements SemanticIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextItemsIndex.class);
    private static final ConcurrentHashMap<String, LoadingCache<ContextItemsCacheKey, Collection<String>>> caches = new ConcurrentHashMap();
    public IndexSearcher searcher;
    private final Cache<ContextItemsCacheKey, Collection<String>> geneContextCache;

    @Inject
    public ContextItemsIndex(CacheService cacheService, Configuration configuration) throws GeneMapperException {
        String indexDirPath = configuration.getProperty("context_items_index");
        if (indexDirPath == null) {
            throw new GeneMapperException("context items index not specified in configuration file (critical).");
        }
        try {
            File indexDir = new File(indexDirPath);
            DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((Path)indexDir.toPath()));
            this.searcher = new IndexSearcher((IndexReader)reader);
            LOGGER.info("using " + indexDir.getAbsolutePath() + " as synonym disambiguation index with " + this.searcher.getIndexReader().numDocs() + " gene entries");
            String indexPath = indexDir.getCanonicalPath();
            boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
            this.geneContextCache = cacheService.getCacheManager().getCache("context-items-cache");
        }
        catch (IOException e) {
            throw new GeneMapperException(e);
        }
    }

    public Collection<String> getContextItems(ContextItemsCacheKey key) throws ExecutionException {
        return (Collection)this.geneContextCache.get((Object)key);
    }

    public Collection<String> getContextItems(String geneId, String field) throws ExecutionException {
        return this.getContextItems(new ContextItemsCacheKey(geneId, field));
    }

    private Map<String, String> getContextItemsFromIndex(Collection<String> geneIds, String field) throws IOException {
        HashMap<String, String> id2item = new HashMap<String, String>();
        Stream<TermQuery> idTermQueries = geneIds.stream().map(id -> new TermQuery(new Term("indexed_id")));
        BooleanQuery.Builder fb = new BooleanQuery.Builder();
        idTermQueries.forEach(q -> fb.add((Query)q, BooleanClause.Occur.SHOULD));
        BooleanQuery.Builder qb = new BooleanQuery.Builder();
        qb.add((Query)fb.build(), BooleanClause.Occur.FILTER);
        TopScoreDocCollector resultsCollector = TopScoreDocCollector.create((int)geneIds.size(), (int)geneIds.size());
        this.searcher.search((Query)qb.build(), (Collector)resultsCollector);
        TopDocs result = resultsCollector.topDocs();
        if (result.totalHits.value > 0L) {
            ArrayList results = new ArrayList();
            for (ScoreDoc scoreDoc : result.scoreDocs) {
                Document doc = this.searcher.doc(scoreDoc.doc);
                IndexableField[] fields = doc.getFields(field);
                if (fields.length > 1) {
                    throw new IllegalArgumentException("There are multiple fields with name " + field + " which is not supported.");
                }
                String id2 = doc.getField("indexed_id").stringValue();
                String contextItem = fields[0].stringValue();
                id2item.put(id2, contextItem);
            }
            return id2item;
        }
        return Collections.emptyMap();
    }

    private Collection<String> getContextItemsFromIndex(ContextItemsCacheKey key) throws IOException {
        TermQuery termQuery = new TermQuery(new Term("indexed_id", key.getGeneId()));
        BooleanQuery filterQuery = new BooleanQuery.Builder().add(new BooleanClause((Query)termQuery, BooleanClause.Occur.FILTER)).build();
        TopDocs result = this.searcher.search((Query)filterQuery, 1);
        if (result.totalHits.value > 0L) {
            ArrayList<String> results = new ArrayList<String>();
            for (ScoreDoc scoreDoc : result.scoreDocs) {
                IndexableField[] fields;
                Document doc = this.searcher.doc(scoreDoc.doc);
                for (IndexableField f : fields = doc.getFields(key.getIndexField())) {
                    results.add(f.stringValue());
                }
            }
            return results;
        }
        return Collections.emptyList();
    }

    public Map<String, Float> getSynonymGeneRifScoresForTaxIds(SynHit synHit, Set<String> taxonomyIds) throws IOException {
        List idsForTaxIds = IntStream.range(0, synHit.getIds().size()).filter(i -> taxonomyIds.contains(synHit.getTaxIds().get(i))).mapToObj(i -> (String)synHit.getIds().get(i)).collect(Collectors.toList());
        Stream<TermQuery> termQueryStream = idsForTaxIds.stream().map(id -> new TermQuery(new Term("indexed_id", id)));
        BooleanQuery.Builder filterQueryBuilder = new BooleanQuery.Builder();
        termQueryStream.forEach(q -> filterQueryBuilder.add(new BooleanClause((Query)q, BooleanClause.Occur.SHOULD)));
        BooleanQuery filterQuery = filterQueryBuilder.build();
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(new BooleanClause((Query)filterQuery, BooleanClause.Occur.FILTER));
        PhraseQuery.Builder synonymQueryBuilder = new PhraseQuery.Builder().setSlop(0);
        Stream.of(synHit.getSynonym()).flatMap(s -> Stream.of(s.split("\\s+"))).forEach(t -> synonymQueryBuilder.add(new Term("generif", t)));
        PhraseQuery synonymPhraseQuery = synonymQueryBuilder.build();
        queryBuilder.add(new BooleanClause((Query)synonymPhraseQuery, BooleanClause.Occur.MUST));
        BooleanQuery query = queryBuilder.build();
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (String geneId : idsForTaxIds) {
            map.put(geneId, Float.valueOf(0.0f));
        }
        TopScoreDocCollector resultsCollector = TopScoreDocCollector.create((int)idsForTaxIds.size(), (int)idsForTaxIds.size());
        this.searcher.search((Query)query, (Collector)resultsCollector);
        TopDocs topDocs = resultsCollector.topDocs();
        if (topDocs.totalHits.value > 0L) {
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document doc = this.searcher.doc(scoreDoc.doc);
                String id2 = doc.get("indexed_id");
                float score = scoreDoc.score;
                map.put(id2, Float.valueOf(score));
            }
        }
        return map;
    }

    public Map<String, Pair<Double, String>> getIntraTaxAmbiguousContextItemScores(SynHit synHit, BooleanQuery contextQuery, String semanticItemFieldName, boolean returnContextItemValue) throws IOException {
        return this.getContextItemScores(Arrays.asList(synHit.getTaxonomySpecificIds()), contextQuery, semanticItemFieldName, false);
    }

    public Map<String, Pair<Double, String>> getContextItemScores(Collection<String> ids, BooleanQuery contextQuery, String semanticItemFieldName, boolean returnContextItemValue) throws IOException {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyMap();
        }
        Stream<TermQuery> termQueryStream = ids.stream().map(id -> new TermQuery(new Term("indexed_id", id)));
        BooleanQuery.Builder filterQueryBuilder = new BooleanQuery.Builder();
        termQueryStream.forEach(q -> filterQueryBuilder.add(new BooleanClause((Query)q, BooleanClause.Occur.SHOULD)));
        BooleanQuery filterQuery = filterQueryBuilder.build();
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(new BooleanClause((Query)filterQuery, BooleanClause.Occur.FILTER));
        queryBuilder.add((Query)contextQuery, BooleanClause.Occur.MUST);
        BooleanQuery query = queryBuilder.build();
        HashMap<String, Pair<Double, String>> map = new HashMap<String, Pair<Double, String>>();
        for (String geneId : ids) {
            map.put(geneId, (Pair<Double, String>)new ImmutablePair((Object)0.0, null));
        }
        TopScoreDocCollector resultsCollector = TopScoreDocCollector.create((int)ids.size(), (int)ids.size());
        this.searcher.search((Query)query, (Collector)resultsCollector);
        TopDocs topDocs = resultsCollector.topDocs();
        if (topDocs.totalHits.value > 0L) {
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document doc = this.searcher.doc(scoreDoc.doc);
                String id2 = doc.get("indexed_id");
                String contextItem = null;
                if (returnContextItemValue) {
                    contextItem = doc.getField(semanticItemFieldName).stringValue();
                }
                double score = scoreDoc.score;
                map.put(id2, (Pair<Double, String>)new ImmutablePair((Object)score, (Object)contextItem));
            }
        }
        return map;
    }

    public IndexSearcher getContextItemsSearcher() {
        return this.searcher;
    }
}

