/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.composites;

import de.julielab.genemapper.composites.CompositePatternResolver;
import de.julielab.genemapper.composites.CompositeToken;
import de.julielab.genemapper.composites.ResolvedCompositeGeneName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPartedRangePatternResolver
extends CompositePatternResolver {
    private static final Logger log = LoggerFactory.getLogger(TwoPartedRangePatternResolver.class);
    private final Pattern taggingPattern = Pattern.compile("(A+)(S+)(N)(O+)?(S+)");
    private final Pattern numberPattern = Pattern.compile("[0-9]+");

    @Override
    public String isEligible(String geneName) {
        Matcher numberMatcher = this.numberPattern.matcher(geneName);
        numberMatcher.reset(geneName);
        if (!numberMatcher.find()) {
            return null;
        }
        if (!numberMatcher.find()) {
            return null;
        }
        numberMatcher.reset(geneName.substring(geneName.length() - 1));
        if (!numberMatcher.find()) {
            return null;
        }
        if (geneName.contains("-") || geneName.contains(" to ")) {
            return this.getName();
        }
        return null;
    }

    @Override
    public String matches(String tagging) {
        return this.taggingPattern.matcher(tagging).matches() ? this.getName() : null;
    }

    @Override
    public List<ResolvedCompositeGeneName> resolve(String originalMention, Pair<List<CompositeToken>, String> tokenizedMentionAndTagging) {
        List rightAntecedent;
        Matcher taggingPatternMatcher = this.taggingPattern.matcher((CharSequence)tokenizedMentionAndTagging.getRight());
        boolean matches = taggingPatternMatcher.matches();
        assert (matches && this.isEligible(originalMention) != null) : "Passed a pattern for resolution that does not match a case handled by this class. Use 'matches()' first to check the eligibility of the entity text.";
        String antecedentTagging = taggingPatternMatcher.group(1);
        String rangeIndicatorToken = ((CompositeToken)((List)tokenizedMentionAndTagging.getLeft()).get(taggingPatternMatcher.start(3))).getText();
        if (!rangeIndicatorToken.equals("-") && !rangeIndicatorToken.equals("to")) {
            return Collections.emptyList();
        }
        String rightAntecedentTagging = taggingPatternMatcher.group(4);
        List tokens = (List)tokenizedMentionAndTagging.getLeft();
        int nonRangeSpecifierLength = taggingPatternMatcher.end(2) - taggingPatternMatcher.start(2) - 1;
        List antecedent = IntStream.range(0, antecedentTagging.length() + nonRangeSpecifierLength).mapToObj(i -> (CompositeToken)tokens.get(i)).collect(Collectors.toList());
        int rightNonRangeSpecifierLength = taggingPatternMatcher.end(5) - taggingPatternMatcher.start(5) - 1;
        List list = rightAntecedent = rightAntecedentTagging != null ? IntStream.range(taggingPatternMatcher.start(4), taggingPatternMatcher.start(4) + rightAntecedentTagging.length() + rightNonRangeSpecifierLength).mapToObj(i -> (CompositeToken)tokens.get(i)).collect(Collectors.toList()) : antecedent;
        if (!rightAntecedent.stream().map(CompositeToken::getText).collect(Collectors.joining()).equals(antecedent.stream().map(CompositeToken::getText).collect(Collectors.joining()))) {
            return Collections.emptyList();
        }
        if (rightAntecedent.equals(antecedent) && taggingPatternMatcher.group(2).length() != taggingPatternMatcher.group(5).length()) {
            return Collections.emptyList();
        }
        String firstNumberPart = ((CompositeToken)tokens.get(taggingPatternMatcher.end(2) - 1)).getText();
        String secondNumberPart = ((CompositeToken)tokens.get(taggingPatternMatcher.end(5) - 1)).getText();
        if (firstNumberPart.startsWith("0") || secondNumberPart.startsWith("0")) {
            return Collections.emptyList();
        }
        try {
            int lower = Integer.valueOf(firstNumberPart);
            int upper = Integer.parseInt(secondNumberPart);
            if (lower > upper) {
                return Collections.emptyList();
            }
            if (upper - lower > 20) {
                log.debug("Trying to resolve a range pattern for the gene name '{}'. That results in {} genes. Tagging is {}. This is too much, skipping resolution.", new Object[]{originalMention, upper - lower, tokenizedMentionAndTagging.getRight()});
                return Collections.emptyList();
            }
            int[] numbers = new int[]{lower, upper};
            Arrays.sort(numbers);
            int begin = ((CompositeToken)tokens.get(0)).getBegin();
            int end = ((CompositeToken)tokens.get(tokens.size() - 1)).getEnd();
            boolean leftWs = ((CompositeToken)tokens.get(0)).isLeftWs();
            boolean rightWs = ((CompositeToken)tokens.get(0)).isRightWs();
            ArrayList<ResolvedCompositeGeneName> resolvedRangeMentions = new ArrayList<ResolvedCompositeGeneName>();
            for (int i2 = numbers[0]; i2 <= numbers[1]; ++i2) {
                ResolvedCompositeGeneName assembledGeneName = new ResolvedCompositeGeneName(this.getClass());
                assembledGeneName.addAll(antecedent);
                assembledGeneName.add(new CompositeToken(String.valueOf(i2), begin, end, leftWs, rightWs));
                resolvedRangeMentions.add(assembledGeneName);
            }
            return resolvedRangeMentions;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Number extraction in range pattern turned up with a non-number result. Original gene mention text: '" + originalMention + "'. First extracted number: '" + firstNumberPart + "', second extracted number: '" + secondNumberPart + "'.", e);
        }
    }
}

