/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.composites;

import de.julielab.genemapper.composites.CompositePatternResolver;
import de.julielab.genemapper.composites.CompositeToken;
import de.julielab.genemapper.composites.ResolvedCompositeGeneName;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;

public class EmbeddedAcronymPatternResolver
extends CompositePatternResolver {
    private final Pattern p = Pattern.compile("([AS]+)(B[^EF]*[EF])(.*)");
    private final Pattern enumP = Pattern.compile("[^JBEF]+");

    @Override
    public String isEligible(String geneName) {
        return geneName.contains("(") && geneName.contains(")") ? this.getName() : null;
    }

    @Override
    public String matches(String tagging) {
        Matcher m = this.p.matcher(tagging);
        return m.matches() ? this.getName() : null;
    }

    @Override
    public List<ResolvedCompositeGeneName> resolve(String originalMention, Pair<List<CompositeToken>, String> tokenizedMentionAndTagging) {
        Matcher m = this.p.matcher((CharSequence)tokenizedMentionAndTagging.getRight());
        boolean matches = m.matches();
        assert (matches && this.isEligible(originalMention) != null) : "Passed a pattern for resolution that does not match a case handled by this class. Use 'matches()' first to check the eligibility of the entity text.";
        String antecedentTagging = m.group(1);
        String acronymTagging = m.group(2);
        List tokens = (List)tokenizedMentionAndTagging.getLeft();
        List antecedent = IntStream.range(m.start(1), m.end(1)).mapToObj(i -> (CompositeToken)tokens.get(i)).collect(Collectors.toList());
        ArrayList acronyms = new ArrayList();
        Matcher enumMatcher = this.enumP.matcher(acronymTagging);
        while (enumMatcher.find()) {
            List acronym = IntStream.range(m.start(2) + enumMatcher.start(), m.start(2) + enumMatcher.end()).mapToObj(i -> (CompositeToken)tokens.get(i)).collect(Collectors.toList());
            acronyms.add(acronym);
        }
        List rest = IntStream.range(m.start(3), m.end(3)).mapToObj(i -> (CompositeToken)tokens.get(i)).collect(Collectors.toList());
        ArrayList<ResolvedCompositeGeneName> resolvedEnumerationMentions = new ArrayList<ResolvedCompositeGeneName>(acronyms.size() + 1);
        ResolvedCompositeGeneName assembledLongForm = new ResolvedCompositeGeneName(this.getClass());
        assembledLongForm.addAll(antecedent);
        assembledLongForm.addAll(rest);
        resolvedEnumerationMentions.add(assembledLongForm);
        for (List list : acronyms) {
            ResolvedCompositeGeneName assembledShortForm = new ResolvedCompositeGeneName(this.getClass());
            ((CompositeToken)list.get(list.size() - 1)).setRightWs(true);
            assembledShortForm.addAll(list);
            assembledShortForm.addAll(rest);
            assembledLongForm.addAcronymForm(assembledShortForm);
        }
        return resolvedEnumerationMentions;
    }
}

