/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.apps;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.disambig.wikipedia.WikipediaEntity;
import de.julielab.genemapper.disambig.wikipedia.WikipediaIndexReader;
import de.julielab.genemapper.ioc.GeneMappingModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;

public class InteractiveWikipediaPageRetrieval {
    public static void main(String[] args) throws Exception {
        String propertiesFile = "../built-resources/corpora/genemapper_interactive_candidate_finder.properties";
        Configuration configuration = new Configuration(new File(propertiesFile));
        Injector injector = Guice.createInjector((Module[])new Module[]{new GeneMappingModule(configuration)});
        WikipediaIndexReader wikipediaReader = (WikipediaIndexReader)injector.getInstance(WikipediaIndexReader.class);
        TermNormalizer normalizer = (TermNormalizer)injector.getInstance(TermNormalizer.class);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        block0: while (true) {
            System.out.println("Enter term:");
            String input = br.readLine();
            String normalizedTerm = normalizer.normalize(input);
            System.out.println("Normalized term: " + normalizedTerm);
            GeneMention geneMention = new GeneMention(input);
            geneMention.setTaxonomyIds(List.of("9606"));
            geneMention.setNormalizer(normalizer);
            List<WikipediaEntity> wikipediaEntities = wikipediaReader.searchWikipedia(geneMention.getNormalizedText());
            Iterator<WikipediaEntity> iterator = wikipediaEntities.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                WikipediaEntity wikiEntity = iterator.next();
                System.out.println("Title: " + wikiEntity.getTitle());
                System.out.println("    Score: " + wikiEntity.getScore());
                System.out.println("    Entities: " + wikiEntity.getEntities());
                System.out.println("    Mentioned Wikipedia Entities: " + wikiEntity.getMentionedWikipediaEntities());
                System.out.println("    Page contains the title with an unspecified article: " + wikiEntity.isTitleHasUnspecificArticle());
                System.out.println("    Does the page contain the input term in plural: " + wikiEntity.isTitleMentionedInPlural());
            }
            break;
        }
    }
}

