/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.apps;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.gene.candidateretrieval.GeneRecordHit;
import de.julielab.gene.candidateretrieval.LuceneCandidateRetrieval;
import de.julielab.gene.candidateretrieval.ioc.IndexModule;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.ioc.BaseModule;
import de.julielab.geneexpbase.ioc.ServicesShutdownHub;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.genemapper.utils.GeneMapperInitializationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class InteractiveCandidateFinder {
    public static void main(String[] args) throws IOException, GeneMapperException, GeneMapperInitializationException {
        String propertiesFile = "../built-resources/corpora/genemapper_interactive_candidate_finder.properties";
        Configuration configuration = new Configuration(new File(propertiesFile));
        Injector injector = Guice.createInjector((Module[])new Module[]{new BaseModule((de.julielab.geneexpbase.configuration.Configuration)configuration), new IndexModule((de.julielab.geneexpbase.configuration.Configuration)configuration)});
        CandidateRetrieval luceneCandidateRetrieval = (CandidateRetrieval)injector.getInstance(CandidateRetrieval.class);
        TermNormalizer normalizer = (TermNormalizer)injector.getInstance(TermNormalizer.class);
        InteractiveCandidateFinder.startInteractiveQueries(luceneCandidateRetrieval, normalizer);
        ((ServicesShutdownHub)injector.getInstance(ServicesShutdownHub.class)).shutdown();
    }

    private static void printCandidatesForInput(String input, CandidateRetrieval luceneCandidateRetrieval, TermNormalizer normalizer) {
        InteractiveCandidateFinder.printCandidates(luceneCandidateRetrieval, normalizer, input);
    }

    private static void startInteractiveQueries(CandidateRetrieval luceneCandidateRetrieval, TermNormalizer normalizer) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        while (true) {
            System.out.println("Enter term:");
            String input = br.readLine();
            InteractiveCandidateFinder.printCandidates(luceneCandidateRetrieval, normalizer, input);
        }
    }

    private static void printCandidates(CandidateRetrieval luceneCandidateRetrieval, TermNormalizer normalizer, String input) {
        String normalizedTerm = normalizer.normalize(input);
        System.out.println("Normalized term: " + normalizedTerm);
        GeneMention geneMention = new GeneMention(input);
        geneMention.setTaxonomyIds(List.of("3055"));
        geneMention.setNormalizer(normalizer);
        List candidates = luceneCandidateRetrieval.getCandidates(geneMention, Set.of("5726760", "5728451"), (Collection)geneMention.getTaxonomyIds(), LuceneCandidateRetrieval.GENE_RECORDS_CNF);
        for (SynHit hit : candidates) {
            System.out.println("Official symbols: " + ((GeneRecordHit)hit).getSymbol());
            System.out.println("    full name: " + Arrays.toString(((GeneRecordHit)hit).getFullNames()));
            System.out.println("    synonym match:" + hit.getSynonym() + ", mention score: " + ((GeneRecordHit)hit).getSynonymSimilarityScore() + ", priority: " + hit.getSynonymPriorities());
            System.out.println("    gene IDs: " + hit.getIds());
            System.out.println("    tax IDs:  " + hit.getTaxIds());
            List originalNamesIndexRecords = luceneCandidateRetrieval.getOriginalNamesIndexRecords((Collection)hit.getIds());
            if (originalNamesIndexRecords.isEmpty()) continue;
            GeneRecordHit originalRecord = (GeneRecordHit)originalNamesIndexRecords.get(0);
            System.out.println("    original symbol: " + originalRecord.getSymbol());
            System.out.println("    original synonyms: " + String.join((CharSequence)", ", originalRecord.getSynonyms()));
        }
    }
}

