/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.apps;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.julielab.gene.candidateretrieval.CandidateRetrieval;
import de.julielab.gene.candidateretrieval.LuceneCandidateRetrieval;
import de.julielab.gene.candidateretrieval.ioc.IndexModule;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.ioc.BaseModule;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class GeneNameToAmbiguousIdsMapper {
    public static void main(String[] args) throws IOException, GeneMapperException {
        if (args.length != 3) {
            System.err.println("Usage: " + GeneNameToAmbiguousIdsMapper.class.getSimpleName() + " <configuration file> <gene name file> <taxId>");
        } else {
            String propertiesFile = args[0];
            String geneNameFile = args[1];
            String taxId = args[2];
            Configuration configuration = new Configuration(new File(propertiesFile));
            Injector injector = Guice.createInjector((Module[])new Module[]{new BaseModule((de.julielab.geneexpbase.configuration.Configuration)configuration), new IndexModule((de.julielab.geneexpbase.configuration.Configuration)configuration)});
            CandidateRetrieval luceneCandidateRetrieval = (CandidateRetrieval)injector.getInstance(CandidateRetrieval.class);
            try (BufferedReader br = FileUtilities.getReaderFromFile((File)new File(geneNameFile));){
                String input;
                while ((input = br.readLine()) != null) {
                    System.out.print(input + "\t");
                    GeneMention geneMention = new GeneMention(input);
                    geneMention.setNormalizer((TermNormalizer)injector.getInstance(TermNormalizer.class));
                    List candidates = luceneCandidateRetrieval.getCandidates(geneMention, Collections.emptySet(), Set.of(taxId), LuceneCandidateRetrieval.GENE_RECORDS_CNF);
                    if (candidates.isEmpty()) {
                        System.out.println("<no candidates>");
                        continue;
                    }
                    if (((SynHit)candidates.get(0)).isExactMatch()) {
                        SynHit candidate = (SynHit)candidates.get(0);
                        if (candidate != null) {
                            System.out.println(candidate.getId());
                            continue;
                        }
                        System.out.println("<no candidate for tax ID " + taxId + ">");
                        continue;
                    }
                    System.out.println("<no exact match candidate for tax ID " + taxId + ">");
                }
            }
        }
    }
}

