/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper;

import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.genemapper.utils.GeneMapperRuntimeException;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikipediaCategoryManager {
    private static final Logger log = LoggerFactory.getLogger(WikipediaCategoryManager.class);
    private static final int HASHMAP_SIZE = 1800000;
    private Map<String, List<String>> categoryGraph;
    private Map<String, Integer> dist;
    private Map<String, String> prev;

    public WikipediaCategoryManager(String pathname, boolean reverse) {
        File serializedFile = new File(pathname.replace(".tsv.gz", (reverse ? "_reversed" : "") + ".bin"));
        if (serializedFile.exists()) {
            log.info("Reading Wikipedia category graph from cached binary file {}", (Object)serializedFile);
            try (ObjectInputStream is = new ObjectInputStream(FileUtilities.getInputStreamFromFile((File)serializedFile));){
                this.categoryGraph = (Map)is.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                log.warn("Could not deserialize file {}. Reading original data from {} and re-writing the cache file.", (Object)serializedFile, (Object)pathname);
            }
        }
        if (this.categoryGraph == null) {
            log.info("Reading category tree from {}", (Object)pathname);
            try (BufferedReader br = FileUtilities.getReaderFromFile((File)new File(pathname));
                 ObjectOutputStream os = new ObjectOutputStream(FileUtilities.getOutputStreamToFile((File)serializedFile));){
                this.categoryGraph = br.lines().skip(1L).map(line -> line.split("\\t")).peek(s -> {
                    if (((String[])s).length != 2) {
                        log.warn("Line does not have exactly two fields and is omitted: {}", (Object)Arrays.toString(s));
                    } else if (!s[0].equals(s[0].trim()) || !s[1].equals(s[1].trim())) {
                        throw new GeneMapperRuntimeException("Dangling space: " + Arrays.toString(s));
                    }
                }).filter(s -> ((String[])s).length == 2).filter(s -> !s[1].startsWith("#")).collect(Collectors.toMap(s -> ((String)(reverse ? "Category:" + s[1] : s[0])).intern(), s -> {
                    ArrayList<String> l = new ArrayList<String>();
                    l.add(((String)(reverse ? s[0] : "Category:" + s[1])).intern());
                    return l;
                }, (l1, l2) -> {
                    l1.addAll(l2);
                    return l1;
                }));
                log.info("Writing binary category file to {} for later use.", (Object)serializedFile);
                os.writeObject(this.categoryGraph);
            }
            catch (IOException e) {
                throw new GeneMapperRuntimeException(e);
            }
        }
        log.info("Done reading categories for {} pages and subcategories.", (Object)this.categoryGraph.size());
    }

    public static void main(String[] args) throws IOException, GeneMapperException {
        WikipediaCategoryManager service = new WikipediaCategoryManager("../built-resources/pipelines/wikipedia_category_tree.tsv.gz", true);
        service.buildDijkstraTree("Category:Biology");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        while (true) {
            System.out.println("Enter term:");
            String input = br.readLine();
            System.out.println(service.getShortestPathToDijkstraTreeRoot(input, Set.of("Category:Water", "Category:Human geography")));
        }
    }

    public List<String> getShortestPathToDijkstraTreeRoot(String title, Set<String> prohibitedPathElements) {
        if (this.prev.containsKey(title)) {
            String child;
            ArrayList<String> path = new ArrayList<String>();
            String u = title;
            path.add(u);
            while ((child = this.prev.get(u)) != null) {
                if (prohibitedPathElements != null && prohibitedPathElements.contains(child)) {
                    return Collections.emptyList();
                }
                path.add(child);
                u = child;
            }
            return path;
        }
        return Collections.emptyList();
    }

    public void buildDijkstraTree(String root) {
        String u;
        this.dist = new HashMap<String, Integer>(1800000);
        this.prev = new HashMap<String, String>(1800000);
        this.dist.put(root, 0);
        TreeSet<String> q = new TreeSet<String>(Comparator.comparingInt(v -> this.dist.getOrDefault(v, Integer.MAX_VALUE)).thenComparing(Function.identity()));
        Stream.concat(this.categoryGraph.values().stream().flatMap(Collection::stream), this.categoryGraph.keySet().stream()).distinct().forEach(q::add);
        while (!q.isEmpty() && this.dist.containsKey(u = q.pollFirst())) {
            for (String v2 : this.categoryGraph.getOrDefault(u, Collections.emptyList())) {
                int alt = this.dist.get(u) + 1;
                if (alt >= this.dist.getOrDefault(v2, Integer.MAX_VALUE)) continue;
                boolean remove = q.remove(v2);
                this.dist.put(v2, alt);
                this.prev.put(v2, u);
                if (!remove) continue;
                q.add(v2);
            }
        }
    }

    public List<String> getCategoriesForPage(String pageTitle) {
        return this.categoryGraph.get(pageTitle);
    }

    public List<String> getCategoriesForCategory(String categoryName) {
        return this.categoryGraph.get("Category:" + categoryName);
    }

    public List<String> getShortestPath(String title, String category) {
        HashMap<String, Integer> dist = new HashMap<String, Integer>();
        dist.put(title, 0);
        HashMap<String, String> prev = new HashMap<String, String>();
        PriorityQueue<String> q = new PriorityQueue<String>((int)this.categoryGraph.values().stream().flatMap(Collection::stream).count(), Comparator.comparingInt(v -> dist.getOrDefault(v, Integer.MAX_VALUE)));
        q.add(title);
        while (!q.isEmpty()) {
            String u = q.poll();
            if (u.equals("Category:" + category)) {
                String child;
                ArrayList<String> path = new ArrayList<String>();
                path.add(u);
                while ((child = (String)prev.get(u)) != null) {
                    path.add(child);
                    u = child;
                }
                return path;
            }
            for (String v2 : this.categoryGraph.getOrDefault(u, Collections.emptyList())) {
                int alt = (Integer)dist.get(u) + 1;
                if (alt >= dist.getOrDefault(v2, Integer.MAX_VALUE)) continue;
                dist.put(v2, alt);
                prev.put(v2, u);
                q.remove(v2);
                q.add(v2);
            }
        }
        return Collections.emptyList();
    }
}

