/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper;

import de.julielab.gene.candidateretrieval.LuceneCandidateRetrieval;
import de.julielab.geneexpbase.CandidateFilter;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.candidateretrieval.GeneCandidateRetrievalException;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.DocumentMappingResult;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import de.julielab.genemapper.Configuration;
import de.julielab.genemapper.evaluation.tools.Stats;
import de.julielab.genemapper.mappingcores.MappingCore;
import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.genemapper.utils.SynHitUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.lucene.search.BooleanQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneMapper {
    public static final String APP_NAME = "GeNo";
    public static final boolean LEGACY_INDEX_SUPPORT = true;
    private static final Logger log = LoggerFactory.getLogger(GeneMapper.class);
    public static boolean TEST_MODE = false;
    private static final CandidateFilter candidateFilter = new CandidateFilter();
    private final Configuration config;
    private MappingCore mappingCore;

    @Inject
    public GeneMapper(Configuration config, MappingCore mappingCore) {
        this.config = config;
        this.mappingCore = mappingCore;
    }

    public List<SynHit> map(String searchTerm, BooleanQuery contextQuery) throws GeneMapperException {
        GeneMention predictedMention = new GeneMention(searchTerm);
        MentionMappingResult map = this.map(predictedMention, contextQuery, null);
        return map.resultEntries;
    }

    public MentionMappingResult map(GeneMention searchTerm, BooleanQuery contextQuery, String documentContext) throws GeneMapperException {
        return this.mappingCore.map(searchTerm);
    }

    public DocumentMappingResult map(GeneDocument document) throws GeneMapperException {
        return this.mappingCore.map(document);
    }

    public ArrayList<SynHit> mapTopN(String searchTerm, int topN) throws IOException, GeneCandidateRetrievalException {
        TermNormalizer normalizer = new TermNormalizer();
        String normalizedSearchTerm = normalizer.normalize(searchTerm);
        if ((normalizedSearchTerm = TermNormalizer.removeModifiers((String)normalizedSearchTerm)).equals("")) {
            return null;
        }
        log.info("map() - searching for term: " + searchTerm + " as > " + normalizedSearchTerm + " <");
        List allHits = this.mappingCore.getCandidateRetrieval().getCandidates(normalizedSearchTerm, LuceneCandidateRetrieval.CONJUNCTION);
        ArrayList<SynHit> topNHits = new ArrayList<SynHit>();
        for (int i = 0; i < Math.min(allHits.size(), topN); ++i) {
            SynHit synHit = (SynHit)allHits.get(i);
            if (candidateFilter.filterOut(normalizedSearchTerm, synHit.getSynonym())) continue;
            topNHits.add((SynHit)allHits.get(i));
        }
        log.info("topN mapping found > " + topNHits.size() + " <  for candidate '" + searchTerm + "': " + SynHitUtils.showHitIDs(topNHits));
        return topNHits;
    }

    public MappingCore getMappingCore() {
        return this.mappingCore;
    }

    public void setMappingCore(MappingCore mappingCore) {
        this.mappingCore = mappingCore;
    }

    public MentionMappingResult map(String term, BooleanQuery contextQuery, String documentContext) throws GeneMapperException {
        return this.map(new GeneMention(term), contextQuery, documentContext);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public DocumentMappingResult map(GeneDocument document, Stats stats) throws GeneMapperException {
        return this.map(document, null, stats);
    }

    public DocumentMappingResult map(GeneDocument document, Parameters parameterMap, Stats stats) throws GeneMapperException {
        return this.mappingCore.map(document, parameterMap, stats);
    }

    public DocumentMappingResult map(GeneDocument doc, Parameters parameterMap) throws GeneMapperException {
        return this.map(doc, parameterMap, null);
    }

    public void clearLexicalRankingModel() {
        this.mappingCore.clear();
    }

    public void clearSemanticRankingModel() {
    }
}

