/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.preanalyzed;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.mapper.preanalyzed.NoopDeprecationHandler;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class PreAnalyzedMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "preanalyzed";
    private FieldType fieldTypeText;
    private FieldType fieldTypeIndexed;
    private static final JsonFactory jsonFactory = new JsonFactory();

    public PreAnalyzedMapper(String simpleName, FieldType fieldType, MappedFieldType defaultFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, FieldType fieldTypeText, FieldType fieldTypeIndexed) {
        super(simpleName, fieldType, defaultFieldType, multiFields, copyTo);
        this.fieldTypeText = fieldTypeText;
        this.fieldTypeIndexed = fieldTypeIndexed;
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.fieldType.indexOptions() != IndexOptions.NONE && (includeDefaults || this.fieldType.indexOptions() != TextFieldMapper.Defaults.FIELD_TYPE.indexOptions())) {
            builder.field("index_options", PreAnalyzedMapper.indexOptionToString((IndexOptions)this.fieldType.indexOptions()));
        }
        if (includeDefaults || this.fieldType.storeTermVectors() != TextFieldMapper.Defaults.FIELD_TYPE.storeTermVectors()) {
            builder.field("term_vector", PreAnalyzedMapper.termVectorOptionsToString((FieldType)this.fieldType));
        }
        if (includeDefaults || this.fieldType.omitNorms()) {
            builder.field("norms", !this.fieldType.omitNorms());
        }
        this.doXContentAnalyzers(builder, includeDefaults);
        if (this.fieldType().getTextSearchInfo().getSimilarity() != null) {
            builder.field("similarity", this.fieldType().getTextSearchInfo().getSimilarity().name());
        } else if (includeDefaults) {
            builder.field("similarity", "BM25");
        }
        if (includeDefaults || this.fieldType().eagerGlobalOrdinals()) {
            builder.field("eager_global_ordinals", this.fieldType().eagerGlobalOrdinals());
        }
        if (includeDefaults || this.fieldType().fielddata()) {
            builder.field("fielddata", this.fieldType().fielddata());
        }
        if (this.fieldType().fielddata() && (includeDefaults || this.fieldType().fielddataMinFrequency() != 0.0 || this.fieldType().fielddataMaxFrequency() != 2.147483647E9 || this.fieldType().fielddataMinSegmentSize() != 0)) {
            builder.startObject("fielddata_frequency_filter");
            if (includeDefaults || this.fieldType().fielddataMinFrequency() != 0.0) {
                builder.field("min", this.fieldType().fielddataMinFrequency());
            }
            if (includeDefaults || this.fieldType().fielddataMaxFrequency() != 2.147483647E9) {
                builder.field("max", this.fieldType().fielddataMaxFrequency());
            }
            if (includeDefaults || this.fieldType().fielddataMinSegmentSize() != 0) {
                builder.field("min_segment_size", this.fieldType().fielddataMinSegmentSize());
            }
            builder.endObject();
        }
    }

    public PreanalyzedFieldType fieldType() {
        return (PreanalyzedFieldType)super.fieldType();
    }

    private Tuple<PreAnalyzedStoredValue, TokenStream> parsePreAnalyzedFieldContents(XContentParser parser) {
        try {
            XContentParser.Token currentToken;
            String currentFieldName = "";
            String version = null;
            PreAnalyzedStoredValue storedValue = new PreAnalyzedStoredValue();
            PreAnalyzedTokenStream ts = null;
            while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (currentToken == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (currentToken == XContentParser.Token.VALUE_STRING) {
                    if ("v".equals(currentFieldName)) {
                        version = parser.text();
                        if ("1".equals(version)) continue;
                        throw new MapperParsingException("Version of pre-analyzed field format is \"" + version + "\" which is not supported.");
                    }
                    if ("str".equals(currentFieldName)) {
                        storedValue.value = parser.text();
                        storedValue.type = PreAnalyzedStoredValue.VALUE_TYPE.STRING;
                        continue;
                    }
                    if (!"bin".equals(currentFieldName)) continue;
                    storedValue.value = parser.binaryValue();
                    storedValue.type = PreAnalyzedStoredValue.VALUE_TYPE.BINARY;
                    continue;
                }
                if (!"tokens".equals(currentFieldName) || currentToken != XContentParser.Token.START_ARRAY) continue;
                ts = new PreAnalyzedTokenStream(parser);
            }
            if (null == version) {
                throw new MapperParsingException("No version of pre-analyzed field format has been specified for field " + this.fieldType().name());
            }
            return new Tuple((Object)storedValue, ts);
        }
        catch (IOException e) {
            throw new MapperParsingException("The input document could not be parsed as a preanalyzed field value for field " + this.fieldType().name() + ".", (Throwable)e);
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        String preAnalyzedJson = context.parser().textOrNull();
        if (null == preAnalyzedJson) {
            return;
        }
        try (JsonXContentParser parser = new JsonXContentParser(null, (DeprecationHandler)new NoopDeprecationHandler(), jsonFactory.createParser(preAnalyzedJson));){
            Field field;
            TokenStream ts;
            Tuple<PreAnalyzedStoredValue, TokenStream> valueAndTokenStream;
            try {
                valueAndTokenStream = this.parsePreAnalyzedFieldContents((XContentParser)parser);
            }
            catch (MapperParsingException e) {
                throw new MapperParsingException("Could not read preanalyzed field value of document", (Throwable)e);
            }
            if (this.fieldTypeIndexed.indexOptions() != IndexOptions.NONE && this.fieldTypeIndexed.tokenized() && (ts = (TokenStream)valueAndTokenStream.v2()) != null) {
                field = new Field(this.fieldType().name(), ts, (IndexableFieldType)this.fieldTypeIndexed);
                context.doc().add((IndexableField)field);
            }
            PreAnalyzedStoredValue storedValue = (PreAnalyzedStoredValue)valueAndTokenStream.v1();
            if (this.fieldTypeText.stored() && null != storedValue.value) {
                field = PreAnalyzedStoredValue.VALUE_TYPE.STRING == storedValue.type ? new Field(this.fieldType().name(), (CharSequence)((String)storedValue.value), (IndexableFieldType)this.fieldTypeText) : new Field(this.fieldType().name(), (BytesRef)storedValue.value, (IndexableFieldType)this.fieldTypeText);
                context.doc().add((IndexableField)field);
            }
        }
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        PreAnalyzedMapper mw = (PreAnalyzedMapper)other;
        if (!Objects.equals(mw.fieldType().getTextSearchInfo().getSimilarity(), this.fieldType().getTextSearchInfo().getSimilarity())) {
            conflicts.add("mapper [" + this.name() + "] has different [similarity] settings");
        }
    }

    private static class PreAnalyzedStoredValue {
        Object value;
        VALUE_TYPE type;

        private PreAnalyzedStoredValue() {
        }

        static enum VALUE_TYPE {
            STRING,
            BINARY;

        }
    }

    public static class PreAnalyzedTokenStream
    extends TokenStream {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private final PayloadAttribute payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        private final FlagsAttribute flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
        private XContentParser parser;
        private ArrayList<Map<String, Object>> tokenList;
        private int tokenIndex;

        PreAnalyzedTokenStream(XContentParser parser) throws IOException {
            this.parser = parser;
            this.parsePreanalyzedTokens();
            this.reset();
        }

        private void parsePreanalyzedTokens() throws NumberFormatException, IOException {
            XContentParser.Token currentToken;
            this.tokenList = new ArrayList();
            if (this.parser.currentToken() != XContentParser.Token.START_ARRAY) {
                throw new IllegalStateException("The parser is expected to point to the beginning of the array of preanalyzed tokens but the current token type was " + this.parser.currentToken());
            }
            HashMap<String, Object> tokenMap = null;
            while ((currentToken = this.parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (currentToken == XContentParser.Token.START_OBJECT) {
                    tokenMap = new HashMap<String, Object>();
                }
                this.clearAttributes();
                boolean termFound = false;
                int start = -1;
                int end = -1;
                String currentFieldName = null;
                while ((currentToken = this.parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (currentToken == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = this.parser.currentName();
                        continue;
                    }
                    if (currentToken == XContentParser.Token.VALUE_STRING) {
                        if ("t".equals(currentFieldName)) {
                            char[] tokenBuffer = this.parser.textCharacters();
                            char[] bufferCopy = new char[this.parser.textLength()];
                            System.arraycopy(tokenBuffer, this.parser.textOffset(), bufferCopy, 0, bufferCopy.length);
                            tokenMap.put("t", bufferCopy);
                            termFound = true;
                            continue;
                        }
                        if ("p".equals(currentFieldName)) {
                            byte[] byteArray = this.parser.charBuffer().toString().getBytes("UTF-8");
                            BytesRef bytesRef = new BytesRef(byteArray);
                            tokenMap.put("p", bytesRef);
                            continue;
                        }
                        if ("f".equals(currentFieldName)) {
                            tokenMap.put("f", Integer.decode(this.parser.text()));
                            continue;
                        }
                        if (!"y".equals(currentFieldName)) continue;
                        tokenMap.put("y", this.parser.text());
                        continue;
                    }
                    if (currentToken != XContentParser.Token.VALUE_NUMBER) continue;
                    if ("s".equals(currentFieldName)) {
                        start = this.parser.intValue();
                        continue;
                    }
                    if ("e".equals(currentFieldName)) {
                        end = this.parser.intValue();
                        continue;
                    }
                    if (!"i".equals(currentFieldName)) continue;
                    tokenMap.put("i", this.parser.intValue());
                }
                tokenMap.put("s", start != -1 ? start : 0);
                tokenMap.put("e", end != -1 ? end : 0);
                if (!termFound) {
                    throw new IllegalArgumentException("There is at least one token object in the pre-analyzed field value where no actual term string is specified.");
                }
                this.tokenList.add(tokenMap);
            }
        }

        public final boolean incrementToken() throws IOException {
            if (this.tokenIndex < this.tokenList.size()) {
                Map<String, Object> t = this.tokenList.get(this.tokenIndex);
                char[] termChars = (char[])t.get("t");
                BytesRef payload = (BytesRef)t.get("p");
                Integer flags = (Integer)t.get("f");
                String type = (String)t.get("y");
                Integer start = (Integer)t.get("s");
                Integer end = (Integer)t.get("e");
                Integer posInc = (Integer)t.get("i");
                try {
                    this.clearAttributes();
                    if (null != termChars) {
                        this.termAtt.copyBuffer(termChars, 0, termChars.length);
                    }
                    if (null != payload) {
                        this.payloadAtt.setPayload(payload);
                    }
                    if (null != flags) {
                        this.flagsAtt.setFlags(flags.intValue());
                    }
                    if (null != type) {
                        this.typeAtt.setType(type);
                    }
                    if (null != posInc) {
                        this.posIncrAtt.setPositionIncrement(posInc.intValue());
                    }
                    if (null != start && null != end && -1 != start && -1 != end) {
                        this.offsetAtt.setOffset(start.intValue(), end.intValue());
                        ++this.tokenIndex;
                        return true;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception occurred at token term: " + new String(termChars) + ", start: " + start + ", end: " + end + ", positionIncrement: " + posInc, e);
                }
            }
            return false;
        }

        public void reset() throws IOException {
            this.tokenIndex = 0;
        }
    }

    public static final class PreanalyzedFieldType
    extends StringFieldType {
        private TextFieldMapper.TextFieldType delegateType;

        public PreanalyzedFieldType(TextFieldMapper.TextFieldType delegateType) {
            super(delegateType.name(), delegateType.isSearchable(), delegateType.hasDocValues(), delegateType.getTextSearchInfo(), delegateType.meta());
            this.delegateType = new TextFieldMapper.TextFieldType(delegateType.name());
        }

        public PreanalyzedFieldType(PreanalyzedFieldType ref) {
            super(ref.delegateType.name(), ref.delegateType.isSearchable(), ref.delegateType.hasDocValues(), ref.delegateType.getTextSearchInfo(), ref.delegateType.meta());
            this.delegateType = new TextFieldMapper.TextFieldType(ref.delegateType.name());
        }

        public PreanalyzedFieldType clone() {
            return new PreanalyzedFieldType(this);
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            PreanalyzedFieldType that = (PreanalyzedFieldType)((Object)o);
            return that.delegateType.equals(this.delegateType);
        }

        public int hashCode() {
            return this.delegateType.hashCode();
        }

        public boolean fielddata() {
            return this.delegateType.fielddata();
        }

        public void setFielddata(boolean fielddata) {
            this.delegateType.setFielddata(fielddata);
        }

        public double fielddataMinFrequency() {
            return this.delegateType.fielddataMinFrequency();
        }

        public void setFielddataMinFrequency(double fielddataMinFrequency) {
            this.delegateType.setFielddataMinFrequency(fielddataMinFrequency);
        }

        public double fielddataMaxFrequency() {
            return this.delegateType.fielddataMaxFrequency();
        }

        public void setFielddataMaxFrequency(double fielddataMaxFrequency) {
            this.delegateType.setFielddataMaxFrequency(this.fielddataMaxFrequency());
        }

        public int fielddataMinSegmentSize() {
            return this.delegateType.fielddataMinSegmentSize();
        }

        public void setFielddataMinSegmentSize(int fielddataMinSegmentSize) {
            this.delegateType.setFielddataMinSegmentSize(fielddataMinSegmentSize);
        }

        public String typeName() {
            return PreAnalyzedMapper.CONTENT_TYPE;
        }

        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            return this.delegateType.prefixQuery(value, method, context);
        }

        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
            return this.delegateType.spanPrefixQuery(value, method, context);
        }

        public Query existsQuery(QueryShardContext context) {
            return this.delegateType.existsQuery(context);
        }

        public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements) throws IOException {
            Query query = this.delegateType.phraseQuery(stream, slop, enablePosIncrements);
            return query;
        }

        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            return this.delegateType.multiPhraseQuery(stream, slop, enablePositionIncrements);
        }

        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
            return this.delegateType.phrasePrefixQuery(stream, slop, maxExpansions);
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            return this.delegateType.fielddataBuilder(fullyQualifiedIndexName);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseTextField((FieldMapper.Builder)builder, (String)name, node, (Mapper.TypeParser.ParserContext)parserContext);
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private boolean fielddata;
        private SimilarityProvider similarity;
        private double fielddataMinFreq;
        private double fielddataMaxFreq;
        private int fielddataMinSegSize;

        protected Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder fielddata(boolean fielddata) {
            this.fielddata = fielddata;
            return (Builder)this.builder;
        }

        public void similarity(SimilarityProvider similarity) {
            this.similarity = similarity;
        }

        public Builder fielddataFrequencyFilter(double minFreq, double maxFreq, int minSegmentSize) {
            this.fielddataMinFreq = minFreq;
            this.fielddataMaxFreq = maxFreq;
            this.fielddataMinSegSize = minSegmentSize;
            return (Builder)this.builder;
        }

        public FieldMapper build(Mapper.BuilderContext context) {
            FieldType fieldTypeText = new FieldType((IndexableFieldType)this.fieldType);
            fieldTypeText.setIndexOptions(IndexOptions.NONE);
            fieldTypeText.setTokenized(false);
            fieldTypeText.setStored(this.fieldType.stored());
            fieldTypeText.setStoreTermVectors(false);
            fieldTypeText.setStoreTermVectorPositions(false);
            fieldTypeText.setStoreTermVectorOffsets(false);
            fieldTypeText.setStoreTermVectorPayloads(false);
            FieldType fieldTypeIndexed = new FieldType((IndexableFieldType)this.fieldType);
            fieldTypeIndexed.setStored(false);
            return new PreAnalyzedMapper(this.name, this.fieldType, (MappedFieldType)this.buildFieldType(context), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo, fieldTypeText, fieldTypeIndexed);
        }

        private PreanalyzedFieldType buildFieldType(Mapper.BuilderContext context) {
            TextFieldMapper.TextFieldType templateFt = new TextFieldMapper.TextFieldType(this.buildFullName(context), this.fieldType, this.similarity, this.searchAnalyzer, this.searchQuoteAnalyzer, this.meta);
            templateFt.setIndexAnalyzer(this.indexAnalyzer);
            templateFt.setEagerGlobalOrdinals(this.eagerGlobalOrdinals);
            if (this.fielddata) {
                templateFt.setFielddata(true);
                templateFt.setFielddataMinFrequency(this.fielddataMinFreq);
                templateFt.setFielddataMaxFrequency(this.fielddataMaxFreq);
                templateFt.setFielddataMinSegmentSize(this.fielddataMinSegSize);
            }
            PreanalyzedFieldType preanalyzedFieldType = new PreanalyzedFieldType(templateFt);
            preanalyzedFieldType.setIndexAnalyzer(this.indexAnalyzer);
            preanalyzedFieldType.setEagerGlobalOrdinals(this.eagerGlobalOrdinals);
            return preanalyzedFieldType;
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setOmitNorms(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.freeze();
        }
    }
}

